/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public class RangeUtils {
    public static <C extends Comparable<C>> C minNull(C x, C y) {
        if (x == null || y == null) {
            return null;
        }
        if (x.compareTo(y) <= 0) {
            return x;
        }
        return y;
    }

    public static <C extends Comparable<C>> C min(C x, C y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.compareTo(y) <= 0) {
            return x;
        }
        return y;
    }

    public static <C> C minNull(Comparator<C> comp, C x, C y) {
        if (x == null || y == null) {
            return null;
        }
        if (comp.compare(x, y) <= 0) {
            return x;
        }
        return y;
    }

    public static <C> C min(Comparator<C> comp, C x, C y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (comp.compare(x, y) <= 0) {
            return x;
        }
        return y;
    }

    public static <C extends Comparable<C>> C maxNull(C x, C y) {
        if (x == null || y == null) {
            return null;
        }
        if (x.compareTo(y) >= 0) {
            return x;
        }
        return y;
    }

    public static <C extends Comparable<C>> C max(C x, C y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.compareTo(y) >= 0) {
            return x;
        }
        return y;
    }

    public static <C> C maxNull(Comparator<C> comp, C x, C y) {
        if (x == null || y == null) {
            return null;
        }
        if (comp.compare(x, y) >= 0) {
            return x;
        }
        return y;
    }

    public static <C> C max(Comparator<C> comp, C x, C y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (comp.compare(x, y) >= 0) {
            return x;
        }
        return y;
    }

    public static <C extends Comparable<C>, R> List<R> subListIn(Collection<R> list, Ranger<R, C> ranger, C x, C y) {
        ArrayList<R> result = new ArrayList<R>(list.size() / 2);
        for (R r : list) {
            Comparable y1;
            Comparable x1;
            if (x != null && ((x1 = (Comparable)ranger.getMinValue(r)) == null || x.compareTo((Comparable)x1) > 0) || y != null && ((y1 = (Comparable)ranger.getMaxValue(r)) == null || y1.compareTo(y) > 0)) continue;
            result.add(r);
        }
        return result;
    }

    public static <C extends Comparable<C>, R> List<R> subListContains(Collection<R> list, Ranger<R, C> ranger, C x, C y) {
        ArrayList<R> result = new ArrayList<R>(Math.min(5, list.size() / 2));
        for (R r : list) {
            Comparable x1 = (Comparable)ranger.getMinValue(r);
            Comparable y1 = (Comparable)ranger.getMaxValue(r);
            if (x1 != null && (x == null || x1.compareTo(x) > 0) || y1 != null && (y == null || y.compareTo((Comparable)y1) > 0)) continue;
            result.add(r);
        }
        return result;
    }

    public static <C extends Comparable<C>, R> List<R> subListContains(Collection<R> list, Matcher<R> matcher, Ranger<R, C> ranger, C x, C y) {
        ArrayList<R> result = new ArrayList<R>(Math.min(5, list.size() / 2));
        for (R r : list) {
            Comparable x1 = (Comparable)ranger.getMinValue(r);
            Comparable y1 = (Comparable)ranger.getMaxValue(r);
            if (!matcher.matched(r) || x1 != null && (x == null || x1.compareTo(x) > 0) || y1 != null && (y == null || y.compareTo((Comparable)y1) > 0)) continue;
            result.add(r);
        }
        return result;
    }

    public static <C extends Comparable<C>, R> List<R> extractListContains(Collection<R> list, Ranger<R, C> ranger, C x, C y) {
        ArrayList<R> result = new ArrayList<R>(Math.min(5, list.size() / 2));
        Iterator<R> iter = list.iterator();
        while (iter.hasNext()) {
            R r = iter.next();
            Comparable x1 = (Comparable)ranger.getMinValue(r);
            Comparable y1 = (Comparable)ranger.getMaxValue(r);
            if (x1 != null && (x == null || x1.compareTo(x) > 0) || y1 != null && (y == null || y.compareTo((Comparable)y1) > 0)) continue;
            result.add(r);
            iter.remove();
        }
        return result;
    }

    public static <C extends Comparable<C>> C[] intersectionOr(C[] result, C x1, C y1, C x2, C y2) {
        assert (result != null && result.length == 2);
        if (!(x1 != null && y2 != null && x1.compareTo(y2) > 0 || x2 != null && y1 != null && x2.compareTo(y1) > 0)) {
            result[0] = RangeUtils.minNull(x1, x2);
            result[1] = RangeUtils.maxNull(y1, y2);
            return result;
        }
        return null;
    }

    public static <C> C[] intersectionOr(C[] result, Comparator<C> comp, C x1, C y1, C x2, C y2) {
        assert (result != null && result.length == 2);
        if (!(x1 != null && y2 != null && comp.compare(x1, y2) > 0 || x2 != null && y1 != null && comp.compare(x2, y1) > 0)) {
            result[0] = RangeUtils.minNull(comp, x1, x2);
            result[1] = RangeUtils.maxNull(comp, y1, y2);
            return result;
        }
        return null;
    }

    public static <C extends Comparable<C>> C[] intersectionAnd(C[] result, C x1, C y1, C x2, C y2) {
        assert (result != null && result.length == 2);
        C c1 = RangeUtils.max(x1, x2);
        C c2 = RangeUtils.min(y1, y2);
        if (c1 == null || c2 == null || c1.compareTo(c2) <= 0) {
            result[0] = c1;
            result[1] = c2;
            return result;
        }
        return null;
    }

    public static long[] intersectionAnd(long[] result, long x1, long y1, long x2, long y2) {
        long c2;
        long c1;
        assert (result != null && result.length == 2);
        long l = x1 == 0L ? x2 : (x2 == 0L ? x1 : (c1 = x1 >= x2 ? x1 : x2));
        long l2 = y1 == 0L ? y2 : (y2 == 0L ? y1 : (c2 = y1 <= y2 ? y1 : y2));
        if (c1 == 0L || c2 == 0L || c1 <= c2) {
            result[0] = c1;
            result[1] = c2;
            return result;
        }
        return null;
    }

    public static <C> C[] intersectionAnd(C[] result, Comparator<C> comp, C x1, C y1, C x2, C y2) {
        assert (result != null && result.length == 2);
        if (!(x1 != null && y2 != null && comp.compare(x1, y2) > 0 || x2 != null && y1 != null && comp.compare(x2, y1) > 0)) {
            result[0] = RangeUtils.max(comp, x1, x2);
            result[1] = RangeUtils.min(comp, y1, y2);
            return result;
        }
        return null;
    }

    public static <C extends Comparable<C>> boolean inRange(C checking1, C checking2, C rangeStart, C rangeEnd) {
        return (rangeStart == null || checking1 != null && rangeStart.compareTo(checking1) <= 0) && (rangeEnd == null || checking2 != null && rangeEnd.compareTo(checking2) >= 0);
    }

    public static <C> boolean inRange(Comparator<C> comparator, C checking1, C checking2, C rangeStart, C rangeEnd) {
        return (rangeStart == null || checking1 != null && comparator.compare(rangeStart, checking1) <= 0) && (rangeEnd == null || checking2 != null && comparator.compare(rangeEnd, checking2) >= 0);
    }

    public static boolean inRange(long checking1, long checking2, long rangeStart, long rangeEnd) {
        return (rangeStart == 0L || checking1 != 0L && rangeStart <= checking1) && (rangeEnd == 0L || checking2 != 0L && rangeEnd >= checking2);
    }

    public static <C extends Comparable<C>> boolean intersects(C checking1, C checking2, C rangeStart, C rangeEnd) {
        return !(rangeStart != null && checking2 != null && rangeStart.compareTo(checking2) > 0 || rangeEnd != null && checking1 != null && rangeEnd.compareTo(checking1) < 0);
    }

    public static boolean intersects(long x1, long y1, long x2, long y2) {
        return !(x2 != 0L && y1 != 0L && x2 > y1 || y2 != 0L && x1 != 0L && y2 < x1);
    }

    public static <C> boolean intersects(Comparator<C> comparator, C checking1, C checking2, C rangeStart, C rangeEnd) {
        return !(rangeStart != null && checking2 != null && comparator.compare(rangeStart, checking2) > 0 || rangeEnd != null && checking1 != null && comparator.compare(rangeEnd, checking1) < 0);
    }
}

