/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor;

import bitel.billing.server.processor.LC_TimeCondition;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class LC_LoginServiceCondition {
    public static final int FOR_MONTH = 0;
    public static final int FOR_DAY = 1;
    public static final int PHONE_CONDITION = 1;
    public static final int TIME_CONDITION = 2;
    public static final int SERVICE_AMOUNT_CONDITION = 3;
    public static final int MONEY_AMOUNT_CONDITION = 4;
    public static final int FROM_PHONE_CONDITION = 5;
    private int conditionType = 0;
    private String param1;
    private String param2;
    private Calendar date1;
    private Calendar date2;
    private int id = 0;
    private int moduleId = 0;
    private int lid = 0;
    private List<Integer> sids = new ArrayList<Integer>();
    private String sidsString = "0";
    private Calendar last_call = null;
    private long service_rest = 0L;
    private float money_rest = 0.0f;
    private List<LC_TimeCondition> time_conditions = new ArrayList<LC_TimeCondition>();

    public LC_LoginServiceCondition(int id, int moduleId, Connection con) {
        this.id = id;
        this.moduleId = moduleId;
        this.startInit(con);
    }

    private synchronized void startInit(Connection con) {
        this.initCondition(con);
        if (this.conditionType == 3 || this.conditionType == 4) {
            this.setAmount();
            this.initAmount();
        }
    }

    private void setAmount() {
        if (this.conditionType == 3) {
            this.service_rest = Utils.parseLong((String)this.param1, (long)0L);
        } else if (this.conditionType == 4) {
            this.money_rest = Utils.parseFloat((String)this.param1, (float)0.0f) / 100.0f;
        }
    }

    private void initAmount() {
        Map<String, Object> sums = null;
        if ((this.conditionType == 3 || this.conditionType == 4) && this.param2.equals("1")) {
            sums = this.sumAmountForLast(new GregorianCalendar(), 0);
        } else if ((this.conditionType == 3 || this.conditionType == 4) && this.param2.equals("0")) {
            sums = this.sumAmountForLast(new GregorianCalendar(), 1);
        }
        if (sums != null) {
            this.service_rest -= ((Long)sums.get("service")).longValue();
            this.money_rest -= ((Float)sums.get("money")).floatValue();
            if (this.service_rest < 0L) {
                this.service_rest = 0L;
            }
            if (this.money_rest < 0.0f) {
                this.money_rest = 0.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sumAmountForLast(Calendar date, int day_or_month) {
        long sum_service;
        float sum_money;
        HashMap<String, Object> result;
        block10: {
            result = new HashMap<String, Object>();
            sum_money = 0.0f;
            sum_service = 0L;
            String table_name = "login_account_" + this.moduleId + "_" + TimeUtils.format((Date)date.getTime(), (String)"yyyyMM");
            int year = date.get(1);
            int month = date.get(2);
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                if (!ServerUtils.tableExists(con, table_name) || this.sids.isEmpty()) break block10;
                String query_m = "SELECT * FROM " + table_name + " WHERE lid=" + this.lid + " AND sid IN ( " + this.sidsString + " )";
                String query_d = query_m + " AND dm=" + date.get(5);
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery(day_or_month == 0 ? query_d : query_m);
                if (this.time_conditions.size() == 0) {
                    while (rs.next()) {
                        sum_money += rs.getFloat("sum");
                        sum_service += rs.getLong("amount");
                    }
                } else {
                    for (LC_TimeCondition tc : this.time_conditions) {
                        if (!tc.check_month(month) || !rs.first()) continue;
                        do {
                            if (!tc.check(year, month, rs.getInt("dm"), rs.getInt("hh"))) continue;
                            sum_money += rs.getFloat("sum");
                            sum_service += rs.getLong("amount");
                        } while (rs.next());
                    }
                }
                rs.close();
                st.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LogManager.getLogger().error("sids='{}'", (Object)this.sidsString);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        result.put("service", sum_service);
        result.put("money", Float.valueOf(sum_money));
        return result;
    }

    public boolean isConditionWorking(Hashtable<String, ?> params) {
        Calendar time = (Calendar)params.get("time");
        if (time == null) {
            return false;
        }
        time = TimeUtils.clear_MIN_MIL_SEC((Calendar)time);
        if (this.time_conditions.size() == 0) {
            return true;
        }
        if (this.date1 != null && TimeUtils.dateBefore((Calendar)time, (Calendar)this.date1) || this.date2 != null && TimeUtils.dateBefore((Calendar)this.date2, (Calendar)time)) {
            return false;
        }
        for (LC_TimeCondition tc : this.time_conditions) {
            if (!tc.check(time) || !tc.check_month(time.get(2))) continue;
            return true;
        }
        return false;
    }

    public boolean canComeIn(Hashtable<String, Object> params, boolean access) {
        boolean result = access;
        if (this.conditionType == 1) {
            String phone = (String)params.get("phone");
            if (phone != null && (this.param2.equals(phone) || this.param2.equals("*"))) {
                result = this.param1.equals("0");
            }
        } else if (this.conditionType == 5) {
            String phone = (String)params.get("from_phone");
            if (phone != null && (this.param2.equals(phone) || this.param2.equals("*"))) {
                result = this.param1.equals("0");
            }
        } else if (this.conditionType == 2) {
            result = this.param1.equals("0");
        } else if (this.conditionType == 3 || this.conditionType == 4) {
            params.put("need_service", 1L);
            params.put("need_money", Float.valueOf(1.0f));
            Hashtable<String, Object> rests = this.getRests(params, false);
            Long serv = (Long)rests.get("service");
            Float money = (Float)rests.get("money");
            result = serv != null && money != null && serv > 0L && money.floatValue() > 0.0f;
        }
        return result;
    }

    public Hashtable<String, Object> getRests(Hashtable<String, Object> params, boolean subst) {
        Float need_money = (Float)params.get("need_money");
        Long need_service = (Long)params.get("need_service");
        float money_result = need_money.floatValue();
        long service_result = need_service;
        if (this.conditionType == 2 && this.param2.equals("1")) {
            if (this.param1.equals("1")) {
                money_result = 0.0f;
                service_result = 0L;
            } else {
                money_result = need_money.floatValue();
                this.service_rest = need_service;
            }
        } else {
            Calendar time = (Calendar)params.get("time");
            if (this.param2.equals(String.valueOf(0)) && this.last_call != null && time.get(2) != this.last_call.get(2) || this.param2.equals(String.valueOf(1)) && this.last_call != null && time.get(5) != this.last_call.get(5)) {
                this.setAmount();
            }
            if (this.conditionType == 4) {
                money_result = Math.min(need_money.floatValue(), this.money_rest);
                if (subst) {
                    this.money_rest -= money_result;
                }
            } else if (this.conditionType == 3) {
                service_result = Math.min(need_service, this.service_rest);
                if (subst) {
                    this.service_rest -= service_result;
                }
            }
            this.last_call = (Calendar)time.clone();
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("service", service_result);
        result.put("money", Float.valueOf(money_result));
        return result;
    }

    private void initCondition(Connection con) {
        try {
            String table_name = "user_login_limit_" + this.moduleId;
            String query = "SELECT * FROM " + table_name + " WHERE id = " + this.id;
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                if (rs.getDate("date1") != null) {
                    this.date1 = new GregorianCalendar();
                    this.date1.setTime(rs.getDate("date1"));
                    this.date1 = TimeUtils.clear_MIN_MIL_SEC((Calendar)this.date1);
                }
                if (rs.getDate("date2") != null) {
                    this.date2 = new GregorianCalendar();
                    this.date2.setTime(rs.getDate("date2"));
                    this.date2 = TimeUtils.clear_MIN_MIL_SEC((Calendar)this.date2);
                }
                this.param1 = rs.getString("param1");
                this.param2 = rs.getString("param2");
                String s = rs.getString("sid");
                if (s != null) {
                    StringBuffer buf = new StringBuffer();
                    StringTokenizer stTokenizer = new StringTokenizer(s, ",");
                    while (stTokenizer.hasMoreTokens()) {
                        try {
                            String sidString = stTokenizer.nextToken().trim();
                            this.sids.add(Integer.valueOf(sidString));
                            if (buf.length() > 0) {
                                buf.append(", ");
                            }
                            buf.append(sidString);
                        }
                        catch (Exception exception) {}
                    }
                    this.sidsString = buf.toString();
                }
                this.lid = rs.getInt("lid");
                this.conditionType = rs.getInt("type_con");
            }
            rs.close();
            table_name = "user_login_condition_" + this.moduleId;
            query = "SELECT * FROM " + table_name + " WHERE llid = " + this.id;
            rs = st.executeQuery(query);
            while (rs.next()) {
                this.time_conditions.add(new LC_TimeCondition(rs.getInt("mm"), rs.getInt("dw"), rs.getInt("dm"), rs.getInt("hh")));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean workForServiceId(int sid) {
        boolean result = this.conditionType == 2 && this.param2.equals("1") || this.sids.contains(sid);
        return result;
    }

    @Deprecated
    public boolean workForServiceID(int sid) {
        return this.workForServiceId(sid);
    }

    public int getConditionType() {
        return this.conditionType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + "; ");
        sb.append("sids: " + this.sidsString + "; ");
        sb.append("type: ");
        switch (this.conditionType) {
            case 1: {
                sb.append("PHONE_ACCESS");
                break;
            }
            case 2: {
                sb.append("TIME_ACCESS");
                break;
            }
            case 3: {
                sb.append("TIME_AMOUNT");
                break;
            }
            case 4: {
                sb.append("MONEY_AMOUNT");
            }
        }
        sb.append("; ");
        sb.append("param1: " + this.param1 + " param2: " + this.param2);
        sb.append("\n\ttime_cinditions: " + this.time_conditions.size());
        return sb.toString();
    }
}

