/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import jakarta.activation.DataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.ConditionCheckerFactory;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.message.CustomDispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.message.DispatchMessageFactory;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchFileStorageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchMessageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleRequest;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleRequestGenerator;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleResponse;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.EmailSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.SenderFactory;
import ru.bitel.bgbilling.plugins.dispatch.server.utils.DispatchUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class MessageProcessor
extends BGLogger {
    protected static final Pattern macroPattern = Pattern.compile("\\$\\$\\{(\\S+)\\}");
    private final BGPluginServer plugin;
    private final DispatchMessageDao messageDao;
    protected Connection con;

    public MessageProcessor(Connection con) {
        this.con = con;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
        this.messageDao = new DispatchMessageDao(con);
    }

    protected final ProcessResult processMacro(String messageBody, Subscription sub) throws Exception {
        ProcessResult result = new ProcessResult();
        result.messageBody = messageBody;
        int contractId = sub.getContractId();
        Contract contract = null;
        StringBuilder sb = new StringBuilder();
        Matcher m = macroPattern.matcher(messageBody);
        try (BalanceUtils bu = new BalanceUtils(this.con);
             ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);){
            ContractParameterPrefDao prefDao = new ContractParameterPrefDao(this.con);
            while (m.find()) {
                String subresult = "";
                String substr = m.group(1);
                if (substr != null) {
                    if (substr.equals("title") || substr.equals("comment")) {
                        if (contract == null) {
                            contract = ContractDao.getContract((Connection)this.con, (int)contractId);
                        }
                        subresult = substr.equals("title") ? contract.getTitle() : contract.getComment();
                    } else if (substr.startsWith("parameter")) {
                        split = substr.split(":");
                        if (split.length < 2) continue;
                        int pid = Utils.parseInt((String)split[1]);
                        subresult = Utils.maskNull((String)((String)contractParameterManager.getValuesForPids(Utils.toIntegerSet((String)("" + pid)), contractId).get(pid)));
                        if (Utils.notBlankString((String)subresult) && ContractParameterPrefType.TYPE_FLAG == ((ContractParameterPref)prefDao.get(pid)).getType()) {
                            subresult = Utils.parseBoolean((String)subresult) ? "\u0434\u0430" : "\u043d\u0435\u0442";
                        }
                    } else if (substr.equals("balance")) {
                        subresult = Utils.formatBigDecimal((BigDecimal)bu.getBalance(LocalDate.now(), contractId), (int)2);
                    } else if (substr.equals("saldo")) {
                        subresult = Utils.formatBigDecimal((BigDecimal)bu.getSaldo(new Date(), contractId), (int)2);
                    } else if (substr.startsWith("class")) {
                        split = substr.split(":");
                        if (split.length < 2) continue;
                        try {
                            CustomDispatchMessage customMessage = DispatchMessageFactory.getMessage(split[1]);
                            customMessage.setConnection(this.con);
                            customMessage.setContractId(contractId);
                            subresult = customMessage.getMessageBody();
                        }
                        catch (Exception e) {
                            this.getLogger().error(MessageFormat.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430 {0} \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0441 id={1}", split[1], sub.getId()), (Throwable)e);
                        }
                    } else if (substr.startsWith("module")) {
                        split = substr.split(":");
                        if (split.length < 3) continue;
                        int moduleId = Utils.parseInt((String)split[1]);
                        String function = split[2];
                        ModuleRequest request = ModuleRequestGenerator.generateRequest(moduleId);
                        ModuleResponse response = request.ask(this.con, contractId, moduleId, function, sub.getPreferences());
                        subresult = response.getMessage();
                        if (response.getFile() != null) {
                            result.messageFiles.add(response.getFile());
                        }
                    } else if (substr.equals("date")) {
                        subresult = TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy");
                    } else if (substr.equals("datetime")) {
                        subresult = TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm");
                    }
                }
                if (subresult == null) continue;
                m.appendReplacement(sb, Matcher.quoteReplacement(subresult));
            }
        }
        m.appendTail(sb);
        result.messageBody = sb.toString();
        return result;
    }

    public final void send(Dispatch dispatch, List<Subscription> subs, DispatchMessage message, DispatchService dispatchService) throws Exception {
        Sender sender;
        List<DataSource> messageInclusion = this.getInclusionDataSource(message);
        try {
            sender = SenderFactory.getSender(dispatch.getSenderType().getClassName());
        }
        catch (Exception ex) {
            throw new BGException("Error while dispatching " + dispatch.toString(), (Throwable)ex);
        }
        boolean isMessageSended = false;
        for (Subscription subscription : subs) {
            List<Contact> contactList;
            int typeId;
            List contacts;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\t\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a \u0441 \u043a\u043e\u0434\u043e\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + subscription.getContractId());
                this.getLogger().debug("\t\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            }
            if (!this.acceptAll(dispatch, subscription)) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\t\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043c\u0430\u043a\u0440\u043e\u0441\u043e\u0432 \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0438");
            }
            ProcessResult titleMacrosResult = this.processMacro(message.getTitle(), subscription);
            ProcessResult macrosResult = this.processMacro(message.getMessageBody(), subscription);
            macrosResult.messageFiles.addAll(messageInclusion);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\t\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u043f\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430\u043c \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430 ");
            }
            if (Utils.isEmptyCollection((Collection)(contacts = subscription.getContacts())) && ((typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, this.con)) == ContractParameterPrefType.TYPE_EMAIL.getId() || typeId == ContractParameterPrefType.TYPE_PHONE.getId()) && Utils.notEmptyCollection((Collection)(contactList = dispatchService.getContacts(subscription.getContractId(), dispatch)))) {
                for (Contact contact : contactList) {
                    if (contact.getId() <= 0) continue;
                    this.getLogger().warn("\u0412 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0432 \u043f\u043b\u0430\u0433\u0438\u043d\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442. \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u043f\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430\u043c \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    contactList = DispatchUtils.getContactsFromContractParameters(subscription.getContractId(), dispatch, this.con);
                }
                contacts.addAll(contactList);
            }
            boolean unsubscribe = false;
            if (sender instanceof EmailSender) {
                unsubscribe = this.plugin.getSetup().getBoolean("dispatch.email.unsubscribe", false);
            }
            HashMap<Contact, String> mapContacts = new HashMap<Contact, String>();
            for (Contact contact : contacts) {
                Object messageBody = macrosResult.messageBody;
                if (unsubscribe) {
                    messageBody = (String)messageBody + this.getUnsubscribeLink(subscription, contact);
                }
                mapContacts.put(contact, (String)messageBody);
            }
            if (mapContacts.isEmpty() && dispatch.isWoContactType()) {
                sender.send(null, Utils.maskNull((String)titleMacrosResult.messageBody), macrosResult.messageBody, macrosResult.messageFiles, subscription);
            }
            for (Map.Entry entry : mapContacts.entrySet()) {
                Contact contact = (Contact)entry.getKey();
                try {
                    if (!dispatch.isWoContactType() && Utils.isBlankString((String)contact.getValueForSend())) {
                        this.getLogger().debug(String.format("\t\t\u0423 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c %d \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043a\u043e\u043d\u0442\u0430\u043a\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c %d", subscription.getId(), contact.getId()));
                        continue;
                    }
                    sender.send(contact, Utils.maskNull((String)titleMacrosResult.messageBody), Utils.maskNull((String)((String)entry.getValue())), macrosResult.messageFiles, subscription);
                    if (subscription.isUpdate()) {
                        dispatchService.updateSubscriptions(subscription);
                    }
                    isMessageSended = true;
                    this.messageDao.addMessageStatistic(DispatchMessageStatistic.builder().setSendDate(new Date()).setContactId(contact.getId()).setContactValue(contact.getValueForSend()).setMessageText(Utils.maskNull((String)macrosResult.messageBody)).setContractId(subscription.getContractId()).setDispatchId(subscription.getDispatch().getId()).setMessageId(message.getId()).build());
                }
                catch (BGException ex) {
                    this.getLogger().error(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441 \u043a\u043e\u0434\u043e\u043c %d \u043f\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u0441 \u043a\u043e\u0434\u043e\u043c %d. \u041f\u0440\u0438\u0447\u0438\u043d\u0430: %s", message.getId(), subscription.getId(), ex.getMessage()), (Throwable)ex);
                }
            }
        }
        if (isMessageSended) {
            message.setSendDate(new Date());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\t\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441 \u043a\u043e\u0434\u043e\u043c " + message.getId() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
            }
            if (!dispatch.isDoNotMarkSended()) {
                message.setSent(true);
            }
            dispatchService.updateMessage(message);
        }
    }

    private List<DataSource> getInclusionDataSource(DispatchMessage message) throws BGException {
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
        DispatchFileStorageDao fileManager = new DispatchFileStorageDao(this.con, plugin);
        List<BGServerFile> messageInclusion = fileManager.getFileList((Id)message);
        return messageInclusion.stream().map(fileManager::getDataSource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean acceptAll(Dispatch dispatch, Subscription sub) {
        try {
            for (DispatchCondition condition : dispatch.getConditions()) {
                if (ConditionCheckerFactory.getChecker(condition.getClass()).check(this.con, condition, dispatch, sub)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.logError(ex);
            return false;
        }
    }

    private String getUnsubscribeLink(Subscription subscription, Contact contact) {
        StringBuilder unsubscribeLink = new StringBuilder("<br><p><a href=\"");
        Object serverUrl = this.plugin.getSetup().get("billing.url");
        serverUrl = ((String)serverUrl).endsWith("/") ? serverUrl : (String)serverUrl + "/";
        unsubscribeLink.append((String)serverUrl + "dispatchexecutor?contractId=" + subscription.getContractId() + ";subscriberId=" + subscription.getContactHash(contact) + "\">");
        unsubscribeLink.append(this.plugin.getSetup().get("dispatch.unsubscribe.text", "\u041e\u0442\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043e\u0442 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 email"));
        unsubscribeLink.append("</a></p>");
        return unsubscribeLink.toString();
    }

    static class ProcessResult {
        String messageBody = null;
        List<DataSource> messageFiles = new ArrayList<DataSource>();

        ProcessResult() {
        }
    }
}

