/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.call.bean.Session;
import bitel.billing.server.processor.NASSession;
import bitel.billing.server.radius.RadiusSetup;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.DatagramChannelListener;

public class ISGNasConnectionInspector
extends NasConnectionInspector {
    private static final Logger logger = LogManager.getLogger();
    private String host;
    private int port;
    private byte[] secret;
    private Set<String> attributes = new HashSet<String>();
    private RadiusAttributeSet podFixedAttributes;
    private int identifier = 0;
    private ConcurrentMap<Long, WeakReference<NasConnection<?>>> modifyQueue = new ConcurrentHashMap();
    private DatagramChannelListener listener = new DatagramChannelListener(-1, 262144){

        public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
            try {
                RadiusPacket response = RadiusPacket.parse(data);
                if (response.getCode() == 42) {
                    RadiusAttribute.RadiusAttributeInteger nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)response.getAttribute(-1, 5);
                    if (nasPortAttribute != null) {
                        String nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())));
                        ISGNasConnectionInspector.this.fireNotKilled(nasPort);
                    }
                } else if (response.getCode() == 44 || response.getCode() == 45) {
                    NasConnection con;
                    WeakReference conRef = (WeakReference)ISGNasConnectionInspector.this.modifyQueue.remove(response.identifier);
                    NasConnection nasConnection = con = conRef != null ? (NasConnection)conRef.get() : null;
                    if (con != null) {
                        ((Session)con.getSession()).addLogInfo("CoA packet response " + response.getCode());
                        if (response.getCode() == 44) {
                            ISGNasConnectionInspector.this.fireModified(con, response.identifier);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    };

    public ISGNasConnectionInspector(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connections, ParameterMap params, NasConnectionInspector old) {
        super(setup, nasIPAddress, secret, connections, params, old);
        String[] tokens;
        this.host = params.get("nas.inspector.radius.host", nasIPAddress.getHostAddress());
        this.port = params.getInt("nas.inspector.radius.port", 0);
        this.secret = params.get("nas.inspector.radius.secret", new String(secret)).getBytes();
        String attributes = params.get("nas.inspector.radius.attributes", "");
        for (String token : tokens = attributes.split("\\s*;\\s*")) {
            this.attributes.add(token);
        }
        String podFixedAttributes = params.get("nas.inspector.pod.fixed.attributes", "");
        if (Utils.notBlankString((String)podFixedAttributes)) {
            this.podFixedAttributes = RadiusAttributeSet.newRadiusAttributeSet(podFixedAttributes);
        }
        this.listener.init();
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
        this.listener.shutdown();
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> con) {
    }

    private RadiusPacket createRequest(byte code, NASSession session) {
        int address;
        int identifier = this.identifier++;
        if (this.identifier >= 256) {
            this.identifier = 0;
        }
        RadiusPacket packet = new RadiusPacket(code, (byte)(identifier & 0xFF));
        if (this.attributes.size() == 0 || this.attributes.contains("NAS-Port")) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeInteger(-1, 5, Utils.parseInt((String)session.getNasPort(), (int)0)));
        }
        if (this.attributes.size() == 0 || this.attributes.contains("Acct-Session-Id")) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 44, session.getAcctSessionId()));
        }
        if (this.attributes.size() == 0 || this.attributes.contains("User-Name")) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 1, session.getLoginName()));
        }
        if (this.attributes.size() == 0 || this.attributes.contains("Framed-IP-Address")) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, IPUtils.convertStringIPtoInt((String)IPUtils.convertLongIpToString((long)session.getIpAddress()))));
        }
        if ((this.attributes.size() == 0 || this.attributes.contains("NAS-IP-Address")) && (address = Utils.convertBytesToInt((byte[])this.nas.getNasIPAddress().getAddress())) != 0) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeIpAddr(-1, 4, address));
        }
        if (this.attributes.size() == 0 || this.attributes.contains("NAS-Identifier")) {
            packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 32, this.nas.getNasIdentifier()));
        }
        if (code == 40 && this.podFixedAttributes != null) {
            packet.addAttributes(this.podFixedAttributes);
        }
        return packet;
    }

    private void send(RadiusPacket packet, NASSession session) throws SocketException, InvalidKeyException, NoSuchAlgorithmException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[4096]);
        packet.write(bb, this.secret);
        bb.flip();
        try {
            this.listener.send((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.host), this.port), bb);
        }
        catch (Exception e) {
            session.addLogError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected long sendKillRequest(NasConnection<?> con) {
        NASSession session = (NASSession)con.getSession();
        try {
            RadiusPacket packet = this.createRequest((byte)40, session);
            this.send(packet, session);
            session.addLogInfo("PoD reset packet on " + this.host + ":" + this.port + "\n" + packet.toString());
            return packet.identifier;
        }
        catch (Exception e) {
            session.addLogError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    protected void onIdle() throws InterruptedException {
        if (this.listener.select(500L) > 0) {
            while (this.listener.select(50L) > 0) {
            }
        }
    }
}

