/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.config.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.common.TimeUtils;

public class ConfigDAO
extends AbstractIdDao<ConfigData> {
    public ConfigDAO(Connection con) {
        super(con, "module_config");
    }

    public List<ConfigData> list(int moduleId) throws SQLException {
        return this.list(moduleId, true);
    }

    public ConfigData getActiveConfig(int moduleId) throws SQLException {
        return (ConfigData)this.get("active=true AND mid=?", moduleId);
    }

    public List<ConfigData> list(int moduleId, boolean loadConfig) throws SQLException {
        List<ConfigData> list = super.list("mid=?", "title", moduleId);
        if (!loadConfig) {
            list.forEach(a -> a.setConfig(""));
        }
        return list;
    }

    @Override
    protected ConfigData getFromRS(ResultSet resultSet) throws SQLException {
        return ConfigData.builder().setId(resultSet.getInt("id")).setModuleId(resultSet.getInt("mid")).setTitle(resultSet.getString("title")).setConfig(resultSet.getString("config")).setUserId(resultSet.getInt("uid")).setActive(resultSet.getBoolean("active")).setLastEdited(resultSet.getTimestamp("dt")).build();
    }

    @Override
    protected void updateImpl(ConfigData configData) throws SQLException {
        Objects.requireNonNull(configData);
        boolean update = configData.getId() > 0;
        String query = this.sqlCommandAndTable(update) + " SET mid=?, dt=?, title=?, uid=?, config=?, active=?" + this.sqlWhereId(update);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, configData.getModuleId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(configData.getLastEdited()));
            ps.setString(index++, configData.getTitle());
            ps.setInt(index++, configData.getUserId());
            ps.setString(index++, configData.getConfig());
            ps.setBoolean(index++, configData.isActive());
            this.executeUpdate(configData, index, ps);
        }
    }

    public void setActiveModuleConfig(int moduleId, int configId) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET active=(id=?) WHERE mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, configId);
            ps.setInt(2, moduleId);
            ps.executeUpdate();
        }
    }
}

