/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory.organization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItem;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItemType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;

public class OrgListItemCellRenderer
implements ListCellRenderer<OrgListItem> {
    private JPanel organizationPanel = null;
    private JLabel organizationTitleLabel = new JLabel();
    private JPanel bankAccountPanel = null;
    private JLabel bankAccountTitleLabel = new JLabel();
    private JLabel bankAccountInfoLabel = new JLabel();
    private Font normalFont = null;
    private Font normalOrgFont = null;
    private Font addFont = null;
    private Color normalColor = null;
    private Color normalOrgColor = new Color(200, 200, 200);
    private Color addColor = new Color(140, 140, 140);

    public OrgListItemCellRenderer() {
        this.normalFont = this.bankAccountInfoLabel.getFont();
        this.normalColor = this.bankAccountInfoLabel.getForeground();
        this.addFont = new Font("SansSerif", 2, 11);
        this.normalOrgFont = new Font("SansSerif", 1, 15);
        this.bankAccountInfoLabel.setFont(new Font("SansSerif", 2, 12));
        this.bankAccountInfoLabel.setForeground(new Color(100, 100, 100));
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends OrgListItem> list, OrgListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = null;
        OrgListItemType orgListItemType = value.getItemType();
        if (orgListItemType.equals((Object)OrgListItemType.ORG)) {
            panel = this.getOrganizationPanel();
            this.setOrganizationPanelData(value);
        } else {
            panel = this.getBankAccountPanel();
            this.setBankAccountPanelData(value);
        }
        Color bgColor = null;
        Color fgColor = null;
        if (isSelected) {
            panel.setBackground(bgColor == null ? list.getSelectionBackground() : bgColor);
            panel.setForeground(fgColor == null ? list.getSelectionForeground() : fgColor);
        } else {
            panel.setBackground(orgListItemType.equals((Object)OrgListItemType.ORG) && value.getOrganization().getId() > 0 ? this.normalOrgColor : list.getBackground());
            panel.setForeground(list.getForeground());
        }
        return panel;
    }

    private JPanel getOrganizationPanel() {
        if (this.organizationPanel == null) {
            this.organizationPanel = new JPanel(new GridBagLayout());
            this.organizationPanel.add((Component)this.organizationTitleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        }
        return this.organizationPanel;
    }

    private JPanel getBankAccountPanel() {
        if (this.bankAccountPanel == null) {
            this.bankAccountPanel = new JPanel(new GridBagLayout());
            this.bankAccountPanel.add((Component)this.bankAccountTitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 20, 3, 3), 0, 0));
            this.bankAccountPanel.add((Component)this.bankAccountInfoLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 20, 3, 3), 0, 0));
        }
        return this.bankAccountPanel;
    }

    private void setOrganizationPanelData(OrgListItem value) {
        Organization organization = value.getOrganization();
        this.organizationTitleLabel.setText(organization.getTitle() + (organization.isDefaultOrganization() ? " *" : "") + (String)(organization.getId() > 0 ? " [#" + organization.getId() + "]" : ""));
        this.organizationTitleLabel.setForeground(organization.getId() < 1 ? this.addColor : this.normalColor);
        this.organizationTitleLabel.setFont(organization.getId() < 1 ? this.addFont : this.normalOrgFont);
    }

    private void setBankAccountPanelData(OrgListItem value) {
        BankAccount bankAccount = value.getBankAccount();
        this.bankAccountTitleLabel.setText(bankAccount.getTitle() + (bankAccount.isDefaultAccount() ? " *" : ""));
        this.bankAccountTitleLabel.setForeground(bankAccount.getId() < 1 ? this.addColor : this.normalColor);
        this.bankAccountTitleLabel.setFont(bankAccount.getId() < 1 ? this.addFont : this.normalFont);
        this.bankAccountInfoLabel.setText((String)(bankAccount.getId() > 0 ? "\u0420/\u0441 " + bankAccount.getAccount() + " \u0432 " + bankAccount.getBankTitle() + " (\u0411\u0418\u041a: " + bankAccount.getBankIdentificationCode() + "; \u041a/\u0441: " + bankAccount.getCorrespondentAccount() + ")" : ""));
    }
}

