/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.map.bean.MapMarker;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;

public class BGWaypoint
extends DefaultWaypoint {
    public static final String DEFAULT_IMAGE_WAYPOINT_PATH = "/images/standard_waypoint.png";
    private final MapMarker mapMarker;
    private final JPanel viewComponent;

    public BGWaypoint(MapMarker mapMarker) {
        this(mapMarker, null);
    }

    public BGWaypoint(MapMarker mapMarker, JPanel component) {
        this(mapMarker, component, mapMarker.getImagePath());
    }

    public BGWaypoint(MapMarker mapMarker, JPanel component, String imagePath) {
        super((GeoPosition)mapMarker);
        this.mapMarker = mapMarker;
        this.viewComponent = component == null ? this.createDefaultUIComponent(mapMarker) : component;
        this.addMouseListener(mapMarker);
        try {
            ImageIcon icon = Utils.isBlankString(imagePath) ? new ImageIcon(ImageIO.read(BGWaypoint.class.getResource(DEFAULT_IMAGE_WAYPOINT_PATH))) : ClientUtils.getIcon(imagePath);
            if (icon != null) {
                this.viewComponent.add((Component)new JLabel(icon), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private JPanel createDefaultUIComponent(MapMarker mapMarker) {
        ShadowPanel panel = new ShadowPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(new Color(0, 0, 0, 0));
        panel.setOpaque(false);
        if (mapMarker.isShowTitle()) {
            JLabel titleLabel = new JLabel(mapMarker.getTitle());
            titleLabel.setForeground(Color.BLACK);
            titleLabel.setFont(new Font("SansSerif", 1, 12));
            panel.add((Component)new JLabel(mapMarker.getTitle()), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addMouseListener(final MapMarker mapMarker) {
        this.viewComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.setSource(BGWaypoint.this.viewComponent);
                if (mapMarker.getClickListener() != null) {
                    mapMarker.getClickListener().mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.setSource(BGWaypoint.this.viewComponent);
                if (mapMarker.getClickListener() != null) {
                    mapMarker.getClickListener().mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.setSource(BGWaypoint.this.viewComponent);
                if (mapMarker.getClickListener() != null) {
                    mapMarker.getClickListener().mouseReleased(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.setSource(BGWaypoint.this.viewComponent);
                if (mapMarker.getClickListener() != null) {
                    mapMarker.getClickListener().mouseEntered(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.setSource(BGWaypoint.this.viewComponent);
                if (mapMarker.getClickListener() != null) {
                    mapMarker.getClickListener().mouseExited(e);
                }
            }
        });
    }

    public JPanel getViewComponent() {
        return this.viewComponent;
    }

    public MapMarker getMapMarker() {
        return this.mapMarker;
    }

    private final class ShadowPanel
    extends JPanel {
        private boolean isHovered = false;

        public ShadowPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ShadowPanel.this.isHovered = true;
                    ShadowPanel.this.repaint0();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ShadowPanel.this.isHovered = false;
                    ShadowPanel.this.repaint0();
                }
            });
        }

        private void repaint0() {
            Dimension defaultSize = this.getSize();
            if (this.isHovered) {
                BGSwingUtilites.wrapRoundedBorder(this, 10);
                defaultSize.width += 30;
                defaultSize.height += 30;
            } else {
                this.setBorder(null);
                defaultSize.width -= 30;
                defaultSize.height -= 30;
            }
            this.setPreferredSize(defaultSize);
            this.revalidate();
            super.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isHovered) {
                g2d.setColor(new Color(0, 0, 0, 50));
                g2d.fillRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 10, 10);
            }
            g2d.setColor(this.getBackground());
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
        }
    }
}

