package ru.bitel.bgbilling.modules.sorm.dyn.cdr;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUploadCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft.MfiSoftConstants;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.Utils;

import java.nio.file.Path;

import static ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft.MfiSoftFileTitle.CDR;
import static ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils.getUploadFile;

public class MfiSoftCDRUpload
    extends CDRUploadCommon
{
    public MfiSoftCDRUpload( int sormModuleId,
                             SormProject sormProject )
        throws BGException
    {
        super( sormModuleId, sormProject );
    }

    @Override
    public SormManufacturer getSormManufacturer()
    {
        return SormManufacturer.MFISOFT;
    }

    @Override
    public Path getFile()
        throws BGException
    {
        return getUploadFile( localUserPath,
                              CDR.getTitle(),
                              MfiSoftConstants.FILE_NAME_DATE_PATTERN );
    }

    @Override
    public String[] getHeader()
    {
        return new String[] { "START_TIME", "DURATION", "REGION_ID", "CALL_TYPE_ID", "SUPPLEMENT_SERVICE_ID", "IN_ABONENT_TYPE",
                              "OUT_ABONENT_TYPE", "SWITCH_ID", "INBOUND_BUNCH", "OUTBOUND_BUNCH", "TERM_CAUSE", "PHONE_CARD_NUMBER",
                              "IN_DIRECTORY_NUMBER", "IN_INTERNAL_NUMBER", "DIALED_DIGITS", "OUT_DIRECTORY_NUMBER", "OUT_INTERNAL_NUMBER", "FORWARD_ID",
                              "BORDER_SWITCH_ID", "MESSAGE", "SS7_OPC", "SS7_DPC", "DATA_CONTENT_ID", "IN_CIRCUIT_GROUP",
                              "OUT_CIRCUIT_GROUP", "CALL_ID", "CDR_ID", "TIMEZONE_ID", "CONN_TYPE", "IS_IN_OUT",
                              "IS_SUCCESS", "IS_REDIRECT", "IS_ROAMING", "IS_EMERGE", "IS_FREE", "IS_TRANSIT",
                              "IS_GATEWAY", "SEIZURE_TIME", "ANSWER_TIME", "RELEASE_TIME", "TIME_STAMP" };
    }

    @Override
    public String[] getCDRItem( CDRItem cdrItem )
        throws BGException
    {
        String[] item = new String[41];
        item[0] = SormUtils.formatDateToUTC( cdrItem.startTime, "yyyy-MM-dd'T'HH:mm:ss'Z'" ); //START_TIME (UTC)
        item[1] = String.valueOf( cdrItem.duration ); //DURATION
        item[2] = regionId; //REGION_ID
        item[3] = "1"; //CALL_TYPE_ID тип соединения
        item[4] = getServiceId(); //SUPPLEMENT_SERVICE_ID услуга
        item[5] = isOurNumber( cdrItem.callingNumber ) ? "0" : "3"; // IN_ABONENT_TYPE тип вызывающего абонента:0 - абонент данного коммутатора1 - абонент сети связи2 - роумер3 - не определено
        item[6] = isOurNumber( cdrItem.callingNumber ) ? "0" : "3"; //OUT_ABONENT_TYPE
        item[7] = String.valueOf( cdrItem.deviceId ); //SWITCH_ID ID коммутатора
        item[8] = Utils.maskBlank( cdrItem.fromPort, "1"); // INBOUND_BUNCH
        item[9] = Utils.maskBlank( cdrItem.toPort, "1"); // OUTBOUND_BUNCH
        item[10] = "16"; // TERM_CAUSE
        item[11] = "";
        item[12] = cdrItem.callingNumber; //IN_DIRECTORY_NUMBER номер вызывающего
        item[13] = "";
        item[14] = "";
        item[15] = cdrItem.calledNumber; //OUT_DIRECTORY_NUMBER номер вызываемого
        item[16] = "";
        item[17] = "";
        item[18] = "";
        item[19] = "";
        item[20] = "";
        item[21] = "";
        item[22] = "";
        item[23] = "";
        item[24] = "";
        item[25] = "";
        item[26] = "";
        item[27] = "";
        item[28] = "";
        item[29] = "";
        item[30] = "";
        item[31] = "";
        item[32] = "";
        item[33] = "";
        item[34] = "";
        item[35] = "";
        item[36] = "";
        item[37] = "";
        item[38] = "";
        item[39] = "";
        item[40] = "";
        return item;
    }
}