/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.ActionPerformer;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.CodeTreeKeyListener;
import ru.bitel.bgbilling.kernel.dynamic.client.CompilationExcludeResources;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.common.Utils;

public class DynamicCodeTree
extends BGUPanel
implements ActionPerformer {
    private static final String ICON_FOLDER = "packet";
    private static final String ICON_LEAF_RESOURCE = "src_nojava";
    private static final String ICON_LEAF_JAVA = "src_java";
    protected static final int TYPE_FOLDER = 1;
    protected static final int TYPE_ITEM = 2;
    private JTree tree = new JTree();
    private ModTreeNode rootNode;
    private Map<String, ModTreeNode> nodeMap = new HashMap<String, ModTreeNode>();
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();

    public void recreateTree(List<DynamicClass> classNames) {
        this.rootNode = new ModTreeNode("/", ICON_FOLDER);
        this.rootNode.setAttribute("name", ".");
        this.rootNode.setAttribute("type", 1);
        this.rootNode.setText("/");
        classNames.sort((class1, class2) -> {
            String o1 = class1.getClassName();
            String o2 = class2.getClassName();
            int minLen = Math.min(o1.length(), o2.length());
            for (int i = 0; i < minLen; ++i) {
                char two;
                char one = o1.charAt(i);
                if (one == (two = o2.charAt(i))) continue;
                if (Character.isLowerCase(one) && !Character.isLowerCase(two)) {
                    return -1;
                }
                if (!Character.isLowerCase(one) && Character.isLowerCase(two)) {
                    return 1;
                }
                return one - two;
            }
            return o1.length() - o2.length();
        });
        for (DynamicClass clazz : classNames) {
            String[] path = clazz.getClassName().split("\\.");
            ModTreeNode currentNode = this.rootNode;
            block1: for (int i = 0; i < path.length - 1; ++i) {
                Enumeration<TreeNode> en = currentNode.children();
                while (en.hasMoreElements()) {
                    ModTreeNode candidate = (ModTreeNode)en.nextElement();
                    if (!candidate.getAttribute("type").equals(1) || !path[i].equals(candidate.getAttribute("name"))) continue;
                    currentNode = candidate;
                    continue block1;
                }
                ModTreeNode newNode = new ModTreeNode(path[i], ICON_FOLDER);
                newNode.setAttribute("name", path[i]);
                newNode.setAttribute("type", 1);
                currentNode.add(newNode);
                currentNode = newNode;
                newNode.setAttribute("isCompileExclude", CompilationExcludeResources.getInstance(this).packageIsExclude(currentNode));
            }
            Object title = path[path.length - 1];
            title = DynamicClass.getResourceName((String)title) + "." + DynamicClass.getResourceExt((String)title);
            ModTreeNode leafNode = new ModTreeNode((String)title, clazz.isJavaSource() ? ICON_LEAF_JAVA : ICON_LEAF_RESOURCE);
            leafNode.setAttribute("name", clazz.getClassName());
            leafNode.setAttribute("type", 2);
            leafNode.setAttribute("clazz", clazz);
            boolean isCompileExclude = clazz.isJavaSource() && CompilationExcludeResources.getInstance(this).classCompileExclude(clazz.getClassName());
            leafNode.setAttribute("isCompileExclude", isCompileExclude);
            currentNode.add(leafNode);
            this.nodeMap.put(clazz.getClassName(), leafNode);
        }
        this.tree.setModel(new DefaultTreeModel(this.rootNode));
        this.tree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.addKeyListener(new CodeTreeKeyListener(this, classNames));
        this.loadExpand();
    }

    @Override
    protected void jbInit() {
        this.tree.setCellRenderer(new DynamicCodeTreeRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    DynamicCodeTree.this.fireActionPerformed(new ActionEvent(e.getSource(), 1, "foobar"));
                } else if (e.getButton() == 3 && e.getClickCount() == 1) {
                    CompilationExcludeResources.ResourcesMenu.show(DynamicCodeTree.this, e.getX(), e.getY());
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DynamicCodeTree.this.saveExpand();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                DynamicCodeTree.this.saveExpand();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void saveExpand() {
        String key = ClientUtils.getComponentKey(this, "expandedNodes");
        List<String> expandedNodes = ClientUtils.getExpandedTreeNodeList(this.tree, ".");
        ClientSetup.getInstance().getUserConfig().set(key, Utils.toString(expandedNodes, ","));
    }

    private void loadExpand() {
        String key = ClientUtils.getComponentKey(this, "expandedNodes");
        List<String> expandedNodes = Utils.toList(ClientSetup.getInstance().getUserConfig().get(key, ""), ",");
        ClientUtils.setExpandedTreeNodeList(this.tree, expandedNodes, "\\.");
    }

    public String getSelectedClass() {
        TreePath selected = this.tree.getSelectionPath();
        if (selected == null) {
            return "";
        }
        ModTreeNode lastPathComponent = (ModTreeNode)selected.getLastPathComponent();
        if (lastPathComponent.getAttribute("type").equals(2)) {
            return (String)lastPathComponent.getAttribute("name");
        }
        return "";
    }

    public String getPackage() {
        String resultPackage = "";
        TreePath[] selPath = this.tree.getSelectionPaths();
        if (selPath != null && selPath.length == 1) {
            Object tmp = selPath[0].toString();
            ModTreeNode selectedNode = (ModTreeNode)selPath[0].getLastPathComponent();
            if (!selectedNode.isRoot()) {
                Pattern pattern;
                Matcher matcher;
                if (selectedNode.isLeaf() && (matcher = (pattern = Pattern.compile(Pattern.quote(selectedNode.getText()))).matcher((CharSequence)tmp)).find()) {
                    tmp = matcher.replaceAll("");
                }
                if (((String)(tmp = ((String)tmp).substring(4, ((String)tmp).lastIndexOf("]")).replaceAll(", ", "."))).length() > 0 && ((String)tmp).charAt(((String)tmp).length() - 1) != '.') {
                    tmp = (String)tmp + ".";
                }
                resultPackage = tmp;
            }
        }
        return resultPackage;
    }

    public void setSelectedClass(String fullClassName) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        Object[] path = model.getPathToRoot(this.nodeMap.get(fullClassName));
        TreePath tr = new TreePath(path);
        this.tree.setSelectionPath(tr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener al) {
        List<ActionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireActionPerformed(ActionEvent e) {
        List<ActionListener> list = this.listeners;
        synchronized (list) {
            for (ActionListener listener : this.listeners) {
                listener.actionPerformed(e);
            }
        }
    }

    protected JTree getTree() {
        return this.tree;
    }

    private static class DynamicCodeTreeRenderer
    extends DefaultTreeCellRenderer {
        private DynamicCodeTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ModTreeNode) {
                ModTreeNode node = (ModTreeNode)value;
                ImageIcon icon = ClientUtils.getIcon(node.getIcon());
                if (icon != null) {
                    this.setIcon(icon);
                }
                if (node.getAttribute("type").equals(2)) {
                    DynamicClass clazz = (DynamicClass)node.getAttribute("clazz");
                    Object title = node.getText();
                    if (clazz.isDeprecated()) {
                        title = "<font color='#666666'>" + (String)title + " (deprecated)</font>";
                    }
                    if (clazz.isNeedsRecompile()) {
                        title = "<i>" + (String)title + " *</i>";
                    }
                    if (!clazz.isJavaSource()) {
                        title = "<font color='#666666'>" + (String)title + "</font>";
                    } else if (((Boolean)node.getAttribute("isCompileExclude")).booleanValue()) {
                        title = "<s>" + (String)title + "</s>";
                    }
                    title = "<html>" + (String)title + "</html>";
                    this.setText((String)title);
                } else if (node.getAttribute("type").equals(1) && node.getAttribute("isCompileExclude") != null && ((Boolean)node.getAttribute("isCompileExclude")).booleanValue()) {
                    this.setText("<html><s>" + node.getText() + "</s></html>");
                }
            }
            return result;
        }
    }
}

