/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.math.BigDecimal;
import java.security.SignatureException;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.base.server.wrapper.CaseInsensitiveParameterWrapper;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyRequest;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.security.PKCS7;
import ru.bitel.common.util.DebugUtils;

@WebServlet(name="YoomoneyExecutor_v3", urlPatterns={"/yaexecuter3/*", "/yoomoney/*"})
public class ModuleExecuter_v3
extends CommonExecutor {
    private static final int ERROR_CODE_OK = 0;
    private static final int ERROR_CODE_AUTH = 1;
    private static final int ERROR_CODE_REJECT = 100;
    private static final int ERROR_CODE_REQUEST = 200;
    private static final int ERROR_CODE_INTERNAL = 1000;
    private static final String ACTION_CHECK_MD5 = "checkOrder";
    private static final String ACTION_SUCCESS_MD5 = "paymentAviso";
    private static final String ACTION_CHECK_XML = "checkOrderRequest";
    private static final String ACTION_SUCCESS_XML = "paymentAvisoRequest";

    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new IllegalAccessError("HTTP-GET-requests can not be!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request0, HttpServletResponse response) throws ServletException, IOException {
        YoomoneyRequest yoomoneyRequest;
        CaseInsensitiveParameterWrapper request = new CaseInsensitiveParameterWrapper(request0);
        int mid = Utils.parseInt((String)request.getParameter("mid"));
        if (mid <= 0) {
            this.getLogger().error("GET-parameter mid required!");
            this.doReply(null, response, 200, "GET-parameter mid required");
            return;
        }
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(mid));
        try {
            yoomoneyRequest = this.parseParam((HttpServletRequest)request, (Preferences)moduleSetup);
        }
        catch (RequestParseException e) {
            this.getLogger().error("error do post, error parse request (request see below)", (Throwable)e);
            this.getLogger().error(e.getRawRequest());
            this.doReply(null, response, 200, "error parse request: " + e.getMessage());
            return;
        }
        catch (AuthException e) {
            this.getLogger().error("error do post, auth failed (request see below)", (Throwable)e);
            this.getLogger().error(e.getRawRequest());
            this.doReply(e.getYoomoneyRequest(), response, 1, "auth failed: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            this.getLogger().error("error do post, config failed?", (Throwable)e);
            this.doReply(null, response, 1000, "config failed?: " + e.getMessage());
            return;
        }
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            long shopId_p = moduleSetup.getLong("yoomoney.shopId", -1L);
            if (yoomoneyRequest.getShopId() != shopId_p) {
                throw new BGException("error shopId (config=" + shopId_p + ",request=" + yoomoneyRequest.getShopId() + ")");
            }
            TransactionManager manager = new TransactionManager(con, mid);
            Transaction transaction = manager.getTransactionForInvoice(yoomoneyRequest.getInvoiceId());
            if (transaction != null) {
                if (ACTION_CHECK_MD5.equals(yoomoneyRequest.getAction()) || ACTION_CHECK_XML.equals(yoomoneyRequest.getAction())) {
                    throw new BGException("transaction InvoiceId=" + yoomoneyRequest.getInvoiceId() + " exists, action=" + yoomoneyRequest.getAction());
                }
                this.doReply(yoomoneyRequest, response, 0, "OK (Re-send)");
                return;
            }
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(con, 0);){
                contract = contractDao.getByTitle(yoomoneyRequest.getCustomerNumber());
            }
            if (contract == null) {
                this.getLogger().warn("reject transaction: not valid customerNumber=" + yoomoneyRequest.getCustomerNumber());
                this.doReply(yoomoneyRequest, response, 100, "not valid customerNumber=" + yoomoneyRequest.getCustomerNumber());
                return;
            }
            if (!contract.isActualDate(new Date())) {
                this.getLogger().warn("reject transaction: not actual date contract=" + yoomoneyRequest.getCustomerNumber());
                this.doReply(yoomoneyRequest, response, 100, "not actual date contract=" + yoomoneyRequest.getCustomerNumber());
                return;
            }
            Set mids = new ContractModuleManager(con).getContractModuleSet(contract.getId());
            if (!mids.contains(mid)) {
                this.getLogger().warn("reject transaction: contract=" + yoomoneyRequest.getCustomerNumber() + " not contains module mid=" + mid);
                this.doReply(yoomoneyRequest, response, 100, "contract=" + yoomoneyRequest.getCustomerNumber() + " not contains module mid=" + mid);
                return;
            }
        }
        catch (Exception e) {
            this.getLogger().error("error do post", (Throwable)e);
            this.doReply(yoomoneyRequest, response, 1000, e.toString());
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void doReply(YoomoneyRequest yoomoneyRequest, HttpServletResponse response, int code, String techMessage) throws IOException {
        String performedDatetime = ModuleExecuter_v3.formatDateTime(new Date());
        String action = yoomoneyRequest != null ? yoomoneyRequest.getAction() : "unknown";
        String shopId = yoomoneyRequest != null ? String.valueOf(yoomoneyRequest.getShopId()) : "unknown";
        String invoiceId = yoomoneyRequest != null ? String.valueOf(yoomoneyRequest.getInvoiceId()) : "unknown";
        Object techMessageAttribute = "";
        if (code != 0 && techMessage != null) {
            techMessageAttribute = "techMessage=\"" + techMessage + "\"";
        }
        String nameMethod = "unknownmethod";
        if (ACTION_CHECK_MD5.equals(action) || ACTION_CHECK_XML.equals(action)) {
            nameMethod = "checkOrderResponse";
        } else if (ACTION_SUCCESS_MD5.equals(action) || ACTION_SUCCESS_XML.equals(action)) {
            nameMethod = "paymentAvisoResponse";
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        PrintWriter out = response.getWriter();
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<" + nameMethod + " performedDatetime =\"" + performedDatetime + "\" code=\"" + code + "\" invoiceId=\"" + invoiceId + "\" shopId=\"" + shopId + "\" " + (String)techMessageAttribute + " />");
        out.flush();
        out.close();
        this.getLogger().debug("do reply " + code + " (" + techMessage + ")");
    }

    private static String formatDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getTimeZone("Europe/Moscow"));
        Object datestr = df.format(date);
        datestr = ((String)datestr).substring(0, ((String)datestr).length() - 2) + ":" + ((String)datestr).substring(((String)datestr).length() - 2);
        return datestr;
    }

    public static Date parseDateTime(String date, String rawRequest) throws RequestParseException {
        if (date != null) {
            try {
                if (((String)date).endsWith(":00")) {
                    date = ((String)date).substring(0, ((String)date).length() - 3) + ((String)date).substring(((String)date).length() - 2);
                }
                date = ((String)date).replace("Z", "+0000");
                date = ((String)date).replaceAll("\\.\\d\\d\\d", "");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                return df.parse((String)date);
            }
            catch (ParseException e) {
                throw new RequestParseException("Error date format: " + (String)date, rawRequest);
            }
        }
        return null;
    }

    private static long parseLong(String int64, String rawRequest) throws RequestParseException {
        if (int64 != null) {
            try {
                return Long.parseLong(int64);
            }
            catch (NumberFormatException e) {
                throw new RequestParseException("Error integer format: " + int64, rawRequest);
            }
        }
        return -1L;
    }

    private static BigDecimal parseCurrencyAmount(String sum, String rawRequest) throws RequestParseException {
        if (sum != null) {
            try {
                return new BigDecimal(sum);
            }
            catch (NumberFormatException e) {
                throw new RequestParseException("Error summa format: " + sum, rawRequest);
            }
        }
        return null;
    }

    private YoomoneyRequest parseParam(HttpServletRequest request, Preferences moduleSetup) throws Exception {
        String authMethod = moduleSetup.get("yoomoney.authMethod", null);
        if (authMethod == null) {
            throw new BGException("config parameter 'authMethod' require");
        }
        if ("md5".equalsIgnoreCase(authMethod)) {
            return this.parseParamMD5(request, moduleSetup);
        }
        if ("PKCS7".equalsIgnoreCase(authMethod)) {
            return this.parseParamXml(request, moduleSetup);
        }
        throw new BGException("config parameter 'authMethod'='" + authMethod + "' unknown");
    }

    private YoomoneyRequest parseParamMD5(HttpServletRequest request, Preferences moduleSetup) throws RequestParseException, AuthException, BGException {
        String requestString = Utils.toString((Iterable)request.getParameterMap().entrySet().stream().map(f -> (String)f.getKey() + "=" + ((String[])f.getValue())[0]).collect(Collectors.toList()));
        YoomoneyRequest yoomoneyRequest = new YoomoneyRequest();
        yoomoneyRequest.setRawRequest(requestString);
        yoomoneyRequest.setRequestDatetime(ModuleExecuter_v3.parseDateTime(request.getParameter("requestDatetime"), requestString));
        if (yoomoneyRequest.getRequestDatetime() == null) {
            throw new RequestParseException("request-parameter 'requestDatetime' require", requestString);
        }
        yoomoneyRequest.setAction(request.getParameter("action"));
        if (yoomoneyRequest.getAction() == null) {
            throw new RequestParseException("request-parameter 'action' require", requestString);
        }
        if (!ACTION_CHECK_MD5.equals(yoomoneyRequest.getAction()) && !ACTION_SUCCESS_MD5.equals(yoomoneyRequest.getAction())) {
            throw new RequestParseException("request-parameter 'action' not valid: " + yoomoneyRequest.getAction(), requestString);
        }
        yoomoneyRequest.setMd5(request.getParameter("md5"));
        yoomoneyRequest.setShopId(ModuleExecuter_v3.parseLong(request.getParameter("shopId"), requestString));
        if (yoomoneyRequest.getShopId() <= 0L) {
            throw new RequestParseException("request-parameter 'shopId' require", requestString);
        }
        yoomoneyRequest.setInvoiceId(ModuleExecuter_v3.parseLong(request.getParameter("invoiceId"), requestString));
        if (yoomoneyRequest.getInvoiceId() <= 0L) {
            throw new RequestParseException("request-parameter 'invoiceId' require", requestString);
        }
        yoomoneyRequest.setCustomerNumber(request.getParameter("customerNumber"));
        yoomoneyRequest.setOrderCreatedDatetime(ModuleExecuter_v3.parseDateTime(request.getParameter("orderCreatedDatetime"), requestString));
        yoomoneyRequest.setOrderSumAmount(ModuleExecuter_v3.parseCurrencyAmount(request.getParameter("orderSumAmount"), requestString));
        if (yoomoneyRequest.getOrderSumAmount() == null) {
            throw new RequestParseException("request-parameter 'orderSumAmount' require", requestString);
        }
        yoomoneyRequest.setShopSumAmount(ModuleExecuter_v3.parseCurrencyAmount(request.getParameter("shopSumAmount"), requestString));
        if (yoomoneyRequest.getShopSumAmount() == null) {
            throw new RequestParseException("request-parameter 'shopSumAmount' require", requestString);
        }
        yoomoneyRequest.setPaymentType(request.getParameter("paymentType"));
        yoomoneyRequest.setPaymentPayerCode(request.getParameter("paymentPayerCode"));
        if (yoomoneyRequest.getPaymentPayerCode() == null) {
            throw new RequestParseException("request-parameter 'paymentPayerCode' require", requestString);
        }
        yoomoneyRequest.setPaymentDateTime(ModuleExecuter_v3.parseDateTime(request.getParameter("paymentDateTime"), requestString));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("do action " + yoomoneyRequest.getAction() + " : " + DebugUtils.dumpObject((Object)yoomoneyRequest));
        }
        if (!this.checkAuthMD5(yoomoneyRequest, moduleSetup)) {
            throw new AuthException("md5 auth failed", yoomoneyRequest, requestString);
        }
        return yoomoneyRequest;
    }

    private static String decode(InputStream input, InputStream certificate) throws SignatureException, IOException {
        return new String(PKCS7.decode((InputStream)input, (InputStream)certificate), "UTF-8");
    }

    private YoomoneyRequest parseParamXml(HttpServletRequest request, Preferences moduleSetup) throws Exception {
        String certificateFilePath = moduleSetup.get("yoomoney.certificateFile", null);
        if (certificateFilePath == null) {
            throw new BGException("config parameter 'yoomoney.certificateFile' require for PKCS7-mode");
        }
        File certificateFile = new File(certificateFilePath);
        String requestString = null;
        String xml = null;
        try {
            byte[] requestBytes = Utils.readByBlock((InputStream)request.getInputStream());
            requestString = new String(requestBytes);
            xml = ModuleExecuter_v3.decode(new ByteArrayInputStream(requestBytes), new FileInputStream(certificateFile));
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage(), null, requestString);
        }
        catch (SignatureException e) {
            throw new AuthException(e.getMessage(), null, requestString);
        }
        catch (Exception e) {
            this.getLogger().error("error decode request", (Throwable)e);
            throw new AuthException("error decode request", null, requestString);
        }
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(xml)));
        if (doc == null) {
            throw new RequestParseException("xml parse error", requestString);
        }
        Element elrequest = doc.getDocumentElement();
        YoomoneyRequest yoomoneyRequest = new YoomoneyRequest();
        yoomoneyRequest.setRawRequest(requestString);
        yoomoneyRequest.setRequestDatetime(ModuleExecuter_v3.parseDateTime(XMLUtils.getAttribute((Element)elrequest, (String)"requestDatetime"), requestString));
        if (yoomoneyRequest.getRequestDatetime() == null) {
            throw new RequestParseException("request-parameter 'requestDatetime' require", requestString);
        }
        yoomoneyRequest.setAction(elrequest.getTagName());
        if (!ACTION_CHECK_XML.equals(yoomoneyRequest.getAction()) && !ACTION_SUCCESS_XML.equals(yoomoneyRequest.getAction())) {
            throw new RequestParseException("request-parameter 'action' not valid: " + yoomoneyRequest.getAction(), requestString);
        }
        yoomoneyRequest.setShopId(ModuleExecuter_v3.parseLong(XMLUtils.getAttribute((Element)elrequest, (String)"shopId"), requestString));
        if (yoomoneyRequest.getShopId() <= 0L) {
            throw new RequestParseException("request-parameter 'shopId' require", requestString);
        }
        yoomoneyRequest.setInvoiceId(ModuleExecuter_v3.parseLong(XMLUtils.getAttribute((Element)elrequest, (String)"invoiceId"), requestString));
        if (yoomoneyRequest.getInvoiceId() <= 0L) {
            throw new RequestParseException("request-parameter 'invoiceId' require", requestString);
        }
        yoomoneyRequest.setCustomerNumber(XMLUtils.getAttribute((Element)elrequest, (String)"customerNumber"));
        yoomoneyRequest.setOrderCreatedDatetime(ModuleExecuter_v3.parseDateTime(XMLUtils.getAttribute((Element)elrequest, (String)"orderCreatedDatetime"), requestString));
        yoomoneyRequest.setOrderSumAmount(ModuleExecuter_v3.parseCurrencyAmount(XMLUtils.getAttribute((Element)elrequest, (String)"orderSumAmount"), requestString));
        if (yoomoneyRequest.getOrderSumAmount() == null) {
            throw new RequestParseException("request-parameter 'orderSumAmount' require", requestString);
        }
        yoomoneyRequest.setShopSumAmount(ModuleExecuter_v3.parseCurrencyAmount(XMLUtils.getAttribute((Element)elrequest, (String)"shopSumAmount"), requestString));
        if (yoomoneyRequest.getShopSumAmount() == null) {
            throw new RequestParseException("request-parameter 'shopSumAmount' require", requestString);
        }
        yoomoneyRequest.setPaymentType(XMLUtils.getAttribute((Element)elrequest, (String)"paymentType"));
        yoomoneyRequest.setPaymentPayerCode(XMLUtils.getAttribute((Element)elrequest, (String)"paymentPayerCode"));
        if (yoomoneyRequest.getPaymentPayerCode() == null) {
            throw new RequestParseException("request-parameter 'paymentPayerCode' require", requestString);
        }
        yoomoneyRequest.setPaymentDateTime(ModuleExecuter_v3.parseDateTime(XMLUtils.getAttribute((Element)elrequest, (String)"paymentDatetime"), requestString));
        if (ACTION_SUCCESS_XML.equals(yoomoneyRequest.getAction()) && yoomoneyRequest.getPaymentDateTime() == null) {
            throw new RequestParseException("request-parameter 'paymentDatetime' require with paymentAvisoRequest", requestString);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("do action " + yoomoneyRequest.getAction() + " : " + DebugUtils.dumpObject((Object)yoomoneyRequest));
        }
        return yoomoneyRequest;
    }

    private boolean checkAuthMD5(YoomoneyRequest yoomoneyRequest, Preferences moduleSetup) throws BGException, RequestParseException {
        String action = yoomoneyRequest.getAction();
        String orderSumAmount = yoomoneyRequest.getOrderSumAmount().toString();
        String shopId = String.valueOf(yoomoneyRequest.getShopId());
        String invoiceId = String.valueOf(yoomoneyRequest.getInvoiceId());
        String customerNumber = yoomoneyRequest.getCustomerNumber();
        String shopPassword = moduleSetup.get("yoomoney.shopPassword", null);
        if (shopPassword == null) {
            throw new BGException("config parameter 'shopPassword' require for md5-mode");
        }
        String md5 = yoomoneyRequest.getMd5();
        if (md5 == null) {
            throw new RequestParseException("request-parameter 'md5' missing", yoomoneyRequest.getRawRequest());
        }
        String digest = Utils.getDigest((String)(action + ";" + orderSumAmount + ";;;" + shopId + ";" + invoiceId + ";" + customerNumber + ";" + shopPassword), (String)"cp1251");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("action={}; orderSumAmount={}; shopId={}; invoiceId={}; customerNumber={}", new Object[]{action, orderSumAmount, shopId, invoiceId, customerNumber});
            this.getLogger().debug("md5(request)={}", (Object)md5);
            this.getLogger().debug("md5( check )={}", (Object)digest);
            this.getLogger().debug("md5.equalsIgnoreCase(check)={}", (Object)digest.equalsIgnoreCase(md5));
        }
        return digest.equalsIgnoreCase(md5);
    }

    public static class RequestParseException
    extends Exception {
        private String rawRequest;

        public RequestParseException(String message, String rawRequest) {
            super(message);
            this.rawRequest = rawRequest;
        }

        public String getRawRequest() {
            return this.rawRequest;
        }
    }

    public static class AuthException
    extends Exception {
        private YoomoneyRequest yoomoneyRequest;
        private String rawRequest;

        public AuthException(String message, YoomoneyRequest yoomoneyRequest, String rawRequest) {
            super(message);
            this.yoomoneyRequest = yoomoneyRequest;
            this.rawRequest = rawRequest;
        }

        public YoomoneyRequest getYoomoneyRequest() {
            return this.yoomoneyRequest;
        }

        public String getRawRequest() {
            return this.rawRequest;
        }
    }
}

