/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatusRest;
import ru.bitel.bgbilling.modules.qiwi.common.service.QiwiService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    protected BGButton checkStatusButton = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441");
    private BGUPanel.WebServiceHolder<QiwiService> qiwiService = new BGUPanel.WebServiceHolder((BGUPanel)this, QiwiService.class);

    public TransactionPanel() {
        String protocol = ClientSetup.getInstance().getModuleParameterValue(((ClientContext)this.getContext()).getModuleId(), "qiwi.protocol.version");
        TransactionStatus[] statuses = "soap".equals(protocol) ? TransactionStatus.values() : TransactionStatusRest.values();
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(statuses));
    }

    protected JPanel getExtraFilterPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.checkStatusButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return filterPanel;
    }

    protected void initListeners() {
        super.initListeners();
        this.checkStatusButton.addActionListener(e -> {
            this.performAction("checkStatus");
            this.performAction("refresh");
        });
    }

    protected void getRestMenuItems() {
        String protocol = ClientSetup.getInstance().getModuleParameterValue(((ClientContext)this.getContext()).getModuleId(), "qiwi.protocol.version");
        if (!"soap".equals(protocol)) {
            JMenuItem cancelItem = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
            JMenuItem refundItem = new JMenuItem("\u0421\u0434\u0435\u043b\u0430\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442");
            JMenuItem checkRefundItem = new JMenuItem("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430");
            this.getTable().getPopupMenu().add(cancelItem);
            this.getTable().getPopupMenu().add(refundItem);
            this.getTable().getPopupMenu().add(checkRefundItem);
            Transaction selectedTransaction = (Transaction)this.transactionModel.getSelectedRow();
            if (selectedTransaction != null) {
                TransactionStatusRest status = (TransactionStatusRest)TransactionStatusRest.ALL.getStatusByCode(selectedTransaction.getStatus());
                switch (status) {
                    case WAITING: {
                        cancelItem.setEnabled(true);
                        refundItem.setEnabled(false);
                        checkRefundItem.setEnabled(false);
                        break;
                    }
                    case PAID: {
                        cancelItem.setEnabled(false);
                        refundItem.setEnabled(true);
                        checkRefundItem.setEnabled(false);
                        break;
                    }
                    case REFUND_REQUEST: {
                        cancelItem.setEnabled(false);
                        refundItem.setEnabled(false);
                        checkRefundItem.setEnabled(true);
                        break;
                    }
                }
                cancelItem.addActionListener(e -> this.tryCall(() -> {
                    ((QiwiService)this.qiwiService.get()).cancelTransaction(selectedTransaction.getId());
                    this.performAction("refresh");
                }));
                refundItem.addActionListener(e -> this.tryCall(() -> {
                    ((QiwiService)this.qiwiService.get()).refundTransaction(selectedTransaction.getId());
                    this.performAction("refresh");
                }));
                checkRefundItem.addActionListener(e -> this.tryCall(() -> {
                    ((QiwiService)this.qiwiService.get()).checkRefundStatus(selectedTransaction.getId());
                    this.performAction("refresh");
                }));
            }
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            AbstractTransactionStatus status = (AbstractTransactionStatus)this.statusComboBox.getSelectedItem();
            SearchResult searchResult = ((QiwiService)this.qiwiService.get()).searchTransactionList(this.getContractId(), null, status.getCode(), this.periodPanel.getPeriod(), this.pagePanel.getPage());
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "checkStatus", "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441", e -> ((QiwiService)this.qiwiService.get()).checkPayment(this.getContractId(), this.periodPanel.getPeriod()));
    }
}

