/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.client;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableDataSource;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowValue;
import ru.bitel.bgbilling.kernel.table.common.enums.BGUTableCellRenderer;
import ru.bitel.bgbilling.kernel.table.common.service.TableService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.TryCall;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class BGDataSourceTableModel
extends BGTableModel<BGUTableRowData> {
    private boolean keepSelection = false;
    private boolean loadHeaders = true;
    private BGUTableDataSource tableDataSource = null;

    public BGDataSourceTableModel(String name) {
        super(name);
    }

    public Page getPage() {
        return this.tableDataSource.getPage();
    }

    public List<BGUTableColumn> getBGUTableColumns() {
        return this.tableDataSource.getColumns();
    }

    public String getAttribute(String key) {
        return this.tableDataSource.getAttributes().stream().filter(a -> a.getKey().equals(key)).findFirst().map(KeyValue::getValue).orElse(null);
    }

    protected void initColumns() {
        List<BGUTableColumn> columns;
        if (this.tableDataSource != null && (columns = this.tableDataSource.getColumns()) != null) {
            for (BGUTableColumn tableColumn : columns) {
                Object tableCellRenderer = switch (tableColumn.getTableCellRenderer()) {
                    case BGUTableCellRenderer.TEXT_LEFT -> HorizontalAlignmentTableCellRenderer.LEFT();
                    case BGUTableCellRenderer.TEXT_CENTER -> HorizontalAlignmentTableCellRenderer.CENTER();
                    case BGUTableCellRenderer.TEXT_RIGHT -> HorizontalAlignmentTableCellRenderer.RIGHT();
                    case BGUTableCellRenderer.TEXT_COLOR_CENTER -> HorizontalAlignmentTableCellRenderer.COLOR_CENTER();
                    case BGUTableCellRenderer.INTEGER -> DecimalTableCellRenderer.INTEGER();
                    case BGUTableCellRenderer.DECIMAL -> DecimalTableCellRenderer.DEFAULT();
                    case BGUTableCellRenderer.DATE -> DatetimeTableCellRenderer.DEFAULT_DDMMYYYY();
                    case BGUTableCellRenderer.DATE_TIME -> DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS();
                    case BGUTableCellRenderer.BOOLEAN -> new BooleanTableCellRenderer();
                    case BGUTableCellRenderer.RADIO_LEFT -> new RadioTableCellRenderer();
                    case BGUTableCellRenderer.RADIO_CENTER -> new RadioTableCellRenderer(0);
                    default -> HorizontalAlignmentTableCellRenderer.LEFT();
                };
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(tableColumn.getClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addColumn(tableColumn.getTitle(), clazz, tableColumn.getMinWidth(), tableColumn.getPrefWidth(), tableColumn.getMaxWidth(), tableColumn.getName(), tableColumn.isSortable(), (TableCellRenderer)tableCellRenderer);
            }
        }
    }

    public void loadData(ClientContext context, BGUTableParams tableParams) {
        this.loadData(context, tableParams, null, null);
    }

    public void loadData(ClientContext context, BGUTableParams tableParams, BGControlPanelPages pagePanel, JLabel recordCountLabel) {
        this.loadData(context, tableParams, this.loadHeaders);
        if (pagePanel != null) {
            pagePanel.setPage(Optional.ofNullable(this.getPage()).orElse(new Page(1, 15)));
        }
        if (recordCountLabel != null) {
            recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)Optional.ofNullable(this.getPage()).map(a -> a.getRecordCount()).orElse(0)));
        }
    }

    public void loadData(ClientContext context, BGUTableParams tableParams, boolean loadHeaders) {
        TryCall.call(() -> {
            this.tableDataSource = ((TableService)context.getWebService(TableService.class, 0)).tableDataSourceGet(context.getModule(), context.getModuleId(), this.name, tableParams);
            if (loadHeaders) {
                this.reinitColumns();
                this.fireTableStructureChanged();
                this.loadHeaders = false;
            }
            this.setData(this.tableDataSource.getRows(), this.keepSelection);
            this.keepSelection = false;
        });
    }

    public <T> Optional<T> optSelectRow(Class<T> clazz) {
        return Optional.ofNullable(this.getSelectRow(clazz));
    }

    public <T> T getSelectRow(Class<T> clazz) {
        T obj = null;
        BGUTableRowData rowData = (BGUTableRowData)this.getSelectedRow();
        if (rowData != null) {
            try {
                obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                block4: for (BGUTableRowValue value : rowData.getValues()) {
                    String name = value.getName();
                    String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    for (Class methosClass : new Class[]{String.class, BigDecimal.class, Integer.TYPE, Boolean.TYPE, Period.class}) {
                        try {
                            Method method = clazz.getMethod(methodName, methosClass);
                            if (methosClass.equals(String.class)) {
                                method.invoke(obj, value.getValue());
                                continue block4;
                            }
                            if (methosClass.equals(BigDecimal.class)) {
                                method.invoke(obj, new BigDecimal(value.getValue()));
                                continue block4;
                            }
                            if (methosClass.equals(Integer.TYPE)) {
                                method.invoke(obj, Integer.parseInt(value.getValue()));
                                continue block4;
                            }
                            if (methosClass.equals(Boolean.TYPE)) {
                                method.invoke(obj, Boolean.valueOf(value.getValue()));
                                continue block4;
                            }
                            if (!methosClass.equals(Period.class)) continue block4;
                            method.invoke(obj, Period.valueOf((String)value.getValue()));
                            continue block4;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    public Object getValue(BGUTableRowData rowData, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        Class clazz = this.getColumnClass(column);
        if (clazz != null && clazz.equals(Boolean.TYPE)) {
            return Boolean.valueOf(rowData.getValues().stream().filter(a -> a.getName().equals(identifier)).findFirst().map(a -> a.getValue()).orElse("false"));
        }
        return rowData.getValues().stream().filter(a -> a.getName().equals(identifier)).findFirst().map(a -> a.getValue()).orElse("");
    }

    public void setKeepSelection(boolean keepSelection) {
        this.keepSelection = keepSelection;
    }
}

