/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class ByteParser {
    private byte[] data;

    public ByteParser(byte[] data) {
        this.data = data;
    }

    public int length() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getInt(int startPos, int length, String name) throws BGException {
        int result = 0;
        if (this.data == null || startPos < 0 || length <= 0 || length > 4 || this.data.length - length < startPos) {
            throw new BGException("int parse error: can't find int param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        byte next = 0;
        for (int i = 0; i < length; ++i) {
            next = this.data[startPos + length - i - 1];
            result |= Utils.unsignedByteToInt((byte)next) << i * 8;
        }
        return result;
    }

    public int getIntSwap(int startPos, int length, String name) throws BGException {
        int result = 0;
        if (this.data == null || startPos < 0 || length <= 0 || length > 4 || this.data.length - length < startPos) {
            throw new BGException("int parse error: can't find int param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        byte next = 0;
        for (int i = 0; i < length; ++i) {
            next = this.data[startPos + i];
            result |= Utils.unsignedByteToInt((byte)next) << i * 8;
        }
        return result;
    }

    public int getReverseInt(int startPos, int length, String name) throws BGException {
        int result = 0;
        if (this.data == null || startPos < 0 || length <= 0 || length > 4 || this.data.length - length < startPos) {
            throw new BGException("int reverse parse error: can't find int param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        byte next = 0;
        for (int i = 0; i < length; ++i) {
            next = this.data[startPos + i];
            result |= Utils.unsignedByteToInt((byte)next) << i * 8;
        }
        return result;
    }

    public long getLong(int startPos, int length, String name) throws BGException {
        long result = 0L;
        if (this.data == null || startPos < 0 || length <= 0 || length > 8 || this.data.length - length < startPos) {
            throw new BGException("long parse error:can't find long param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        byte next = 0;
        for (int i = 0; i < length; ++i) {
            next = this.data[startPos + length - i - 1];
            result |= (long)Utils.unsignedByteToInt((byte)next) << i * 8;
        }
        return result;
    }

    public long getReverseLong(int startPos, int length, String name) throws BGException {
        long result = 0L;
        if (this.data == null || startPos < 0 || length <= 0 || length > 8 || this.data.length - length < startPos) {
            throw new BGException("long reverse parse error: can't find long param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        byte next = 0;
        for (int i = 0; i < length; ++i) {
            next = this.data[startPos + i];
            result |= (long)Utils.unsignedByteToInt((byte)next) << i * 8;
        }
        return result;
    }

    public byte[] getBytes(int startPos, int length, String name) throws BGException {
        byte[] result = null;
        if (this.data == null || startPos < 0 || length <= 0 || this.data.length - length < startPos) {
            throw new BGException("bytes parse error: can't find byte[] param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        result = new byte[length];
        System.arraycopy(this.data, startPos, result, 0, length);
        return result;
    }

    public byte[] getBytesSwap(int startPos, int length, String name) throws BGException {
        byte[] result = null;
        if (this.data == null || startPos < 0 || length <= 0 || this.data.length - length < startPos) {
            throw new BGException("bytes parse error: can't find byte[] param " + name + " with start pos = " + startPos + "; and length = " + length);
        }
        result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.data[startPos + length - 1 - i];
        }
        return result;
    }
}

