/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access.sa;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CompositeFuture
implements Future<Boolean> {
    private final List<Future<?>> list;

    public CompositeFuture(List<Future<?>> list) {
        this.list = list;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = true;
        for (Future<?> f : this.list) {
            result &= f.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    @Override
    public boolean isCancelled() {
        boolean result = true;
        for (Future<?> f : this.list) {
            result &= f.isCancelled();
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        for (Future<?> f : this.list) {
            result &= f.isDone();
        }
        return result;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        boolean result = true;
        for (Future<?> f : this.list) {
            Object r = f.get();
            result &= !Boolean.FALSE.equals(r);
        }
        return result;
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        long lastTime = System.nanoTime();
        boolean result = true;
        for (Future<?> f : this.list) {
            Object r = f.get(nanos, TimeUnit.NANOSECONDS);
            result &= !Boolean.FALSE.equals(r);
            long now = System.nanoTime();
            nanos -= now - lastTime;
            lastTime = now;
        }
        return result;
    }
}

