/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOption;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOptionModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOptionService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOptionDao;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceOptionService")
public class VoiceOptionServiceImpl
extends AbstractService
implements VoiceOptionService {
    private VoiceOptionDao optionDao;

    @PostConstruct
    private void init() {
        this.optionDao = new VoiceOptionDao(this.getConnection(), this.moduleId);
    }

    public VoiceOption voiceOptionGet(int id) throws BGException {
        return (VoiceOption)this.optionDao.get(id);
    }

    public List<VoiceOption> voiceOptionList() throws BGException {
        return this.optionDao.list();
    }

    public int voiceOptionUpdate(VoiceOption b) throws BGException {
        try {
            VoiceOption oldOption = (VoiceOption)this.optionDao.getAndUpdate((Id)b);
            this.context.publishAfterCommit((Event)new VoiceOptionModifiedEvent(this.moduleId, this.userId, oldOption, b));
            return b.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void voiceOptionDelete(int id) throws BGException {
        try {
            VoiceOption oldOption = (VoiceOption)this.optionDao.getAndDelete(id);
            this.context.publishAfterCommit((Event)new VoiceOptionModifiedEvent(this.moduleId, this.userId, oldOption, null));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

