/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.attributes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.directory.attributes.AttributesCommonPanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;

public class AttributesPanel
extends AttributesCommonPanel<StockItemAttribute> {
    protected AttributesPanel() {
        super("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
    }

    @Override
    protected void jbInit0() {
    }

    @Override
    protected void refreshImpl() throws Exception {
        this.list.setData(this.getWarehouseService().getAttributeList());
    }

    @Override
    protected void toolbarNewItem() {
        new AttributeEditorDialog(null).open();
    }

    @Override
    protected void toolbarEditItem(StockItemAttribute attribute) {
        new AttributeEditorDialog(attribute).open();
    }

    @Override
    protected void toolbarDeleteItem(StockItemAttribute attribute) throws Exception {
        if (ClientUtils.confirm((String)"\u0412\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0442\u043e\u0432\u0430\u0440\u0430\u0445 \u043d\u0430 \u0441\u043a\u043b\u0430\u0434\u0435 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b! \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435") && ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
            this.getWarehouseService().deleteAttribute(attribute.getId());
            this.performAction("refresh");
        }
    }

    private final class AttributeEditorDialog
    extends BGEditorDialog<StockItemAttribute> {
        private JPanel editorPanel;
        private final JTextField title;
        private final JCheckBox required;
        private final JCheckBox unique;
        private final BGUComboBox<StockItemAttributeType> type;

        public AttributeEditorDialog(StockItemAttribute data) {
            super("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442", (Object)data);
            this.title = new JTextField(20);
            this.required = new JCheckBox("\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
            this.unique = new JCheckBox("\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439");
            this.type = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.editorPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.editorPanel.add((Component)new JLabel("\u0422\u0438\u043f"), constraints);
            this.editorPanel.add((Component)this.type, constraints);
            this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), constraints);
            this.editorPanel.add((Component)this.title, constraints);
            this.editorPanel.add((Component)this.required, constraints);
            this.editorPanel.add((Component)this.unique, constraints);
            this.panel.add(this.editorPanel);
            this.type.setData(Arrays.asList(StockItemAttributeType.values()));
            if (this.data != null) {
                this.title.setText(((StockItemAttribute)this.data).getTitle());
                this.type.setSelectedItem((Object)((StockItemAttribute)this.data).getAttributeType());
                this.required.setSelected(((StockItemAttribute)this.data).isRequired());
                this.unique.setSelected(((StockItemAttribute)this.data).isUnique());
            }
        }

        public boolean doApply() throws Exception {
            if (this.type.getSelectedItem() == null) {
                BGToolTip.showErrorMessage(this.type, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
                return false;
            }
            if (Utils.isBlankString((String)this.title.getText())) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (this.data == null) {
                this.data = new StockItemAttribute();
            }
            ((StockItemAttribute)this.data).setTitle(this.title.getText());
            ((StockItemAttribute)this.data).setAttributeType((StockItemAttributeType)this.type.getSelectedItem());
            ((StockItemAttribute)this.data).setRequired(this.required.isSelected());
            ((StockItemAttribute)this.data).setUnique(this.unique.isSelected());
            AttributesPanel.this.getWarehouseService().updateAttribute((StockItemAttribute)this.data);
            AttributesPanel.this.performAction("refresh");
            return true;
        }
    }
}

