/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import bitel.billing.module.common.table.BGColorCell;
import bitel.billing.module.common.table.BGRadio;
import bitel.billing.module.common.table.Button;
import javax.swing.table.TableCellRenderer;

public abstract class BGTableColumn {
    protected String id;
    protected String title;
    protected int[] columnsWidth;
    protected boolean resizingColumn = false;
    protected String columnsClass = "";
    private boolean editable = false;
    protected String columnOrderName = null;
    protected TableCellRenderer tableCellRenderer = null;

    private BGTableColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
        this.id = id;
        this.title = title;
        this.columnsWidth = widthColumn;
        this.resizingColumn = resizingColumn;
        this.columnsClass = columnClass;
    }

    public BGTableColumn() {
    }

    private void init(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
        this.id = id;
        this.title = title;
        this.columnsWidth = widthColumn;
        this.resizingColumn = resizingColumn;
        this.columnsClass = columnClass;
    }

    public String getColumnOrderName() {
        return this.columnOrderName;
    }

    public void setColumnOrderName(String newName) {
        this.columnOrderName = newName;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getColumnsWidth() {
        return this.columnsWidth;
    }

    public int getColumnWidth(int index) {
        return index >= this.columnsWidth.length ? -1 : this.columnsWidth[index];
    }

    public boolean isResizingColumn() {
        return this.resizingColumn;
    }

    public String getColumnsClass() {
        return this.columnsClass;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public static BGTableColumn getInstance(String id, String title, int[] widthColumn, boolean resizeing, String columnsClass) {
        if ("java.lang.Boolean".equals(columnsClass)) {
            return new BoolColumn(id, title, widthColumn, resizeing, columnsClass);
        }
        if ("bitel.billing.module.common.table.BGRadio".equals(columnsClass)) {
            return new RadioColumn(id, title, widthColumn, resizeing, columnsClass);
        }
        if ("bitel.billing.module.common.table.Button".equals(columnsClass)) {
            return new ButtonColumn(id, title, widthColumn, resizeing, columnsClass);
        }
        if ("bitel.billing.module.common.table.BGColorCell".equals(columnsClass)) {
            return new ColorColumn(id, title, widthColumn, resizeing, columnsClass);
        }
        if (columnsClass != null && !"".equals(columnsClass)) {
            try {
                Class<?> clazz = Class.forName(columnsClass);
                if (BGTableColumn.class.isAssignableFrom(clazz)) {
                    BGTableColumn result = (BGTableColumn)clazz.newInstance();
                    result.init(id, title, widthColumn, resizeing, columnsClass);
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new OtherColumn(id, title, widthColumn, resizeing, columnsClass);
        }
        return new StringColumn(id, title, widthColumn, resizeing, "");
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public abstract Object getValue(String var1);

    public TableCellRenderer getCellRenderer() {
        return this.tableCellRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    private static class BoolColumn
    extends BGTableColumn {
        public BoolColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            return item != null && (item.equalsIgnoreCase("true") || item.equals("1")) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class RadioColumn
    extends BGTableColumn {
        public RadioColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            return new BGRadio(item);
        }
    }

    private static class ButtonColumn
    extends BGTableColumn {
        public ButtonColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            return new Button(item);
        }
    }

    private static class ColorColumn
    extends BGTableColumn {
        public ColorColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            return new BGColorCell(item);
        }
    }

    private static class OtherColumn
    extends BGTableColumn {
        public OtherColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            try {
                return Class.forName(this.columnsClass).newInstance();
            }
            catch (Exception exception) {
                return item;
            }
        }
    }

    private static class StringColumn
    extends BGTableColumn {
        public StringColumn(String id, String title, int[] widthColumn, boolean resizingColumn, String columnClass) {
            super(id, title, widthColumn, resizingColumn, columnClass);
        }

        @Override
        public Object getValue(String item) {
            return item;
        }
    }
}

