/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import bitel.billing.server.contract.bean.find.SearchContract;
import bitel.billing.server.contract.bean.find.SearchContractModule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SearchContractByAddress
extends SearchContractModule {
    @Override
    public String getName() {
        return "address";
    }

    @Override
    public List<Contract> findContracts(Connection con, SearchContract search, String param, Date date) {
        String sqlDate = TimeUtils.formatSQLDate((Date)date);
        StringBuilder query = new StringBuilder(200);
        this.addContractSelectPart(query);
        query.append(" INNER JOIN contract_parameter_type_2 ");
        query.append(" AS addr ON contract.id=addr.cid ");
        query.append(" INNER JOIN address_house as house ");
        query.append(" ON addr.hid=house.id");
        query.append(" WHERE ");
        this.addContractFilter(query, search, sqlDate);
        this.addWhereQuery(query, this.parseAddressFromParam(param));
        this.addLimitAndTitleRegexpFilter(query, search);
        return this.extractContracts(con, query.toString());
    }

    private Map<String, String> parseAddressFromParam(String param) {
        Pattern p = Pattern.compile("(\\{\\d+\\})(\\{\\d+\\})(\\{[\\W\u0410-\u044fA-z0-9]*\\})(\\{\\d+\\})");
        Matcher m = p.matcher(param);
        if (m.find()) {
            String streetid = param.substring(m.start(1) + 1, m.end(1) - 1);
            String housenum = param.substring(m.start(2) + 1, m.end(2) - 1);
            String fracnum = param.substring(m.start(3) + 1, m.end(3) - 1);
            String flatnum = param.substring(m.start(4) + 1, m.end(4) - 1);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("streetid", streetid);
            result.put("housenum", housenum);
            result.put("fracnum", fracnum);
            result.put("flatnum", flatnum);
            return result;
        }
        return null;
    }

    private void addWhereQuery(StringBuilder query, Map<String, String> values) {
        if (values != null) {
            String val = values.get("streetid");
            if (Utils.parseInt((String)val) > 0) {
                query.append(" AND house.streetid=" + val);
            }
            if (Utils.parseInt((String)(val = values.get("housenum"))) > 0) {
                query.append(" AND house.house=" + val);
            }
            if (Utils.parseInt((String)(val = values.get("flatnum"))) > 0) {
                query.append(" AND addr.flat REGEXP '^[^[:digit:]]*" + val + "[^[:digit:]]*$'");
            }
            if (Utils.notBlankString((String)(val = values.get("fracnum"))) && !val.equals("0")) {
                query.append(" AND house.frac='" + val + "'");
            }
        } else {
            query.append(" AND 1=0 ");
        }
    }

    private List<Contract> extractContracts(Connection con, String query) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            PreparedStatement ps = con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Contract contract = new Contract();
                contract.setId(rs.getInt(1));
                contract.setTitle(rs.getString(2));
                contract.setComment(rs.getString(3));
                result.add(contract);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

