/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.client;

import bitel.billing.module.common.BSHEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.table.BGTableModel;

public class ScriptLibraryTabPanel
extends BGTabPanel {
    public static final String TAB_ID = "LibScriptFunctions";
    private BGEditor bgEditor = new BGEditor("table");
    private ScriptLibraryPanel scriptLibraryPanel;
    private Editor editorPanel;
    private ScriptHistoryPanel shPanel;
    private ViewBackupPanel viewer;

    public ScriptLibraryTabPanel() {
        super(TAB_ID, "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432 (\u0443\u0441\u0442\u0430\u0440\u0435\u043b\u043e)");
        this.module = "script";
        this.setLayout(new BorderLayout());
        this.add((Component)this.bgEditor, "Center");
        this.bgEditor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, (Object)this, "setData"));
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.scriptLibraryPanel = new ScriptLibraryPanel();
        this.bgEditor.addForm((JComponent)((Object)this.scriptLibraryPanel));
        this.editorPanel = new Editor();
        this.bgEditor.addForm((JComponent)((Object)this.editorPanel));
        this.shPanel = new ScriptHistoryPanel(2);
        this.bgEditor.addForm((JComponent)((Object)this.shPanel));
        this.viewer = new ViewBackupPanel();
        this.bgEditor.addForm((JComponent)((Object)this.viewer));
        this.bgEditor.show("table");
        this.setData();
    }

    public void setData() {
        this.scriptLibraryPanel.performAction("refresh");
    }

    public void editItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("edit");
    }

    public void newItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("new");
    }

    public void deleteItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("delete");
    }

    class ScriptLibraryPanel
    extends BGUPanel {
        private BGUTable table;
        private BGTableModel<ScriptLibrary> model;

        public ScriptLibraryPanel() {
            super((LayoutManager)new BorderLayout());
            this.model = new BGTableModel<ScriptLibrary>("script_lib"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0418\u043c\u044f", 120, 120, 200, "name", true);
                    this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 140, 140, -1, "title", true);
                }
            };
            this.setName("table");
        }

        protected void jbInit() {
            this.table = new BGUTable(this.model);
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ScriptLibraryTabPanel.this.editorPanel.performAction("edit");
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.table), (String)" \u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 (\u0443\u0441\u0442\u0430\u0440\u0435\u043b\u043e) "), "Center");
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.model.setData(((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).pureList()));
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> ScriptLibraryTabPanel.this.editorPanel.performAction("new"));
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> ScriptLibraryTabPanel.this.editorPanel.performAction("edit"));
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                ScriptLibrary lib = (ScriptLibrary)((Object)((Object)ScriptLibraryTabPanel.this.scriptLibraryPanel.model.getSelectedRow()));
                if (lib != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043c\u0435\u0441\u0442\u0435 \u0441 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0443\u0434\u0430\u043b\u044f\u0442\u0441\u044f \u0432\u0441\u0435 \u0435\u0451 \u0431\u044d\u043a\u0430\u043f\u044b. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.tryCall(() -> {
                        ((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).deleteLibrary(lib.getId());
                        this.performAction("refresh");
                    });
                }
            });
        }
    }

    class Editor
    extends BGUPanel {
        private BGTextField name;
        private BGTextField title;
        private BSHEditor script;
        private String currentId;

        public Editor() {
            super((LayoutManager)new BorderLayout());
            this.setName("editor");
        }

        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.name = new BGTextField();
            this.title = new BGTextField();
            this.script = new BSHEditor();
            this.add(BGSwingUtilites.wrapBorder((JComponent)this.name, (String)" \u0418\u043c\u044f "), new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(BGSwingUtilites.wrapBorder((JComponent)this.title, (String)" \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 "), new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(BGSwingUtilites.wrapBorder((JPanel)this.script, (String)" \u041a\u043e\u0434 "), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
            DocumentListener dlistener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }
            };
            this.script.getTextPane().getDocument().addDocumentListener(dlistener);
            this.title.getDocument().addDocumentListener(dlistener);
            this.name.getDocument().addDocumentListener(dlistener);
            this.buttonChange(false);
        }

        protected void initActions() {
            this.getActionMap().put("left.backup", (Action)new BGUAction("left.backup", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e"){

                public void actionPerformed(ActionEvent e) {
                    ClientUtils.showMessageDialog((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
                }
            });
            this.getActionMap().put("left.history", (Action)new BGUAction("left.history", "\u0418\u0441\u0442\u043e\u0440\u0438\u044f"){

                public void actionPerformed(ActionEvent e) {
                    Integer scriptId = Integer.valueOf(Editor.this.currentId);
                    if (scriptId > 0) {
                        ScriptLibraryTabPanel.this.shPanel.currentId = scriptId;
                        ScriptLibraryTabPanel.this.shPanel.performAction("refresh");
                        ScriptLibraryTabPanel.this.bgEditor.show("history");
                    }
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ClientUtils.showMessageDialog((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Editor.this.getActionMap().get("ok").isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        Editor.this.getActionMap().get("ok").actionPerformed(e);
                    }
                    this.getParentAction().actionPerformed(e);
                }
            };
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> ClientUtils.showMessageDialog((Object)"\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434"));
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                if (this.isShowing()) {
                    this.performAction("nothing");
                    return;
                }
                ScriptLibrary lib = (ScriptLibrary)((Object)((Object)ScriptLibraryTabPanel.this.scriptLibraryPanel.model.getSelectedRow()));
                String string = this.currentId = lib != null ? String.valueOf(lib.getId()) : null;
                if (this.currentId != null && (lib = this.getLastLibrary()) != null) {
                    this.currentId = String.valueOf(lib.getId());
                    this.name.setText(lib.getName());
                    this.title.setText(lib.getTitle());
                    this.script.setText(lib.getScript());
                    this.scriptIsExist(true);
                    this.buttonChange(false);
                    this.performActionOpen();
                }
            });
        }

        private ScriptLibrary getLastLibrary() {
            Integer scriptId = Integer.valueOf(this.currentId);
            if (scriptId != null) {
                try {
                    return ((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).getLibrary(scriptId);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            return null;
        }

        private void buttonChange(boolean enable) {
            Action okButton = this.getActionMap().get("ok");
            if (okButton.isEnabled() != enable) {
                okButton.setEnabled(enable);
            }
        }

        private void scriptIsExist(boolean exist) {
            this.name.setEditable(!exist);
            this.getActionMap().get("left.backup").setEnabled(exist);
            this.getActionMap().get("left.history").setEnabled(exist);
        }
    }

    class ScriptHistoryPanel
    extends BGUPanel {
        protected int currentId;
        private int scriptType;
        private BGUTable table;
        private BGTableModel<ScriptBackup> model;

        public ScriptHistoryPanel(int type) {
            super((LayoutManager)new BorderLayout());
            this.model = new BGTableModel<ScriptBackup>("script_backup"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0412\u0440\u0435\u043c\u044f", 150, 150, 220, "time", true);
                    this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 150, 220, "userName", true);
                    this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 300, 300, 400, "title", false);
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 140, 140, -1, "comment", false);
                }

                public Object getValue(ScriptBackup val, int column) throws Exception {
                    if (column == 1) {
                        return TimeUtils.format((Date)val.getTimeRevision(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    return super.getValue((Object)val, column);
                }
            };
            this.setName("history");
            this.scriptType = type;
        }

        protected void jbInit() {
            this.table = new BGUTable(this.model);
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int selectedBackupId;
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (selectedBackupId = ((ScriptBackup)((Object)ScriptHistoryPanel.this.model.getSelectedRow())).getId()) > 0) {
                        ScriptLibraryTabPanel.this.viewer.currentBackupId = selectedBackupId;
                        ScriptLibraryTabPanel.this.viewer.performAction("refresh");
                        ScriptLibraryTabPanel.this.bgEditor.show("view");
                    }
                }
            });
            this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.table), (String)" \u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 "), "Center");
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.model.setData(((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).listBackup(this.currentId, this.scriptType)));
            new AbstractBGUPanel.DefaultAction("close", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ScriptLibraryTabPanel.this.bgEditor.show("editor");
                }
            };
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                ScriptBackup backup = (ScriptBackup)((Object)((Object)ScriptLibraryTabPanel.this.shPanel.model.getSelectedRow()));
                if (backup != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u044d\u043a\u0430\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.tryCall(() -> {
                        ((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).deleteBackup(backup.getId());
                        this.performAction("refresh");
                    });
                }
            });
        }
    }

    public class ViewBackupPanel
    extends BGUPanel {
        protected int currentBackupId;
        private BGTextField title;
        private BSHEditor script;

        public ViewBackupPanel() {
            super((LayoutManager)new GridBagLayout());
            this.setName("view");
        }

        protected void jbInit() {
            this.title = new BGTextField();
            this.script = new BSHEditor();
            this.add(BGSwingUtilites.wrapBorder((JComponent)this.title, (String)" \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(BGSwingUtilites.wrapBorder((JPanel)this.script, (String)" \u041a\u043e\u0434 "), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                ScriptBackup backup = ((ScriptService)((ClientContext)this.getContext()).getPort(ScriptService.class)).getBackup(this.currentBackupId);
                this.title.setText(backup.getTitle());
                this.script.setText(backup.getScript());
            });
            new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ScriptLibraryTabPanel.this.bgEditor.show("history");
                }
            };
        }
    }
}

