/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.ufanet;

import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.server.api.SmarthouseManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class UfanetManager
extends SmarthouseManager {
    private String contract = null;
    private String password = null;

    public UfanetManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("ufanet.server.url", "https://dom.ufanet.ru/");
        this.contract = moduleSetup.get("ufanet.server.contract");
        this.password = moduleSetup.get("ufanet.server.password");
        this.readTimeout = moduleSetup.getInt("ufanet.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("ufanet.request.timeout.connect", 10000);
    }

    public JSONObject apiTokenAuth() throws Exception {
        JSONObject json = new JSONObject();
        json.put("contract", (Object)this.contract);
        json.put("password", (Object)this.password);
        return this.doRequest("/api/v3/api-token-auth/", "POST", json.toString());
    }

    public JSONObject apiTokenVerify() throws Exception {
        JSONObject json = new JSONObject();
        json.put("token", (Object)this.token);
        return this.doRequest("/api/v3/api-token-verify/", "POST", json.toString());
    }

    @Override
    protected String getToken() throws Exception {
        JSONObject object = this.apiTokenVerify();
        this.token = object.optString("token");
        return this.token;
    }

    @Override
    protected void errorSetServerUrl() throws Exception {
        throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"ufanet.server.url=\"");
    }

    @Override
    protected void errorGetToken() throws Exception {
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u043e\u043a\u0435\u043d\u0430, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \"ufanet.contract=\", \"ufanet.password=\"");
    }

    @Override
    protected String getTokenType() {
        return "JWT";
    }
}

