/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.processor.NASSession;
import bitel.billing.server.radius.RadiusSetup;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.util.MacrosProcessor;

public class ScriptNasConnectionInspector
extends NasConnectionInspector {
    private MacrosProcessor checkMacros;
    private MacrosProcessor killMacros;

    public ScriptNasConnectionInspector(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connections, ParameterMap params, NasConnectionInspector old) {
        super(setup, nasIPAddress, secret, connections, params, old);
        String killCommand;
        String checkCommand = params.get("nas.inspector.check.command", "");
        if (Utils.notBlankString((String)checkCommand)) {
            this.checkMacros = new MacrosProcessor(checkCommand);
        }
        if (Utils.notBlankString((String)(killCommand = params.get("nas.inspector.kill.command", "")))) {
            this.killMacros = new MacrosProcessor(killCommand);
        }
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> con) {
        NASSession session = (NASSession)con.getSession();
        if (this.checkMacros == null) {
            session.addLogError("Can't run check script");
            session.addLogError("Param nas.inspector.check.command is empty for ScriptNASConnectionInspector");
        } else {
            String checkCommand = this.checkMacros.getProcessedString(this.getParams(con));
            session.addLogDebug("Execute check script " + checkCommand);
            Process process = this.runProcess(checkCommand, con);
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                session.addLogError(e.getMessage());
                e.printStackTrace();
            }
            int exitValue = process.exitValue();
            session.addLogDebug("Return value: " + exitValue);
            if (exitValue == 0) {
                con.setStatus(NasConnection.Status.working);
            } else {
                con.setStatus(NasConnection.Status.suspended);
            }
        }
    }

    @Override
    protected long sendKillRequest(NasConnection<?> con) {
        NASSession session = (NASSession)con.getSession();
        if (this.killMacros == null) {
            session.addLogError("Can't run kill script");
            session.addLogError("Param nas.inspector.kill.command is empty for ScriptNASConnectionInspector");
        } else {
            String killCommand = this.killMacros.getProcessedString(this.getParams(con));
            session.addLogInfo("Execute kill script " + killCommand);
            this.runProcess(killCommand, con);
        }
        return 0L;
    }

    private Process runProcess(String command, NasConnection<?> connection) {
        Process result = null;
        NASSession session = (NASSession)connection.getSession();
        try {
            result = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            session.addLogError(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private Map<String, String> getParams(NasConnection<?> connection) {
        HashMap<String, String> result = new HashMap<String, String>(20);
        NASSession session = (NASSession)connection.getSession();
        result.put("NAS_IP", this.nas.getNasIPAddress().getHostAddress());
        result.put("NAS_ID", this.nas.getNasIdentifier());
        result.put("USER_LOGIN", session.getLoginName());
        result.put("USER_SESSION", session.getAcctSessionId());
        result.put("USER_PORT", session.getNasPort());
        return result;
    }
}

