/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.concurrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.util.AbstractBlockingDeque;

public class FileBackedBlockingDeque<E>
extends AbstractBlockingDeque<E> {
    private final RandomAccessFile file;
    private FileChannel channel;
    private final ObjectOutputStream out;
    private final long initialPosition;
    private final ArrayDeque<E> queue;
    protected final ArrayDeque<FilePointer> filePointers;
    protected final ArrayDeque<FilePointer> endFilePointers;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(131072);

    public FileBackedBlockingDeque(File file, int capacity) throws BGException {
        super(capacity);
        this.queue = new ArrayDeque();
        this.count = 0;
        this.filePointers = new ArrayDeque();
        this.endFilePointers = new ArrayDeque();
        try {
            file.getParentFile().mkdirs();
            List<Object> oldList = Collections.emptyList();
            try {
                oldList = this.extractFromFile(file);
            }
            catch (Exception ex) {
                BGLogger.error((Throwable)ex);
            }
            file.delete();
            file.createNewFile();
            this.file = new RandomAccessFile(file, "rwd");
            this.out = new ObjectOutputStream(new FileOutputStream(this.file.getFD()));
            this.out.flush();
            this.initialPosition = this.file.getFilePointer();
            for (Object e : oldList) {
                this.insertLast(e, false);
            }
            this.channel = this.file.getChannel();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    private List<E> extractFromFile(File file) throws ClassNotFoundException, IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!file.exists()) {
            return result;
        }
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(raFile.getFD()));
            try {
                Object o;
                while ((o = in.readObject()) != null) {
                    result.add(o);
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (IOException ex) {
            BGLogger.error((Throwable)ex);
        }
        raFile.close();
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected E first() {
        return this.queue.peekFirst();
    }

    @Override
    protected boolean linkFirst(E e, boolean signal) {
        if (this.count >= this.capacity) {
            return false;
        }
        try {
            long count;
            long position;
            if (this.count == 0) {
                position = this.initialPosition;
                count = 0L;
            } else {
                position = this.endFilePointers.peekFirst().value;
                count = this.endFilePointers.peekLast().value - position;
            }
            this.file.seek(this.initialPosition);
            if ((long)this.byteBuffer.capacity() < count) {
                this.byteBuffer = ByteBuffer.allocate((int)count);
            }
            this.byteBuffer.clear();
            this.channel.read(this.byteBuffer, position);
            this.byteBuffer.flip();
            this.channel.position(this.initialPosition);
            this.out.writeObject(e);
            this.out.reset();
            this.out.flush();
            position = this.file.getFilePointer();
            count = position - this.initialPosition;
            this.channel.write(this.byteBuffer);
            for (FilePointer filePointer : this.filePointers) {
                filePointer.value += count;
            }
            for (FilePointer filePointer : this.endFilePointers) {
                filePointer.value += count;
            }
            this.filePointers.addFirst(new FilePointer(this, this.initialPosition));
            this.endFilePointers.addFirst(new FilePointer(this, position));
            this.queue.addFirst(e);
            ++this.count;
            if (signal) {
                this.notEmpty.signal();
            }
            return true;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected boolean linkLast(E e, boolean signal) {
        if (this.count >= this.capacity) {
            return false;
        }
        this.insertLast(e, signal);
        return true;
    }

    private void insertLast(E e, boolean signal) {
        try {
            this.filePointers.add(new FilePointer(this, this.file.getFilePointer()));
            this.out.writeObject(e);
            this.out.reset();
            this.out.flush();
            this.endFilePointers.add(new FilePointer(this, this.file.getFilePointer()));
            this.queue.offer(e);
            ++this.count;
            if (signal) {
                this.notEmpty.signal();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected E unlinkFirst() {
        if (this.count == 0) {
            return null;
        }
        try {
            long position = this.endFilePointers.peekFirst().value;
            long count = this.endFilePointers.peekLast().value - position;
            this.file.seek(this.initialPosition);
            if ((long)this.byteBuffer.capacity() < count) {
                this.byteBuffer = ByteBuffer.allocate((int)count);
            }
            this.byteBuffer.clear();
            this.channel.read(this.byteBuffer, position);
            this.byteBuffer.flip();
            this.channel.position(this.initialPosition);
            this.channel.write(this.byteBuffer);
            this.file.setLength(count + this.initialPosition);
            E e = this.queue.pollFirst();
            this.filePointers.pollFirst();
            this.endFilePointers.pollFirst();
            for (FilePointer filePointer : this.filePointers) {
                filePointer.value -= position - this.initialPosition;
            }
            for (FilePointer filePointer : this.endFilePointers) {
                filePointer.value -= position - this.initialPosition;
            }
            --this.count;
            this.notFull.signal();
            return e;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected E unlinkLast() {
        try {
            long position = this.filePointers.removeLast().value;
            this.endFilePointers.removeLast();
            this.file.seek(position);
            this.file.setLength(position);
            E e = this.queue.pollLast();
            --this.count;
            this.notFull.signal();
            return e;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public E peekFirst() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.queue.peekFirst();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peekLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.queue.peekLast();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    public static void main(String[] args) throws BGException {
        FileBackedBlockingDeque<Integer> deque = new FileBackedBlockingDeque<Integer>(new File("data/back/inetServDatabase.queue"), 100);
        deque.push(1);
        deque.push(2);
        deque.push(3);
        System.out.println(deque.poll());
        System.out.println(deque.poll());
        System.out.println(deque.poll());
        System.out.println(deque.poll());
    }

    class FilePointer {
        public long value;

        public FilePointer(FileBackedBlockingDeque this$0, long value) {
            this.value = value;
        }
    }
}

