/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.common.bean.export;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.modules.bill.common.bean.export.BillContract;
import ru.bitel.bgbilling.modules.bill.common.bean.export.BillCustomer;
import ru.bitel.bgbilling.modules.bill.common.bean.export.BillService;

public class BillContractOrder {
    private LocalDateTime orderDate;
    private String orderNumber;
    private String orderOrgTitle;
    private BigDecimal orderSum;
    private BillCustomer billCustomer;
    private BillContract billContract;
    private List<BillService> billServices;

    public LocalDateTime getOrderDate() {
        return this.orderDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getOrderOrgTitle() {
        return this.orderOrgTitle;
    }

    public BigDecimal getOrderSum() {
        return this.orderSum;
    }

    public BillCustomer getBillCustomer() {
        return this.billCustomer;
    }

    public BillContract getBillContract() {
        return this.billContract;
    }

    public List<BillService> getBillServices() {
        return this.billServices;
    }

    public BillContractOrder setOrderDate(LocalDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    public BillContractOrder setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    public BillContractOrder setOrderOrgTitle(String orderOrgTitle) {
        this.orderOrgTitle = orderOrgTitle;
        return this;
    }

    public BillContractOrder setOrderSum(BigDecimal orderSum) {
        this.orderSum = orderSum;
        return this;
    }

    public BillContractOrder setBillCustomer(BillCustomer billCustomer) {
        this.billCustomer = billCustomer;
        return this;
    }

    public BillContractOrder setBillContract(BillContract billContract) {
        this.billContract = billContract;
        return this;
    }

    public BillContractOrder setBillServices(List<BillService> billServices) {
        this.billServices = billServices;
        return this;
    }

    public void toXml(OutputStream outputStream) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter doc = factory.createXMLStreamWriter(outputStream, "UTF-8");
        this.writeStartElement(doc, "\u0417\u0430\u043a\u0430\u0437\u041a\u043b\u0438\u0435\u043d\u0442\u0430");
        this.writeStartElement(doc, "\u0414\u0430\u0442\u0430", Optional.ofNullable(this.orderDate).map(a -> this.orderDate.toString()).orElse(""));
        this.writeStartElement(doc, "\u041d\u043e\u043c\u0435\u0440", Optional.ofNullable(this.orderNumber).orElse(""));
        this.writeStartElement(doc, "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", Optional.ofNullable(this.orderOrgTitle).orElse(""));
        this.writeStartElement(doc, "\u0421\u0443\u043c\u043c\u0430", Optional.ofNullable(this.orderSum).map(a -> a.toPlainString()).orElse(""));
        if (this.billCustomer != null) {
            this.writeStartElement(doc, "\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442");
            this.writeStartElement(doc, "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", Optional.ofNullable(this.billCustomer.getTitle()).orElse(""));
            this.writeStartElement(doc, "\u0418\u041d\u041d", Optional.ofNullable(this.billCustomer.getInn()).orElse(""));
            this.writeStartElement(doc, "\u041a\u041f\u041f", Optional.ofNullable(this.billCustomer.getKpp()).orElse(""));
            this.writeEndElement(doc);
        }
        if (this.billContract != null) {
            this.writeStartElement(doc, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
            this.writeStartElement(doc, "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", Optional.ofNullable(this.billContract.getTitle()).orElse(""));
            this.writeEndElement(doc);
        }
        if (this.billServices != null) {
            this.writeStartElement(doc, "\u0423\u0441\u043b\u0443\u0433\u0438");
            for (BillService billService : this.billServices) {
                this.writeStartElement(doc, "\u0421\u0442\u0440\u043e\u043a\u0430");
                this.writeStartElement(doc, "\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0430", Optional.ofNullable(billService.getNomenclature()).orElse(""));
                this.writeStartElement(doc, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", Optional.ofNullable(billService.getAmount()).map(a -> a.toPlainString()).orElse(""));
                this.writeStartElement(doc, "\u0421\u0443\u043c\u043c\u0430", Optional.ofNullable(billService.getSum()).map(a -> a.toPlainString()).orElse(""));
                this.writeStartElement(doc, "\u0426\u0435\u043d\u0430", Optional.ofNullable(billService.getCost()).map(a -> a.toPlainString()).orElse(""));
                this.writeStartElement(doc, "\u0421\u0442\u0430\u0432\u043a\u0430\u041d\u0414\u0421", Optional.ofNullable(billService.getRateNds()).orElse(""));
                this.writeStartElement(doc, "\u0421\u0443\u043c\u043c\u0430\u041d\u0414\u0421", Optional.ofNullable(billService.getSumNds()).map(a -> a.toPlainString()).orElse(""));
                this.writeStartElement(doc, "\u0421\u0443\u043c\u043c\u0430\u0421\u041d\u0414\u0421", Optional.ofNullable(billService.getSumWithNds()).map(a -> a.toPlainString()).orElse(""));
                this.writeStartElement(doc, "\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435", Optional.ofNullable(billService.getContent()).orElse(""));
                this.writeEndElement(doc);
            }
            this.writeEndElement(doc);
        }
        this.writeEndElement(doc);
    }

    private void writeStartElement(XMLStreamWriter doc, String name) throws Exception {
        doc.writeStartElement(name);
        doc.writeCharacters("\n");
    }

    private void writeStartElement(XMLStreamWriter doc, String name, String text) throws Exception {
        doc.writeStartElement(name);
        doc.writeCharacters(text);
        doc.writeEndElement();
        doc.writeCharacters("\n");
    }

    private void writeEndElement(XMLStreamWriter doc) throws Exception {
        doc.writeEndElement();
        doc.writeCharacters("\n");
    }

    public static void main(String[] args) {
        ArrayList<BillService> billServices = new ArrayList<BillService>();
        billServices.add(new BillService().setNomenclature("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430 \u0437\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u0437\u0430 \u0430\u0432\u0433\u0443\u0441\u0442 2025\u0433.").setAmount(new BigDecimal(1)).setSum(new BigDecimal(6000)).setCost(new BigDecimal(5000)).setRateNds("\u041d\u0414\u042120").setSumNds(new BigDecimal(1000)).setSumWithNds(new BigDecimal(6000)).setContent("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430 \u0437\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u0437\u0430 \u0430\u0432\u0433\u0443\u0441\u0442 2025\u0433."));
        BillContractOrder order = new BillContractOrder().setOrderDate(LocalDate.now().atStartOfDay()).setOrderNumber("\u0410-004721").setOrderOrgTitle("\u041e\u041e\u041e \"\u041d\u042d\u0422\u0412\u042d\u0419\"").setOrderSum(new BigDecimal(6000)).setBillCustomer(new BillCustomer().setTitle("\u0420\u041f\u0413 20 \u041e\u041e\u041e").setInn("77210121212").setKpp("77210121212")).setBillContract(new BillContract().setTitle("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435...")).setBillServices(billServices);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            order.toXml(byteArrayOutputStream);
            System.out.println(new String(byteArrayOutputStream.toString("UTF-8")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

