/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load.bean;

import bitel.billing.server.load.bean.Source;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class SourceManager {
    private Connection con;

    public SourceManager(Connection con) {
        this.con = con;
    }

    public void updateSource(Source source) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (source.getId() <= 0) {
                query = "INSERT INTO source ( title, date1, date2, comment, source_type, host_or_dir, user, pswd, config, mid ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(10, source.getMid());
            } else {
                query = "UPDATE source set title=?, date1=?, date2=?, comment=?, source_type=?, host_or_dir=?, user=?, pswd=?, config=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(10, source.getId());
            }
            ps.setString(1, source.getTitle());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)source.getDate1()));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)source.getDate2()));
            ps.setString(4, source.getComment());
            ps.setInt(5, source.getType());
            ps.setString(6, source.getHostOrDir());
            ps.setString(7, source.getUser());
            ps.setString(8, source.getPswd());
            ps.setString(9, source.getConfig());
            ps.executeUpdate();
            if (source.getId() <= 0) {
                source.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Source> getSourceList(int mid) {
        ArrayList<Source> result = new ArrayList<Source>();
        try {
            String query = "SELECT * FROM source WHERE mid=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getSourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Source> getSourceList(int mid, Date dateFrom, Date dateTo) {
        ArrayList<Source> result = new ArrayList<Source>();
        try {
            int index = 1;
            String query = null;
            ResultSet rs = null;
            PreparedStatement ps = null;
            query = "SELECT * FROM source WHERE mid=? AND ( isNull(date1) OR date1<? ) AND ( isNull(date2) OR date2>=? ) ORDER BY title";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, mid);
            ps.setDate(index++, new java.sql.Date(dateTo.getTime()));
            ps.setDate(index++, new java.sql.Date(dateFrom.getTime()));
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getSourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Source> getSourceList(int mid, Calendar date) {
        ArrayList<Source> result = new ArrayList<Source>();
        try {
            Object query = "SELECT * FROM source WHERE mid=? ";
            if (date != null) {
                query = (String)query + "AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
            }
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, mid);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getSourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Source> getSourceList(int mid, int type, Calendar date, String idList) throws SQLException {
        ArrayList<Source> result = new ArrayList<Source>();
        String query = "SELECT * FROM source WHERE mid=? AND source_type=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) AND id IN ( " + idList + ")";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, mid);
        ps.setInt(2, type);
        ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
        ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)date));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getSourceFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public Source getSource(int id) {
        Source result = null;
        try {
            String query = "SELECT * FROM source WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getSourceFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteSource(int id) {
        try {
            String query = "DELETE FROM source WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Source getSourceFromRs(ResultSet rs) throws SQLException {
        Source result = new Source();
        result.setId(rs.getInt("id"));
        result.setMid(rs.getInt("mid"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setType(rs.getInt("source_type"));
        result.setHostOrDir(rs.getString("host_or_dir"));
        result.setUser(rs.getString("user"));
        result.setPswd(rs.getString("pswd"));
        result.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        result.setConfig(rs.getString("config"));
        return result;
    }
}

