/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.gorod.server.bean.Tag;

public class TagManager
extends AbstarctDaoConstant {
    public TagManager(Connection con, int moduleId) {
        super(con, "gorod_tag", moduleId);
    }

    public List<Tag> getTagList() throws SQLException {
        ArrayList<Tag> result = new ArrayList<Tag>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY id";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getTagFromRS(rs));
            }
        }
        return result;
    }

    public List<Tag> getTagListForContract(int contractId) throws SQLException {
        ArrayList<Tag> result = new ArrayList<Tag>();
        String query = "SELECT g1.id, g1.title FROM " + this.tableName + " AS g1 LEFT JOIN gorod_contract_tag_" + this.moduleId + " AS g2 ON g1.id=g2.tid WHERE cid=? ORDER BY tid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getTagFromRS(rs));
                }
            }
        }
        return result;
    }

    public Set<Integer> getTagSetForContract(int contractId) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        String query = "SELECT tid FROM gorod_contract_tag_" + this.moduleId + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }

    public Tag getTagById(int tagId) throws SQLException {
        Tag tag = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, tagId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    tag = this.getTagFromRS(rs);
                }
            }
        }
        return tag;
    }

    public void updateTag(Tag tag) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, tag.getTitle());
            ps.setInt(2, tag.getId());
            ps.executeUpdate();
        }
    }

    public void addTag(String tagTitle) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " SET title=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, tagTitle);
            ps.executeUpdate();
        }
    }

    public void deleteTag(int tagId) throws SQLException {
        String query = "DELETE FROM gorod_contract_tag_" + this.moduleId + " WHERE tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, tagId);
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.tableName + " WHERE id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, tagId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void deleteTagFromContract(int contractId, int tagId) throws SQLException {
        String query = "DELETE FROM gorod_contract_tag_" + this.moduleId + " WHERE cid=? AND tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, tagId);
            ps.executeUpdate();
        }
    }

    public void linkTagToContract(int contractId, int tagId) throws SQLException {
        String query = "INSERT INTO gorod_contract_tag_" + this.moduleId + " SET cid=?, tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, tagId);
            ps.executeUpdate();
        }
    }

    private Tag getTagFromRS(ResultSet rs) throws SQLException {
        return new Tag(rs.getInt("id"), rs.getString("title"));
    }
}

