/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class BotStatisticDao
extends AbstractIdDao<StatisticNote> {
    public BotStatisticDao(Connection con, int moduleId) {
        super(con, "bot_manager_statistic", moduleId);
    }

    public void getList(SearchResult<StatisticNote> searchResult) throws SQLException {
        List result = searchResult.getList();
        String where = searchResult.getAttribute("where");
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + (String)(Utils.notBlankString((String)where) ? " WHERE " + where : "") + this.sqlLimit(searchResult.getPage());
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            int foundRows = ServerUtils.foundRows((Connection)this.con);
            searchResult.optPage().ifPresent(a -> a.setRecordCount(foundRows));
        }
    }

    public void deleteByContractId(int contractId) throws SQLException {
        this.delete("contract_id=?", new Object[]{contractId});
    }

    public void deleteByBotId(int botId) throws SQLException {
        this.delete("bot_id=?", new Object[]{botId});
    }

    public List<StatisticNote> getListByContractId(int contractId) throws SQLException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " contract_id=" + contractId);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    public List<StatisticNote> getListByBotId(int botId) throws SQLException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " bot_id=" + botId);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    public List<StatisticNote> getList(int botId, int cid) throws SQLException {
        SearchResult searchResult = new SearchResult();
        searchResult.setList(new ArrayList());
        searchResult.setAttribute("where", " bot_id=" + botId + " and contract_id=" + cid);
        this.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult.getList();
    }

    protected StatisticNote getFromRS(ResultSet rs) throws SQLException {
        return (StatisticNote)this.ormFromResultSet(rs, StatisticNote.class);
    }

    protected void updateImpl(StatisticNote note) throws SQLException {
        String set = " SET contract_id=?, comment=?, bot_id=?, last_dialog_id=?, last_message_time=NOW()";
        boolean update = this.checkIsUpdate(note);
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + set + (update ? " WHERE messenger_user_id=?" : ", messenger_user_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, note.getContractId());
            ps.setString(index++, note.getComment());
            ps.setInt(index++, note.getBotId());
            ps.setInt(index++, note.getLastViewedDialogId());
            ps.setLong(index, note.getMessengerUserId());
            ps.executeUpdate();
        }
    }

    private boolean checkIsUpdate(StatisticNote note) throws SQLException {
        boolean result = false;
        String query = "select * from " + this.tableName + " where messenger_user_id=" + note.getMessengerUserId();
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                result = true;
            }
        }
        return result;
    }
}

