/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.restriction;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeMode;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeType;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeLoader;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.restriction.InetServRestrictionRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.TrafficRangeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class InetServRestrictionAccountRuntime
extends InetServRestrictionRuntime
implements TrafficRangeLoader {
    private static final BigDecimal ACCOUNT_MULTIPLICAND = BigDecimal.valueOf(100000L);
    private final int inetServId;
    private final long maxAmount;
    private final int trafficRangeMode;
    private final boolean account;
    private final String serviceIdsString;
    private final Set<Integer> serviceIds;

    public InetServRestrictionAccountRuntime(InetServRuntime inetServRuntime, InetServRestriction restriction, Calendar utilCalendar) {
        super(restriction, utilCalendar);
        this.inetServId = inetServRuntime.inetServId;
        switch (this.type) {
            case 10: 
            case 11: 
            case 12: {
                this.account = false;
                this.maxAmount = restriction.getAmount().longValue();
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                this.account = true;
                this.maxAmount = restriction.getAmount().multiply(ACCOUNT_MULTIPLICAND).longValue();
                break;
            }
            default: {
                this.account = false;
                this.maxAmount = 0L;
            }
        }
        switch (this.type) {
            case 10: 
            case 20: {
                this.trafficRangeMode = TrafficRangeMode.NON_PERSISTENT_ACCOUNTING_PERIOD.getCode();
                break;
            }
            case 11: 
            case 21: {
                this.trafficRangeMode = TrafficRangeMode.NON_PERSISTENT_MONTH.getCode();
                break;
            }
            case 12: 
            case 22: {
                this.trafficRangeMode = TrafficRangeMode.NON_PERSISTENT_DAY.getCode();
                break;
            }
            default: {
                this.trafficRangeMode = 0;
            }
        }
        String serviceIdsString = Utils.toString((Iterable)restriction.getServiceIds());
        this.serviceIdsString = Utils.isBlankString((String)serviceIdsString) ? null : serviceIdsString;
        Set serviceIds = Utils.toIntegerSet((String)this.serviceIdsString);
        this.serviceIds = serviceIds.size() == 0 ? null : serviceIds;
    }

    @Override
    protected Integer testImpl(InetTariffWorkerContext workerContext, InetApplication application, InetServRuntime inetServRuntime, InetConnectionRuntime connectionRuntime, InetTariffRequest req) throws BGException {
        if (req == null) {
            return null;
        }
        long treeNodeId = this.id;
        long amount = 0L;
        for (List serviceCostList : req.getServiceCost().values()) {
            int size = serviceCostList.size();
            for (int i = 0; i < size; ++i) {
                InetServiceCost serviceCost = (InetServiceCost)((Object)serviceCostList.get(i));
                if (serviceCost.getServiceId() <= 0 || serviceCost.getCost() == null || serviceCost.amountNull || this.serviceIds != null && !this.serviceIds.contains(serviceCost.getServiceId())) continue;
                if (this.account) {
                    amount += serviceCost.getCost().multiply(ACCOUNT_MULTIPLICAND).longValue();
                    continue;
                }
                amount += serviceCost.getAmount();
            }
        }
        long takedAmount = connectionRuntime != null ? ((TrafficRangeManager)application.tariffContext.rangedTrafficManager).addRangedTraffic(workerContext, connectionRuntime, 0, treeNodeId, this.trafficRangeMode, TrafficRangeType.RESTRICTION.getCode(), req.getTime(), this.maxAmount, amount, this, null, null) : application.tariffContext.rangedTrafficManager.addRangedTraffic((TariffWorkerContext)workerContext, req.contractId, req.accountingPeriodId, 0, treeNodeId, this.trafficRangeMode, TrafficRangeType.RESTRICTION.getCode(), req.getTime(), this.maxAmount, amount, (TrafficRangeLoader)this, null, null);
        if (takedAmount > 0L && takedAmount >= amount || amount == 0L && takedAmount == 0L || amount < 0L) {
            return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
        }
        return AccessCode.SERVICE_DENY.getCode();
    }

    public TrafficRange getRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        try {
            Connection con = workerContext.getConnection();
            int moduleId = workerContext.getModuleId();
            Calendar time = TrafficRangeKey.getTime((long)key, (Calendar)new GregorianCalendar());
            String what = this.account ? "SELECT SUM(account.account)" : "SELECT SUM(account.amount)";
            StringBuilder sb1 = new StringBuilder(100);
            StringBuilder sb2 = new StringBuilder(100);
            sb1.append(what).append(" FROM inet_connection_").append(moduleId).append(" as connection LEFT JOIN inet_session_").append(moduleId).append(" as session ON connection.id=session.connectionId LEFT JOIN inet_session_account_").append(moduleId).append(" as account ON session.id=account.sessionId WHERE account.contractId=? AND connection.servId=?");
            java.util.Date timeDate = time.getTime();
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)time);
            String logAccountTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (java.util.Date)timeDate, (int)moduleId);
            sb2.append(what).append(" FROM ").append(ServerUtils.getModuleMonthTableName((String)"inet_session_log", (java.util.Date)timeDate, (int)moduleId)).append(" as session LEFT JOIN ").append(logAccountTable).append(" as account ON session.id=account.sessionId WHERE account.contractId=? AND session.servId=?");
            switch (this.type) {
                case 12: 
                case 22: {
                    sb1.append(" AND DATE(session.sessionStart)=?");
                    sb2.append(" AND DATE(session.sessionStart)=?");
                    break;
                }
                case 11: 
                case 21: {
                    sb1.append(" AND DATE(session.sessionStart)>=?");
                    break;
                }
            }
            if (this.serviceIdsString != null) {
                sb1.append(" AND account.serviceId IN (").append(this.serviceIdsString).append(")");
                sb2.append(" AND account.serviceId IN (").append(this.serviceIdsString).append(")");
            }
            PreparedStatement ps1 = con.prepareStatement(sb1.toString());
            PreparedStatement ps2 = con.prepareStatement(sb2.toString());
            ps1.setInt(1, contractId);
            ps1.setInt(2, this.inetServId);
            ps2.setInt(1, contractId);
            ps2.setInt(2, this.inetServId);
            switch (this.type) {
                case 12: 
                case 22: {
                    ps1.setDate(3, sqlDate);
                    ps2.setDate(3, sqlDate);
                    break;
                }
                case 11: 
                case 21: {
                    ps1.setDate(3, sqlDate);
                    break;
                }
            }
            ResultSet rs = ps1.executeQuery();
            long amount = rs.next() ? rs.getLong(1) : 0L;
            rs.close();
            ps1.close();
            if (ServerUtils.tableExists((Connection)con, (String)logAccountTable)) {
                rs = ps2.executeQuery();
                if (rs.next()) {
                    amount += rs.getLong(1);
                }
                rs.close();
            }
            ps2.close();
            return new TrafficRange(0, amount, this.maxAmount);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

