/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;

public class SubscriptionPeriodDao
extends AbstractIdDao<RegistrationPeriod> {
    protected final int userId;

    public SubscriptionPeriodDao(Connection con, int moduleId, int userId) {
        super(con, "subscription_period", moduleId);
        this.userId = userId;
    }

    protected RegistrationPeriod getFromRS(ResultSet rs) throws SQLException {
        return RegistrationPeriod.builder().setId(rs.getInt("id")).setSubscriptionId(rs.getInt("subscription_id")).setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setDateCreate((Date)rs.getTimestamp("date_create")).setWhoCreate(rs.getInt("who_create")).build();
    }

    protected void updateImpl(RegistrationPeriod registrationPeriod) throws SQLException {
        Objects.requireNonNull(registrationPeriod);
        String query = "INSERT INTO " + this.tableName + " SET subscription_id=?, date_from=?, date_to=?, date_create=?, who_create=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            PeriodWithTime period = registrationPeriod.getPeriod();
            int index = 1;
            ps.setInt(index++, registrationPeriod.getSubscriptionId());
            ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()) : null);
            ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateTo()) : null);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)registrationPeriod.getDateCreate()));
            ps.setInt(index++, registrationPeriod.getWhoCreate());
            ps.executeUpdate();
            registrationPeriod.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public List<RegistrationPeriod> list(int subscriptionId) throws SQLException {
        return super.list("subscription_id=?", "id", new Object[]{subscriptionId});
    }

    public Map<Integer, RegistrationPeriod> map(List<Integer> registrationPeriodIds) throws SQLException {
        HashMap<Integer, RegistrationPeriod> result = new HashMap<Integer, RegistrationPeriod>();
        if (registrationPeriodIds != null && !registrationPeriodIds.isEmpty()) {
            StringBuilder sb = new StringBuilder().append("SELECT ").append("*").append(" FROM ").append(this.tableName).append(" WHERE ").append("id").append(" IN ").append("(").append(Utils.toString(registrationPeriodIds)).append(")");
            try (PreparedStatement ps = this.con.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    RegistrationPeriod registrationPeriod = this.getFromRS(rs);
                    result.put(registrationPeriod.getId(), registrationPeriod);
                }
            }
        }
        return result;
    }
}

