/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ContractTariffDao
extends AbstractIdDao<ContractTariff> {
    public ContractTariffDao(Connection con) {
        super(con, "contract_tariff");
    }

    @Override
    protected ContractTariff getFromRS(ResultSet rs) throws SQLException {
        return ContractTariff.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setPeriod(new Period(TimeUtils.convertSqlDateToDate(rs.getDate("date1")), TimeUtils.convertSqlDateToDate(rs.getDate("date2")))).setTariffPlanId(rs.getInt("tpid")).setTariffGroupId(rs.getInt("tariff_group_id")).setComment(rs.getString("comment")).setPosition(rs.getInt("pos")).setEntityModuleId(rs.getInt("emid")).setEntityId(rs.getInt("eid")).setReplacedFromContractTariffId(rs.getInt("replaced_from")).build();
    }

    @Override
    protected void updateImpl(ContractTariff contractTariff) throws SQLException {
        block25: {
            String query;
            Objects.requireNonNull(contractTariff);
            boolean update = contractTariff.getId() > 0;
            int count = -1;
            if (contractTariff.getReplacedFromContractTariffId() > 0) {
                query = "SELECT count(*) FROM " + this.tableName + " WHERE replaced_from=?" + (update ? " AND id<>?" : "");
                try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                    psSelect.setInt(1, contractTariff.getReplacedFromContractTariffId());
                    if (update) {
                        psSelect.setInt(2, contractTariff.getId());
                    }
                    try (ResultSet rs = psSelect.executeQuery();){
                        while (rs.next()) {
                            count = rs.getInt(1);
                        }
                    }
                }
            }
            query = this.sqlCommandAndTable(update) + " SET cid=?, date1=?, date2=?, tpid=?, comment=?, pos=?, emid=?, eid=?, replaced_from=?, tariff_group_id=?" + this.sqlWhereId(update);
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                if (count < 1) {
                    int parameterIndex = 1;
                    ps.setInt(parameterIndex++, contractTariff.getContractId());
                    ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateFrom()));
                    ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateTo()));
                    ps.setInt(parameterIndex++, contractTariff.getTariffPlanId());
                    ps.setString(parameterIndex++, contractTariff.getComment());
                    ps.setInt(parameterIndex++, contractTariff.getPosition());
                    ps.setInt(parameterIndex++, contractTariff.getEntityMid());
                    ps.setInt(parameterIndex++, contractTariff.getEntityId());
                    ps.setInt(parameterIndex++, contractTariff.getReplacedFromContractTariffId());
                    ps.setInt(parameterIndex++, contractTariff.getTariffGroupId());
                    if (update) {
                        ps.setInt(parameterIndex++, contractTariff.getId());
                    }
                    ps.executeUpdate();
                    if (!update) {
                        contractTariff.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    }
                    break block25;
                }
                throw new SQLException("\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u0442\u0430\u0440\u0438\u0444\u0430");
            }
        }
    }

    public List<ContractTariff> list(int contractId, LocalDate date) throws SQLException {
        return this.list(contractId, date, 0, 0);
    }

    public List<ContractTariff> list(int contractId, LocalDate date, int emid, int eid) throws SQLException {
        ArrayList<ContractTariff> result = new ArrayList<ContractTariff>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND " + (String)(emid >= 0 ? "emid=" + emid + " AND eid=" + eid : "emid=0 AND eid=0") + " AND ( ? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )) ) ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Date sqlDate = TimeUtils.convertLocalDateToSqlDate(date);
            ps.setInt(1, contractId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public ContractTariff getFirst(int contractId, LocalDate date) throws SQLException {
        List<ContractTariff> list = this.list(contractId, date);
        return list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public int delete(int id) throws SQLException {
        String query = "DELETE FROM contract_tariff_vars WHERE contract_tariff_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        return super.delete(id);
    }

    public boolean checkDoubleTariffForContract(int contractId, int tpid, LocalDate date1, LocalDate date2) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND tpid=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR ?<=date2)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            boolean bl;
            block12: {
                int index = 1;
                ps.setInt(index++, contractId);
                ps.setInt(index++, tpid);
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date2));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date2));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date1));
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate(date1));
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public List<ContractTariffVar> getContractTariffVars(int contractTariffId) throws SQLException {
        ContractTariff contractTariff = (ContractTariff)this.get(contractTariffId);
        ArrayList<ContractTariffVar> list = new ArrayList<ContractTariffVar>();
        boolean addContractTariffVar = contractTariff != null;
        String query = "SELECT * FROM tariff_vars AS tv" + (addContractTariffVar ? " LEFT JOIN  contract_tariff_vars AS ctv ON ctv.tariff_var_id=tv.id AND ctv.contract_tariff_id=? WHERE tv.tariff_id IN ( ?, 0 )" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            if (addContractTariffVar) {
                psSelect.setInt(1, contractTariffId);
                psSelect.setInt(2, contractTariff.getTariffPlanId());
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int topId = rs.getInt("top_id");
                    String defaultValue = rs.getString("default_value");
                    String parentDefaultvalue = rs.getString("parent_default_value");
                    TariffVar tariffVar = TariffVar.builder().setId(rs.getInt("id")).setTariffPlanId(rs.getInt("tariff_id")).setType(TariffVarType.getTariffVarTypeByCode(rs.getString("type"))).setModuleId(rs.getInt("module_id")).setTitle(rs.getString("title")).setDefaultValue(topId > 0 && defaultValue.isEmpty() ? parentDefaultvalue : defaultValue).build();
                    ContractTariffVar contractTariffVar = ContractTariffVar.builder().setTariffVar(tariffVar).setContractTariffId(contractTariffId).build();
                    if (addContractTariffVar) {
                        contractTariffVar.setValue(rs.getString("value"));
                    }
                    list.add(contractTariffVar);
                }
            }
        }
        return list;
    }

    public ContractTariffVar getContractTariffVar(int contractTariffId, int tariffVarId) throws SQLException {
        ContractTariffVar contractTariffVar = null;
        ContractTariff contractTariff = (ContractTariff)this.get(contractTariffId);
        if (contractTariff != null) {
            String query = "SELECT * FROM tariff_vars AS tv LEFT JOIN  contract_tariff_vars AS ctv ON ctv.tariff_var_id=tv.id AND ctv.contract_tariff_id=? WHERE tv.id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, contractTariff.getTariffPlanId());
                ps.setInt(2, tariffVarId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        TariffVar tariffVar = TariffVar.builder().setId(rs.getInt("id")).setTariffPlanId(rs.getInt("tariff_id")).setType(TariffVarType.getTariffVarTypeByCode(rs.getString("type"))).setModuleId(rs.getInt("module_id")).setTitle(rs.getString("title")).setDefaultValue(rs.getString("default_value")).build();
                        contractTariffVar = ContractTariffVar.builder().setTariffVar(tariffVar).setContractTariffId(contractTariffId).setValue(rs.getString("value")).build();
                    }
                }
            }
        }
        return contractTariffVar;
    }

    public void updateContractTariffVar(ContractTariffVar contractTariffVar) throws SQLException {
        Objects.requireNonNull(contractTariffVar);
        String queryUpdate = "UPDATE contract_tariff_vars SET value=? WHERE tariff_var_id=? AND contract_tariff_id=?";
        String queryInsert = "INSERT INTO contract_tariff_vars SET tariff_var_id=?, contract_tariff_id=?, value=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);
             PreparedStatement psInsert = this.con.prepareStatement(queryInsert);){
            psUpdate.setString(1, contractTariffVar.getValue());
            psUpdate.setInt(2, contractTariffVar.getTariffVar().getId());
            psUpdate.setInt(3, contractTariffVar.getContractTariffId());
            if (psUpdate.executeUpdate() == 0) {
                psInsert.setInt(1, contractTariffVar.getTariffVar().getId());
                psInsert.setInt(2, contractTariffVar.getContractTariffId());
                psInsert.setString(3, contractTariffVar.getValue());
                psInsert.executeUpdate();
            }
        }
    }

    public void deleteContractTariffVar(ContractTariffVar contractTariffVar) throws SQLException {
        Objects.requireNonNull(contractTariffVar);
        String query = "DELETE FROM contract_tariff_vars WHERE tariff_var_id=? AND contract_tariff_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, contractTariffVar.getTariffVar().getId());
            psDelete.setInt(2, contractTariffVar.getContractTariffId());
            psDelete.executeUpdate();
        }
    }

    public void deleteContractTariffs(int contractId) throws SQLException {
        String query = "DELETE tv FROM contract_tariff_vars tv JOIN " + this.tableName + " ct ON ct.id=tv.contract_tariff_id WHERE ct.cid=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, contractId);
            psDelete.executeUpdate();
        }
        query = "DELETE FROM " + this.tableName + " WHERE cid=?";
        psDelete = this.con.prepareStatement(query);
        try {
            psDelete.setInt(1, contractId);
            psDelete.executeUpdate();
        }
        finally {
            if (psDelete != null) {
                psDelete.close();
            }
        }
    }
}

