/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.function.TryCall;

public class BGControlPanelDateNoB
extends JPanel {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private BGCalendarButton dateButton = new BGCalendarButton();
    private BGButton nowButton = new BGButton();
    private BGButton decButton = new BGButton();
    private BGButton incButton = new BGButton();
    private boolean buttonNow = false;
    private boolean buttonMove = false;
    private String oldValue = new String();

    public BGControlPanelDateNoB(Calendar date) {
        this();
        this.setDateCalendar(date);
    }

    public BGControlPanelDateNoB() {
        TryCall.call(() -> this.jbInit());
        this.dateButton.addPropertyChangeListener("updateCalendar", evt -> this.fireActionEvent());
        this.dateButton.addChangeListener(e -> this.firePropertyChange("showCalendar", !this.dateButton.isSelected(), this.dateButton.isSelected()));
        this.nowButton.addActionListener(e -> this.setLocalDate(LocalDate.now()));
        ActionListener actionListener = e -> {
            Calendar calendar = this.getDateCalendar();
            if (calendar != null) {
                calendar.add(5, Utils.parseInt(e.getActionCommand()));
                this.setDateCalendar(calendar);
            }
        };
        this.decButton.setActionCommand("-1");
        this.decButton.addActionListener(actionListener);
        this.incButton.setActionCommand("1");
        this.incButton.addActionListener(actionListener);
    }

    private void jbInit() throws Exception {
        this.decButton.setVisible(this.buttonMove);
        this.incButton.setVisible(this.buttonMove);
        this.nowButton.setVisible(this.buttonNow);
        this.nowButton.setText("\u0421\u0435\u0433\u043e\u0434\u043d\u044f");
        this.decButton.setIcon(ClientUtils.getIcon("to_prev.gif"));
        this.incButton.setIcon(ClientUtils.getIcon("to_next.gif"));
        this.decButton.setFocusable(false);
        this.incButton.setFocusable(false);
        this.nowButton.setFocusable(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.decButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this.dateButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.incButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.nowButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 0, 0), 0, 0));
    }

    public Calendar getDateCalendar() {
        return this.dateButton.getCalendar();
    }

    public Date getDate() {
        return TimeUtils.convertCalendarToDate(this.getDateCalendar());
    }

    public LocalDate getLocalDate() {
        return TimeUtils.convertDateToLocalDate(this.getDate());
    }

    public void setLocalDate(LocalDate localDate) {
        this.dateButton.setLocalDate(localDate);
        this.firePropertyChange("date", this.oldValue, this.dateButton.getText());
        this.oldValue = this.dateButton.getText();
    }

    @Deprecated
    public void setDateCalendar(Calendar dateCalendar) {
        this.setLocalDate(dateCalendar == null ? null : TimeUtils.convertDateToLocalDate(dateCalendar.getTime()));
    }

    public void setDateString(String dateString) {
        if (dateString == null || "00.00.0000".equals(dateString)) {
            dateString = "";
        }
        this.dateButton.setText(dateString);
        this.firePropertyChange("date", this.oldValue, this.dateButton.getText());
        this.oldValue = this.dateButton.getText();
    }

    public String getDateString() {
        return this.dateButton.getText().trim();
    }

    private void fireActionEvent() {
        this.firePropertyChange("date", this.oldValue, this.dateButton.getText());
        this.oldValue = this.dateButton.getText();
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "date_changed"));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public boolean isButtonNow() {
        return this.buttonNow;
    }

    public void setButtonNow(boolean buttonNow) {
        this.buttonNow = buttonNow;
        this.nowButton.setVisible(buttonNow);
    }

    public boolean isButtonMove() {
        return this.buttonMove;
    }

    public void setButtonMove(boolean buttonMove) {
        this.buttonMove = buttonMove;
        this.decButton.setVisible(buttonMove);
        this.incButton.setVisible(buttonMove);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dateButton.setEnabled(enabled);
        this.incButton.setEnabled(enabled);
        this.decButton.setEnabled(enabled);
        this.nowButton.setEnabled(enabled);
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.dateButton.addFocusListener(focusListener);
    }

    @Override
    public void setName(String name) {
        this.dateButton.setName(name);
    }

    @Override
    public String getName() {
        return this.dateButton.getName();
    }
}

