/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionGetPackageContractList
extends ActionBase {
    public void doAction() throws Exception {
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        SearchResult searchResult = new SearchResult(this.getPage());
        packageManager.findPackageContractList((SearchResult<PackageContract>)searchResult, this.cid);
        for (PackageContract pkg : searchResult.getList()) {
            User user;
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(pkg.getId()));
            row.setAttribute("title", pkg.getTitle());
            row.setAttribute("period", TimeUtils.formatPeriod((Date)pkg.getDateFrom(), (Date)pkg.getDateTo()));
            row.setAttribute("summa", pkg.getSumma().toPlainString());
            row.setAttribute("count", String.valueOf(pkg.getCount()) + " [" + String.valueOf(pkg.getCountUse()) + "]");
            String userString = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c";
            if (pkg.getUserId() > -1 && (user = UserMap.getUser((Integer)pkg.getUserId())) != null) {
                userString = user.getName();
            }
            row.setAttribute("user", userString);
        }
        this.setPageAttribute(table, searchResult.getPage());
    }
}

