/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrTextDao
extends EntityAttrDefaultDao<EntityAttrText> {
    public EntityAttrTextDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table) {
        super(con, entityAttrDao, table);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` varchar(255) NOT NULL DEFAULT '', PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    @Override
    public EntityAttrText get(int entityId, int attrSpecId) throws BGException {
        EntityAttrText result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrText(entityId, attrSpecId, rs.getString(1));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setString(3, ((EntityAttrText)a).getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrText attr) throws SQLException {
        String value = attr.getValue();
        if (Utils.isBlankString((String)value)) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        String oldValue = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attr.getEntitySpecAttrId());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                oldValue = rs.getString(1);
                update = true;
            }
        }
        if (update) {
            ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setString(1, value);
                ps.executeUpdate();
                boolean bl = !value.equals(oldValue);
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
        try {
            ps.setString(3, value);
            ps.executeUpdate();
            boolean bl = true;
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

