/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.base;

import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.common.Utils;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected void createTypesElement() {
        Element types = this.createElement(this.rootNode, "types");
        this.addListItem(types, "0", "---------");
        String dealerType = this.moduleSetup.get("dealer.type", null);
        if (dealerType != null) {
            StringTokenizer st = new StringTokenizer(dealerType, "|");
            while (st.hasMoreTokens()) {
                String type = st.nextToken();
                int index = type.indexOf(":");
                if (index <= -1 || index >= type.length() - 1) continue;
                String typeId = type.substring(0, index);
                String typeTitle = type.substring(index + 1);
                this.addListItem(types, typeId, typeTitle);
            }
        }
    }

    protected String activateCard(String login, String pswd, int cid, int userID) throws Exception {
        ContractManager contractManager;
        boolean is_pasw_valid;
        if (Utils.isEmptyString((String)pswd)) {
            this.setWebErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c!");
            return "input_password";
        }
        CardManager cardManager = new CardManager(this.con, this.mid);
        Card card = cardManager.findCard(login);
        if (card == null) {
            this.setWebErrorMessage("\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043b\u043e\u0433\u0438\u043d\u043e\u043c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            return "not_found";
        }
        String pin_code = card.getCardPinCode();
        Date date1 = card.getDateBegin();
        Date date2 = card.getDateEnd();
        int status = card.getStatus();
        boolean bl = is_pasw_valid = Utils.getDigest((String)pswd, (String)"cp1251").equals(pin_code) || pswd.equals(pin_code);
        if (!is_pasw_valid) {
            this.setWebErrorMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043f\u0430\u0440\u043e\u043b\u044c!");
            return "pswd_error";
        }
        Date now = new Date();
        if (date1.after(now) || date2.before(now)) {
            this.setWebErrorMessage("\u0418\u0441\u0442\u0435\u043a \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u043b \u043f\u0435\u0440\u0438\u043e\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b!");
            return "expired";
        }
        if (status != 1) {
            switch (status) {
                case 0: {
                    this.setWebErrorMessage("\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                    return "locked";
                }
                case 2: {
                    this.setWebErrorMessage("\u041a\u0430\u0440\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0434\u043b\u044f \u043b\u043e\u0433\u0438\u043d\u0430!");
                    return "used";
                }
                case 3: {
                    this.setWebErrorMessage("\u041a\u0430\u0440\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0434\u043b\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430!");
                    return "used";
                }
            }
        }
        if (!(contractManager = new ContractManager(this.con)).checkContractService(cid, card.getServicePayId(), new Date())) {
            this.setWebErrorMessage("\u0414\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d \u044d\u0442\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0439!");
            return "not_this_contract";
        }
        card.setContractId(cid);
        if (cardManager.activated(card, 3)) {
            Payment payment = Payment.builder().setContractId(cid).setTypeId(card.getPaymentType()).setUserId(userID).setSum(new BigDecimal(card.getSumma())).setComment("N " + card.getId()).setDate(new Date()).build();
            new PaymentDao(this.con).update((Object)payment);
            Contract contract = ContractDao.getContract((Connection)this.con, (int)cid);
            this.con.commit();
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                bu.updateBalance(payment.getDate(), contract);
            }
            this.context.publishAfterCommit((Event)new PaymentEvent(userID, payment));
            this.context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
        }
        return "ok";
    }

    protected Element getTableHeader(int table_id) throws SQLException {
        Element header = this.getTableHeader(table_id, this.userId);
        if (!header.hasChildNodes()) {
            header = this.getTableHeader(table_id, 0);
        }
        return header;
    }

    private Element getTableHeader(int table_id, int user_id) throws SQLException {
        Element header = this.createElement(null, "header");
        String query = "SELECT title, w1, w2, w3, class, editable FROM table_pref WHERE  table_id=? and user_id=? ORDER BY user_id desc, column_id";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, table_id);
        ps.setInt(2, user_id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element column = this.createElement(header, "column");
            column.setAttribute("title", rs.getString(1));
            column.setAttribute("w1", rs.getString(2));
            column.setAttribute("w2", rs.getString(3));
            column.setAttribute("w3", rs.getString(4));
            column.setAttribute("class", rs.getString(5));
            column.setAttribute("editable", rs.getString(6));
        }
        rs.close();
        ps.close();
        return header;
    }
}

