/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.plugin.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;

public abstract class BGPluginManagerBase {
    protected static BGPluginManagerBase ourInstance = null;
    protected Map<Class<?>, Collection<?>> cacheInvokeablePoints = new HashMap();
    protected Map<String, List<BGPlugInElement>> cacheExtensionPoints = new HashMap<String, List<BGPlugInElement>>();

    public static BGPluginManagerBase getManager() {
        return ourInstance;
    }

    protected static final List<URL> getPlugins() throws BGException {
        LinkedList<URL> result = new LinkedList<URL>();
        try {
            String[] pluginNames;
            String packagePrefix = "/ru/bitel/bgbilling/plugins/";
            for (String pluginName : pluginNames = new String[]{"assistant", "bonus", "botmanager", "cashcheck", "cladr", "crm", "dispatch", "documents", "edo", "fias", "fio", "helpdesk", "im", "message4user", "monitoring", "news", "organizer", "packer", "notification", "sbpilot", "shop", "sqleditor", "gar"}) {
                URL url = BGPluginManagerBase.class.getResource(packagePrefix + pluginName + "/plugin.xml");
                if (url == null) continue;
                result.add(url);
            }
        }
        catch (Exception e) {
            throw new BGException("error find and load plugins", e);
        }
        return result;
    }

    public List<BGPlugInElement> getExtensions(String point, boolean cacheable) {
        List<BGPlugInElement> list = null;
        if (cacheable) {
            list = this.cacheExtensionPoints.get(point);
        }
        if (list == null) {
            list = new ArrayList<BGPlugInElement>();
            for (BGPluginBase bGPluginBase : this.getPluginsMap().values()) {
                BGPlugInElement extension = bGPluginBase.getExtensionMap().get(point);
                if (extension == null) continue;
                list.add(extension);
            }
            if (cacheable) {
                this.cacheExtensionPoints.put(point, list);
            }
        }
        return list;
    }

    public BGPlugInElement getExtension(String pluginId, String point) {
        BGPlugInElement bgPlugInElement = null;
        BGPluginBase plugin = this.getPluginsMap().get(pluginId);
        if (plugin != null) {
            bgPlugInElement = plugin.getExtensionMap().get(point);
        }
        return bgPlugInElement;
    }

    public abstract Map<String, ? extends BGPluginBase> getPluginsMap();

    public abstract BGPluginBase getPlugin(String var1);

    public abstract <T> Collection<? extends BGPluginBase> getPluginsForInvokeablePoints(Class<T> var1);

    public <T> Collection<T> getInvokeables(Class<T> point, boolean cacheable) {
        Collection<?> ip = null;
        if (cacheable) {
            ip = this.cacheInvokeablePoints.get(point);
        }
        if (ip == null) {
            ip = new ArrayList();
            for (BGPluginBase plugin : this.getPluginsForInvokeablePoints(point)) {
                if (!plugin.getEventPointSet().contains(point)) continue;
                try {
                    ip.add(point.cast(plugin.getEventObject()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (cacheable) {
                this.cacheInvokeablePoints.put(point, ip);
            }
        }
        return ip;
    }
}

