/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.client;

import bitel.billing.module.common.BGListToggleButton;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.contract.BalanceTransferPanel;
import jakarta.activation.DataHandler;
import jakarta.xml.ws.Holder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.apache.commons.io.IOUtils;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelDateWithTime;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoDay;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.client.AbstractBalanceTableModel;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDetailItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccount;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccountDetail;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel_Parameters;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.base.client.dialog.PaymentAndChargeEditor;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractSubPanel_Balance
extends ContractSubPanel {
    private static final String MODE_SWITCH_MONTH = "month";
    private static final String MODE_SWITCH_PERIOD = "period";
    private static final String KEY_MODE_SWITCH = "ru.bitel.common.client.month.mode.switch";
    private static final String KEY_MODE_PERIOD = "ru.bitel.common.client.month.mode.period";
    private static final String BUTTON_PAYMENT = "0";
    private static final String BUTTON_CHARGE = "1";
    private static final String BUTTON_ACCOUNT = "2";
    private static final String BUTTON_BALANCE = "3";
    private static final String BUTTON_BALANCE_DETAIL = "4";
    private static final String BUTTON_RESERVE = "5";
    private static final String BUTTON_AVAILABLE_SUM = "6";
    private static final String BUTTON_PAYBACK = "7";
    private boolean load = true;
    private String button = "3";
    private ContractPanel_Parameters paramsPanel;
    private ChargeService chargeService = null;
    private ReserveService reserveService = null;
    private PaymentService paymentService = null;
    private BalanceService balanceService = null;
    private AccountTableModel modelAccount = new AccountTableModel("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430", false);
    private BGUTable tableAccount = new BGUTable(this.modelAccount);
    private PaymentTableModel modelPayment = new PaymentTableModel("\u041f\u0440\u0438\u0445\u043e\u0434\u044b", false);
    private BGUTable tablePayment = new BGUTable(this.modelPayment);
    private ChargeTableModel modelCharge = new ChargeTableModel("\u0420\u0430\u0441\u0445\u043e\u0434\u044b", false);
    private BGUTable tableCharge = new BGUTable(this.modelCharge);
    private ReserveTableModel modelReserve = new ReserveTableModel("\u0420\u0435\u0437\u0435\u0440\u0432\u044b", false);
    private BGUTable tableReserve = new BGUTable(this.modelReserve);
    private BalanceTableModel modelBalance = new BalanceTableModel("\u0411\u0430\u043b\u0430\u043d\u0441");
    private BGUTable tableBalance = new BGUTable(this.modelBalance);
    private BalanceDetailTableModel modelBalanceDetail = new BalanceDetailTableModel("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441");
    private BGUTable tableBalanceDetail = new BGUTable(this.modelBalanceDetail);
    private BGTableModel<ContractAccount> modelSubAccount = new AccountTableModel("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", true);
    private BGUTable tableSubAccount = new BGUTable(this.modelSubAccount);
    private PaymentTableModel modelSubPayment = new PaymentTableModel("\u041f\u0440\u0438\u0445\u043e\u0434\u044b \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", true);
    private BGUTable tableSubPayment = new BGUTable(this.modelSubPayment);
    private ChargeTableModel modelSubCharge = new ChargeTableModel("\u0420\u0430\u0441\u0445\u043e\u0434\u044b \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", true);
    private BGUTable tableSubCharge = new BGUTable(this.modelSubCharge);
    private ReserveTableModel modelSubReserve = new ReserveTableModel("\u0420\u0435\u0437\u0435\u0440\u0432\u044b \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", true);
    private BGUTable tableSubReserve = new BGUTable(this.modelSubReserve);
    private BGControlPanelPeriodNoDay periodPanel = new BGControlPanelPeriodNoDay();
    private BGButtonPanel panelPrintSaveMail = new BGButtonPanel(BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M);
    private JToggleButton monthModeSwitch_m = new JToggleButton();
    private JToggleButton monthModeSwitch_p = new JToggleButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private JToggleButton accountButton = new BalanceToggleButton("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430", "2");
    private BGListToggleButton chargeButton = new BGListToggleButton();
    private JToggleButton paymentButton = new BalanceToggleButton("\u041f\u0440\u0438\u0445\u043e\u0434", "0");
    private BGListToggleButton balanceButton = new BGListToggleButton();
    private CardLayout tableCardLayout = new CardLayout();
    private CardLayout tableSubCardLayout = new CardLayout();
    private BGUTable currentTable;
    private JTable currentSubTable;
    private JPanel tableScroll = new JPanel(this.tableCardLayout);
    private JPanel tableSubScroll = new JPanel(this.tableSubCardLayout);
    private JTextField summaTF = new JTextField();
    private JPanel summaPanel = new JPanel();
    private JPanel mpButtonsPanel = new JPanel();
    private JPanel monthsPanel = new JPanel(new GridBagLayout());
    private CardLayout cardLayout = new CardLayout();
    private JPopupMenu popupMenu = new JPopupMenu();
    private Directory<ReserveType> reserveTypeDirectory;
    private Directory<PaymentType> paymentTypeDirectory;
    private Directory<ChargeType> chargeTypeDirectory;
    private Directory<Service> serviceDirectory;
    private Directory<UserInfo> userDirectory;

    public ContractSubPanel_Balance() {
        this.jbInit();
        ActionListener buttonActionListener = event -> {
            this.a();
            this.paramsPanel.balanceModeChanged(event.getActionCommand());
            this.setMode(event.getActionCommand());
        };
        this.chargeButton.addItem("\u0420\u0430\u0441\u0445\u043e\u0434 ", BUTTON_CHARGE);
        this.chargeButton.addItem("\u0412\u043e\u0437\u0432\u0440\u0430\u0442", BUTTON_PAYBACK);
        this.chargeButton.addItem("\u0420\u0435\u0437\u0435\u0440\u0432 ", BUTTON_RESERVE);
        this.chargeButton.setButtonGroup(this.buttonGroup2);
        this.balanceButton.addItem("   \u0411\u0430\u043b\u0430\u043d\u0441    ", BUTTON_BALANCE);
        this.balanceButton.addItem("\u0411\u0430\u043b\u0430\u043d\u0441 \u0434\u0435\u0442.", BUTTON_BALANCE_DETAIL);
        this.balanceButton.setButtonGroup(this.buttonGroup2);
        this.paymentButton.addActionListener(buttonActionListener);
        this.chargeButton.addActionListener(buttonActionListener);
        this.accountButton.addActionListener(buttonActionListener);
        this.balanceButton.addActionListener(buttonActionListener);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.balanceButton.setSelected(BUTTON_BALANCE);
        this.periodPanel.setBorder(new BGTitleBorder(" \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 "));
        this.periodPanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("date1") || evt.getPropertyName().equals("date2")) {
                this.refreshData();
            }
        });
        this.summaTF.setEditable(false);
        this.summaTF.setText("0.00");
        this.summaTF.setColumns(10);
        this.summaTF.setHorizontalAlignment(0);
        this.monthModeSwitch_m.setActionCommand("M");
        this.monthModeSwitch_m.setText("\u041c");
        this.monthModeSwitch_p.setActionCommand("D");
        this.monthModeSwitch_p.setText("\u041f");
        this.monthsPanel.setBorder(new BGTitleBorder(" \u0412\u044b\u0431\u043e\u0440 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 "));
        this.monthsPanel.add((Component)this.monthModeSwitch_p, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.monthsPanel.add(Box.createHorizontalStrut(8), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.monthsPanel.add((Component)this.monthModeSwitch_m, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.monthsPanel.add((Component)this.mpButtonsPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.mpButtonsPanel.setLayout(this.cardLayout);
        this.mpButtonsPanel.add((Component)this.getMonthButtonsPanel(), MODE_SWITCH_MONTH);
        this.mpButtonsPanel.add((Component)this.getPeriodButtonsPanel(), MODE_SWITCH_PERIOD);
        String monthModeSwitch = this.setup.getUserConfig().get(KEY_MODE_SWITCH, MODE_SWITCH_PERIOD);
        if (monthModeSwitch.equals(MODE_SWITCH_PERIOD)) {
            this.monthModeSwitch_p.setSelected(true);
            this.cardLayout.show(this.mpButtonsPanel, MODE_SWITCH_PERIOD);
            this.calcPeriod(this.setup.getUserConfig().get(KEY_MODE_PERIOD, "cM"));
        } else {
            this.monthModeSwitch_m.setSelected(true);
            this.cardLayout.show(this.mpButtonsPanel, MODE_SWITCH_MONTH);
        }
        JPanel jPanel14 = new JPanel(new GridBagLayout());
        jPanel14.add((Component)this.panelPrintSaveMail, new GridBagConstraints(0, 0, 1, 1, 0.25, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        jPanel14.add((Component)this.paymentButton, new GridBagConstraints(1, 0, 1, 1, 0.25, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        jPanel14.add((Component)this.chargeButton, new GridBagConstraints(2, 0, 1, 1, 0.25, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        jPanel14.add((Component)this.accountButton, new GridBagConstraints(3, 0, 1, 1, 0.25, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        jPanel14.add((Component)this.balanceButton, new GridBagConstraints(4, 0, 1, 1, 0.25, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.summaPanel.setLayout(new GridBagLayout());
        this.summaPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.summaPanel.add((Component)this.summaTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.monthsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        JButton startTransferButton = new JButton("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
        startTransferButton.addActionListener(e -> this.startTransfer());
        JPanel transferPanel = new JPanel(new GridBagLayout());
        transferPanel.add((Component)startTransferButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        transferPanel.add((Component)this.summaPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        JPanel jPanel12 = new JPanel(new GridBagLayout());
        jPanel12.add((Component)jPanel4, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel12.add((Component)jPanel14, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        jPanel12.add((Component)this.tableScroll, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.4, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel12.add((Component)this.tableSubScroll, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.4, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel12.add((Component)transferPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel12, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonGroup1.add(this.monthModeSwitch_m);
        this.buttonGroup1.add(this.monthModeSwitch_p);
        this.monthModeSwitch_m.addActionListener(e -> {
            this.monthModeSwitch_m.setSelected(true);
            ((BGTitleBorder)this.monthsPanel.getBorder()).setTitle(" \u0412\u044b\u0431\u043e\u0440 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 (\u043c\u0435\u0441\u044f\u0446\u044b) ");
            this.cardLayout.show(this.mpButtonsPanel, MODE_SWITCH_MONTH);
            this.setup.getUserConfig().set(KEY_MODE_SWITCH, MODE_SWITCH_MONTH);
            this.setup.saveUserConfig();
            this.calcMonth(String.valueOf(new GregorianCalendar().get(2) + 1));
            this.refreshData();
        });
        this.monthModeSwitch_p.addActionListener(e -> {
            this.monthModeSwitch_p.setSelected(true);
            ((BGTitleBorder)this.monthsPanel.getBorder()).setTitle(" \u0412\u044b\u0431\u043e\u0440 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 ");
            this.cardLayout.show(this.mpButtonsPanel, MODE_SWITCH_PERIOD);
            this.setup.getUserConfig().set(KEY_MODE_SWITCH, MODE_SWITCH_PERIOD);
            this.setup.saveUserConfig();
            this.calcPeriod(this.setup.getUserConfig().get(KEY_MODE_PERIOD, "cM"));
            this.refreshData();
        });
        this.panelPrintSaveMail.addActionListener(e -> this.panelPrintSaveMailActionPerformed(e));
        this.tableCharge.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && ContractSubPanel_Balance.this.popupMenu.getComponentCount() > 0) {
                    int column = ContractSubPanel_Balance.this.tableCharge.columnAtPoint(e.getPoint());
                    int row = ContractSubPanel_Balance.this.tableCharge.rowAtPoint(e.getPoint());
                    if (column != -1 && row != -1) {
                        ContractSubPanel_Balance.this.tableCharge.setColumnSelectionInterval(column, column);
                        ContractSubPanel_Balance.this.tableCharge.setRowSelectionInterval(row, row);
                        for (Component comp : ContractSubPanel_Balance.this.popupMenu.getComponents()) {
                            Charge charge = (Charge)ContractSubPanel_Balance.this.modelCharge.getSelectedRow();
                            if (charge == null || charge.getId() <= -1) continue;
                            try {
                                Method method = comp.getClass().getDeclaredMethod("setTextToItem", Integer.TYPE, ClientContext.class, BigDecimal.class);
                                method.invoke((Object)comp, charge.getId(), ContractSubPanel_Balance.this.getContext(), charge.getSum());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ContractSubPanel_Balance.this.popupMenu.show(ContractSubPanel_Balance.this.tableCharge, e.getX(), e.getY());
                    }
                } else if (e.getClickCount() == 2) {
                    ContractSubPanel_Balance.this.editItem();
                }
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ContractSubPanel_Balance.this.editItem();
                }
            }
        };
        JMenuItem paymentParams = new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        paymentParams.addActionListener(e -> {
            Payment payment = (Payment)this.modelPayment.getSelectedRow();
            if (payment != null) {
                Color bgColor = new JTextField().getBackground();
                JTextField module = new JTextField();
                module.setHorizontalAlignment(0);
                module.setEditable(false);
                module.setBackground(bgColor);
                module.setText(String.valueOf(payment.getModuleId()));
                JTextField transaction = new JTextField();
                transaction.setHorizontalAlignment(0);
                transaction.setEditable(false);
                transaction.setBackground(bgColor);
                transaction.setText(Optional.ofNullable(payment.getTransactionId()).orElse(""));
                JTextArea textArea = new JTextArea(payment.getData(), 20, 50);
                textArea.setMargin(new Insets(5, 5, 5, 5));
                textArea.setEditable(false);
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel("ID \u043c\u043e\u0434\u0443\u043b\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 0), 0, 0));
                panel.add((Component)module, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                panel.add((Component)new JLabel("ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 0), 0, 0));
                panel.add((Component)transaction, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 0), 0, 0));
                panel.add((Component)new JScrollPane(textArea), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                Object okButtonText = UIManager.get("OptionPane.okButtonText");
                UIManager.put("OptionPane.okButtonText", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), panel, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1);
                UIManager.put("OptionPane.okButtonText", okButtonText);
            }
        });
        this.tablePayment.addMouseListener(mouseListener);
        this.tablePayment.addPopupMenuIfNotExists(paymentParams);
        this.tableReserve.addMouseListener(mouseListener);
        MouseAdapter accountMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ContractAccount contractAccount;
                if (mouseEvent.getClickCount() == 2 && (contractAccount = (ContractAccount)ContractSubPanel_Balance.this.modelAccount.getSelectedRow()) != null) {
                    ContractSubPanel_Balance.this.showAccountDetail(contractAccount);
                }
            }
        };
        this.tableAccount.addMouseListener(accountMouseListener);
        this.tableScroll.add((Component)new JScrollPane(this.tableCharge), BUTTON_CHARGE);
        this.tableScroll.add((Component)new JScrollPane(this.tablePayment), BUTTON_PAYMENT);
        this.tableScroll.add((Component)new JScrollPane(this.tableAccount), BUTTON_ACCOUNT);
        this.tableScroll.add((Component)new JScrollPane(this.tableReserve), BUTTON_RESERVE);
        this.tableScroll.add((Component)new JScrollPane(this.tableBalance), BUTTON_BALANCE);
        this.tableScroll.add((Component)new JScrollPane(this.tableBalanceDetail), BUTTON_BALANCE_DETAIL);
        this.tableSubScroll.add((Component)new JScrollPane(this.tableSubCharge), BUTTON_CHARGE);
        this.tableSubScroll.add((Component)new JScrollPane(this.tableSubPayment), BUTTON_PAYMENT);
        this.tableSubScroll.add((Component)new JScrollPane(this.tableSubAccount), BUTTON_ACCOUNT);
        this.tableSubScroll.add((Component)new JScrollPane(this.tableSubReserve), BUTTON_RESERVE);
    }

    private JPanel getMonthButtonsPanel() {
        ActionListener al = event -> {
            this.calcMonth(event.getActionCommand());
            this.refreshData();
        };
        JPanel monthButtonsPanel = new JPanel(new GridBagLayout());
        int mm = new GregorianCalendar().get(2) + 2;
        for (int i = 1; i < 13; ++i) {
            if (mm > 12) {
                mm = 1;
                monthButtonsPanel.add(Box.createHorizontalStrut(8), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JButton monthButton = new JButton(mm < 10 ? BUTTON_PAYMENT + mm : "" + mm);
            monthButton.setMargin(new Insets(2, 2, 2, 2));
            monthButton.setActionCommand(String.valueOf(mm));
            monthButton.addActionListener(al);
            if (i == 12) {
                monthButton.setBackground(Color.gray);
            }
            monthButtonsPanel.add((Component)monthButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            ++mm;
        }
        return monthButtonsPanel;
    }

    private JPanel getPeriodButtonsPanel() {
        ActionListener actionListener = event -> {
            this.calcPeriod(event.getActionCommand());
            this.refreshData();
        };
        JPanel panel = new JPanel(new GridBagLayout());
        this.addPeriodButton(panel, "c", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", actionListener);
        this.addPeriodButton(panel, "cM", "\u041c\u0435\u0441\u044f\u0446", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446", actionListener);
        this.addPeriodButton(panel, "cQ", "\u041a\u0432\u0430\u0440\u0442\u0430\u043b", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0432\u0430\u0440\u0442\u0430\u043b", actionListener);
        this.addPeriodButton(panel, "cY", "\u0413\u043e\u0434", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0433\u043e\u0434", actionListener);
        this.addPeriodButton(panel, "q", "3 \u041c\u0435\u0441.", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 3 \u043c\u0435\u0441\u044f\u0446\u0430", actionListener);
        this.addPeriodButton(panel, "hY", "6 \u041c\u0435\u0441.", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 6 \u043c\u0435\u0441\u044f\u0446\u0435\u0432", actionListener);
        this.addPeriodButton(panel, "y", "12 \u041c\u0435\u0441.", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 12 \u043c\u0435\u0441\u044f\u0446\u0435\u0432", actionListener);
        return panel;
    }

    private void addPeriodButton(JPanel panel, String actionCommand, String text, String toolTipText, ActionListener actionListener) {
        BalancPeriodButton button = new BalancPeriodButton(actionCommand, text, toolTipText, actionListener);
        panel.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void calcPeriod(String actionCommand) {
        GregorianCalendar nowDate = new GregorianCalendar();
        Calendar date = (Calendar)((Calendar)nowDate).clone();
        date.set(5, 1);
        if (actionCommand != null) {
            switch (actionCommand) {
                case "c": {
                    if (this.paramsPanel == null) break;
                    Period period = this.paramsPanel.getContractPeriod();
                    if (period.getDateFrom() != null) {
                        date.setTime(period.getDateFrom());
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.add(1, -10);
                        date.setTime(cal.getTime());
                    }
                    if (period.getDateTo() == null) break;
                    nowDate.setTime(period.getDateTo());
                    break;
                }
                case "cM": {
                    break;
                }
                case "cQ": {
                    int m = date.get(2);
                    if (m <= 2) {
                        date.set(2, 0);
                        break;
                    }
                    if (m > 2 && m <= 5) {
                        date.set(2, 3);
                        break;
                    }
                    if (m > 5 && m <= 8) {
                        date.set(2, 6);
                        break;
                    }
                    if (m <= 8 || m > 11) break;
                    date.set(2, 9);
                    break;
                }
                case "cY": {
                    date.set(2, 0);
                    break;
                }
                case "q": {
                    date.set(2, date.get(2) - 3);
                    break;
                }
                case "hY": {
                    date.set(2, date.get(2) - 6);
                    break;
                }
                case "y": {
                    date.set(2, date.get(2) - 12);
                    break;
                }
                default: {
                    actionCommand = null;
                }
            }
            if (actionCommand != null) {
                this.setup.getUserConfig().set(KEY_MODE_PERIOD, actionCommand);
                this.setup.saveUserConfig();
            }
        }
        if (date.after(nowDate)) {
            date.add(1, -1);
        }
        this.setPeriod(date, nowDate);
    }

    private void panelPrintSaveMailActionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        Period period = new Period(TimeUtils.convertDateToLocalDate(this.periodPanel.getDateFrom()), TimeUtils.convertDateToLocalDate(this.periodPanel.getDateTo()).plusMonths(1L).minusDays(1L));
        int typeButton = Integer.valueOf(this.button);
        if ("print".equals(actionCommand)) {
            Holder data = new Holder();
            try {
                this.getBalanceService().getDataSource("html", typeButton, this.getContractId(), period, (Holder<DataHandler>)data);
                InputStream is = ((DataHandler)data.value).getInputStream();
                String res = IOUtils.toString((InputStream)is, (String)"UTF-8");
                new HtmlPrinter(res, 800, 300);
                is.close();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else if ("email".equals(actionCommand)) {
            String email = this.getUserEmail(this.module);
            email = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 EMail", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3, UIManager.getIcon("OptionPane.questionIcon"), null, email);
            if (email != null) {
                try {
                    this.saveUserEmail(this.module, email.trim());
                    String result = this.getBalanceService().sendEmail(email, "html", typeButton, this.getContractId(), period);
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), result, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        } else if ("save".equals(actionCommand)) {
            BGFileChooser fc = new BGFileChooser(this);
            fc.setAcceptAllFileFilterUsed(false);
            BGFileFilter ffhtm = new BGFileFilter("html|htm", "HTML File");
            BGFileFilter ffcsvU = new BGFileFilter("csv", "CSV File (utf-8)");
            fc.addChoosableFileFilter(ffcsvU);
            fc.addChoosableFileFilter(ffhtm);
            if (fc.showSaveDialog(JOptionPane.getRootFrame()) == 0) {
                try {
                    FileFilter ff = fc.getFileFilter();
                    Holder data = new Holder();
                    String type = "html";
                    if (ff == ffcsvU) {
                        type = "csv";
                    }
                    this.getBalanceService().getDataSource(type, typeButton, this.getContractId(), period, (Holder<DataHandler>)data);
                    String fileName = fc.getSelectedFile().getAbsolutePath() + "." + type;
                    Files.copy(((DataHandler)data.value).getInputStream(), Paths.get(fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                ClientUtils.showMessageDialog("\u041e\u0442\u0447\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
            }
        }
    }

    public void setPeriod(Calendar date1, Calendar date2) {
        this.periodPanel.setDateCalendar1((Calendar)date1.clone());
        this.periodPanel.setDateCalendar2((Calendar)date2.clone());
    }

    private void startTransfer() {
        BalanceTransferPanel transfer = new BalanceTransferPanel(-1, this.getContractId());
        transfer.setTitle("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
        transfer.setData();
        if (transfer.isDoTransfer()) {
            transfer.setVisible(true);
        }
        this.refreshData();
    }

    private void showAccountDetail(ContractAccount contractAccount) {
        JPanel panel = new JPanel(new GridBagLayout());
        try {
            Service service = this.serviceDirectory.get(contractAccount.getServiceId());
            String seriveTitle = service == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : service.getTitle();
            JTextField serviceTitleField = new JTextField(seriveTitle);
            serviceTitleField.setEditable(false);
            serviceTitleField.setHorizontalAlignment(0);
            serviceTitleField.setBackground(UIManager.getColor("TextField.background"));
            AccountDetailTableModel accountDetailTableModel = new AccountDetailTableModel(AccountDetailTableModel.class.getName());
            panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)serviceTitleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(new BGUTable((TableModel)accountDetailTableModel, this.getContext()), 1200, 500), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            LocalDate localDate = TimeUtils.convertDateToLocalDate(contractAccount.getDate());
            localDate = localDate.withDayOfMonth(1);
            Period period = new Period();
            period.setLocalDateFrom(localDate);
            localDate = localDate.withDayOfMonth(localDate.lengthOfMonth());
            period.setLocalDateTo(localDate);
            SearchResult<ContractAccountDetail> searchResult = this.getBalanceService().contractAccountDetailList(this.getContractId(), contractAccount.getServiceId(), period);
            accountDetailTableModel.setData(searchResult.getList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        UIManager.put("OptionPane.okButtonText", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), panel, "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435", -1);
        UIManager.put("OptionPane.okButtonText", null);
    }

    @Override
    public void newItem() {
        if (this.button == null || "0157".indexOf(this.button) < 0) {
            return;
        }
        if (BUTTON_RESERVE.equals(this.button)) {
            new ReserveEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0437\u0435\u0440\u0432", null).open();
        } else {
            PaymentAndChargeEditor editor = null;
            switch (this.button) {
                case "0": {
                    editor = new PaymentAndChargeEditor(-1, this.getContractId(), "bitel.billing.module.contract.PaymentEditor");
                    editor.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432");
                    editor.setMode(0);
                    break;
                }
                case "1": {
                    editor = new PaymentAndChargeEditor(-1, this.getContractId(), "bitel.billing.module.contract.ChargeEditor");
                    editor.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432");
                    editor.setMode(1);
                    break;
                }
                case "7": {
                    editor = new PaymentAndChargeEditor(-1, this.getContractId(), "bitel.billing.module.contract.PaybackEditor");
                    editor.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432");
                    editor.setMode(2);
                }
            }
            editor.setData();
            editor.setVisible(true);
        }
        this.refreshData();
    }

    @Override
    public void editItem() {
        try {
            if (this.button == null || "0157".indexOf(this.button) < 0 || this.currentTable == null) {
                return;
            }
            if (this.currentTable.getSelectedRow() == -1) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            int id = -1;
            int mode = 1;
            boolean edit = false;
            String titleEditor = "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432";
            String pluginExtensionPoint = null;
            switch (this.button) {
                case "5": {
                    new ReserveEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0435\u0437\u0435\u0440\u0432\u0430", (Reserve)this.modelReserve.getSelectedRow()).open();
                    return;
                }
                case "0": {
                    id = ((Payment)this.modelPayment.getSelectedRow()).getId();
                    edit = this.paymentTypeDirectory.get(((Payment)this.modelPayment.getSelectedRow()).getTypeId()) != null ? this.paymentTypeDirectory.get(((Payment)this.modelPayment.getSelectedRow()).getTypeId()).getEditable() : false;
                    titleEditor = "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432";
                    pluginExtensionPoint = "bitel.billing.module.contract.PaymentEditor";
                    mode = 0;
                    break;
                }
                case "7": {
                    titleEditor = "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432";
                    pluginExtensionPoint = "bitel.billing.module.contract.PaybackEditor";
                    mode = 2;
                }
                case "1": {
                    id = ((Charge)this.modelCharge.getSelectedRow()).getId();
                    pluginExtensionPoint = "bitel.billing.module.contract.ChargeEditor";
                    boolean bl = edit = this.chargeTypeDirectory.get(((Charge)this.modelCharge.getSelectedRow()).getTypeId()) != null ? this.chargeTypeDirectory.get(((Charge)this.modelCharge.getSelectedRow()).getTypeId()).getEditable() : false;
                }
            }
            if (!edit || id == -1) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                return;
            }
            PaymentAndChargeEditor editor = new PaymentAndChargeEditor(id, this.getContractId(), pluginExtensionPoint);
            editor.setTitle(titleEditor);
            editor.setMode(mode);
            editor.setData();
            editor.setVisible(true);
            this.refreshData();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void deleteItem() {
        if (this.button == null || "0157".indexOf(this.button) < 0 || this.currentTable == null) {
            return;
        }
        if (this.currentTable.getSelectedRow() == -1) {
            ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e!");
            return;
        }
        if (this.button.equals(BUTTON_RESERVE)) {
            ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435. \u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432.");
            return;
        }
        int id = -1;
        boolean edit = false;
        try {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0440\u0438\u0445\u043e\u0434/\u0440\u0430\u0441\u0445\u043e\u0434?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                if (BUTTON_PAYMENT.equals(this.button)) {
                    id = ((Payment)this.modelPayment.getSelectedRow()).getId();
                    edit = this.paymentTypeDirectory.get(((Payment)this.modelPayment.getSelectedRow()).getTypeId()) != null ? this.paymentTypeDirectory.get(((Payment)this.modelPayment.getSelectedRow()).getTypeId()).getEditable() : false;
                } else if (BUTTON_CHARGE.equals(this.button) || BUTTON_PAYBACK.equals(this.button)) {
                    id = this.modelCharge.getSelectedRow() != null ? ((Charge)this.modelCharge.getSelectedRow()).getId() : -1;
                    boolean bl = edit = this.chargeTypeDirectory.get(((Charge)this.modelCharge.getSelectedRow()).getTypeId()) != null ? this.chargeTypeDirectory.get(((Charge)this.modelCharge.getSelectedRow()).getTypeId()).getEditable() : false;
                    if (id > 0 && edit && BUTTON_CHARGE.equals(this.button)) {
                        for (Component component : this.popupMenu.getComponents()) {
                            try {
                                Method method = component.getClass().getDeclaredMethod("eventDeleteCharge", Integer.TYPE, ClientContext.class);
                                method.invoke((Object)component, id, this.getContext());
                            }
                            catch (Exception e) {
                                edit = false;
                            }
                        }
                    }
                }
                if (!edit || id < 1) {
                    ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                    return;
                }
                if (BUTTON_PAYMENT.equals(this.button)) {
                    this.getPaymentService().paymentDelete(this.getContractId(), id);
                } else if (BUTTON_CHARGE.equals(this.button) || BUTTON_PAYBACK.equals(this.button)) {
                    this.getChargeService().chargeDelete(this.getContractId(), id);
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.refreshData();
    }

    private Period getPeriod() {
        Calendar cd1 = TimeUtils.convertDateToCalendar(this.periodPanel.getDateFrom());
        Calendar cd2 = TimeUtils.convertDateToCalendar(this.periodPanel.getDateTo());
        if (cd1 != null) {
            cd1.set(5, 1);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(cd1);
        }
        if (cd2 != null) {
            TimeUtils.moveToEndOfMonth(cd2);
            TimeUtils.moveToStartNextDay(cd2);
            cd2.add(14, -1);
        }
        return new Period(cd1 == null ? null : cd1.getTime(), cd2 == null ? null : cd2.getTime());
    }

    private void refreshData() {
        Period period = this.getPeriod();
        BigDecimal sum = BigDecimal.ZERO;
        String but = this.button;
        if (BUTTON_PAYBACK.equals(this.button)) {
            but = BUTTON_CHARGE;
        } else if (BUTTON_AVAILABLE_SUM.equals(this.button)) {
            but = BUTTON_BALANCE_DETAIL;
        }
        try {
            this.currentTable = null;
            this.currentSubTable = null;
            switch (but) {
                case "0": {
                    this.currentTable = this.tablePayment;
                    this.currentSubTable = this.tableSubPayment;
                    SearchResult<Payment> searchResult = this.getPaymentService().paymentList(this.getContractId(), period, 1);
                    this.modelPayment.setData(searchResult.getList());
                    SearchResult<Payment> subSearchResult = this.getPaymentService().paymentList(this.getContractId(), period, 3);
                    this.modelSubPayment.setData(subSearchResult.getList());
                    sum = sum.add(searchResult.getSum()).add(subSearchResult.getSum());
                    break;
                }
                case "1": {
                    SearchResult<Charge> subChargeList;
                    SearchResult<Charge> chargeList;
                    this.currentTable = this.tableCharge;
                    this.currentSubTable = this.tableSubCharge;
                    if (BUTTON_PAYBACK.equals(this.button)) {
                        chargeList = this.getChargeService().paybackList(this.getContractId(), 0, period, 1);
                        subChargeList = this.getChargeService().paybackList(this.getContractId(), 0, period, 3);
                    } else {
                        chargeList = this.getChargeService().chargeList(this.getContractId(), 0, period, 1);
                        subChargeList = this.getChargeService().chargeList(this.getContractId(), 0, period, 3);
                    }
                    this.modelCharge.setData(chargeList.getList());
                    this.modelSubCharge.setData(subChargeList.getList());
                    sum = sum.add(chargeList.getSum()).add(subChargeList.getSum());
                    break;
                }
                case "2": {
                    this.currentTable = this.tableAccount;
                    this.currentSubTable = this.tableSubAccount;
                    SearchResult<ContractAccount> searchResult = this.getBalanceService().contractAccountList(this.getContractId(), period, 1);
                    this.modelAccount.setData(searchResult.getList());
                    SearchResult<ContractAccount> subSearchResult = this.getBalanceService().contractAccountList(this.getContractId(), period, 3);
                    this.modelSubAccount.setData(subSearchResult.getList());
                    sum = sum.add(searchResult.getSum()).add(subSearchResult.getSum());
                    break;
                }
                case "3": {
                    this.currentTable = this.tableBalance;
                    this.modelBalance.setData(this.getBalanceService().contractBalanceList(this.getContractId(), period));
                    sum = this.modelBalance.getRowCount() > 0 ? ((ContractBalance)this.modelBalance.getRows().get(this.modelBalance.getRowCount() - 1)).toBalance() : BigDecimal.ZERO;
                    break;
                }
                case "5": {
                    this.currentTable = this.tableReserve;
                    this.currentSubTable = this.tableSubReserve;
                    this.modelReserve.setData(this.getReserveService().reserveList(this.getContractId(), period, 1));
                    this.modelSubReserve.setData(this.getReserveService().reserveList(this.getContractId(), period, 3));
                    break;
                }
                case "4": {
                    this.currentTable = this.tableBalanceDetail;
                    this.modelBalanceDetail.setData(this.getBalanceService().balanceDetailList(this.getContractId(), period, BUTTON_AVAILABLE_SUM.equals(this.button)));
                    sum = this.modelBalanceDetail.getRowCount() > 0 ? ((BalanceDetailItem)this.modelBalanceDetail.getRows().get(this.modelBalanceDetail.getRowCount() - 1)).getSumAfterChange() : BigDecimal.ZERO;
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.tableCardLayout.show(this.tableScroll, but);
        this.summaTF.setText(Utils.formatBigDecimalSumm(sum));
        if (this.currentSubTable != null) {
            this.tableSubCardLayout.show(this.tableSubScroll, this.button);
            this.tableSubScroll.setVisible(this.currentSubTable.getRowCount() > 0);
        } else {
            this.tableSubScroll.setVisible(false);
        }
    }

    private void calcMonth(String month) {
        GregorianCalendar nowDate = new GregorianCalendar();
        String mode = this.buttonGroup1.getSelection().getActionCommand();
        int m = Utils.parseInt(month, 0);
        if ("M".equals(mode)) {
            Calendar date1 = (Calendar)((Calendar)nowDate).clone();
            date1.set(5, 1);
            date1.set(2, m - 1);
            if (date1.after(nowDate)) {
                date1.add(1, -1);
            }
            Calendar date2 = (Calendar)date1.clone();
            date2.add(2, 1);
            date2.add(5, -1);
            this.setPeriod(date1, date2);
        }
    }

    @Override
    public void setData() {
        try {
            this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
            this.serviceDirectory = this.getContext().getDirectory(Service.class);
            this.chargeTypeDirectory = this.getContext().getDirectory(ChargeType.class);
            this.paymentTypeDirectory = this.getContext().getDirectory(PaymentType.class);
            this.reserveTypeDirectory = this.getContext().getDirectory(ReserveType.class);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        if (this.load) {
            for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions("ru.bitel.bgbilling.kernel.contract.balance.client.ContractSubPanel_Balance", false)) {
                Element extensionElement = extension.getElement();
                NodeList list = extensionElement.getElementsByTagName("control");
                for (int index = 0; index < list.getLength(); ++index) {
                    Element controlEl = (Element)list.item(index);
                    try {
                        Class<?> clas = Class.forName(controlEl.getAttribute("class"));
                        Object comp = clas.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method method = clas.getDeclaredMethod("toAdd", JPopupMenu.class, Integer.TYPE, ClientContext.class);
                        if (!(comp instanceof JMenu) || method == null) continue;
                        method.invoke(comp, this.popupMenu, this.getContractId(), this.getContext());
                        continue;
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
            this.load = false;
        }
        this.refreshData();
    }

    private boolean a() {
        String periodMode;
        boolean result = false;
        String monthModeSwitch = this.setup.getUserConfig().get(KEY_MODE_SWITCH, MODE_SWITCH_PERIOD);
        if (MODE_SWITCH_PERIOD.equals(monthModeSwitch) && (periodMode = this.setup.getUserConfig().get(KEY_MODE_PERIOD, "cM")) != null) {
            this.calcPeriod(periodMode);
            result = true;
        }
        return result;
    }

    public void setMode(String mode) {
        if (mode != null) {
            this.button = mode;
            if (mode.equals(BUTTON_AVAILABLE_SUM)) {
                this.chargeButton.setSelected(BUTTON_RESERVE);
            } else {
                this.chargeButton.setSelected(mode);
                this.accountButton.setSelected(BUTTON_ACCOUNT.equals(mode));
                this.balanceButton.setSelected(mode);
                this.paymentButton.setSelected(BUTTON_PAYMENT.equals(mode));
            }
            this.summaPanel.setVisible(!BUTTON_RESERVE.equals(this.button));
            if (this.load) {
                this.setData();
            } else {
                this.refreshData();
            }
        }
    }

    public void setMode(String mode, ContractPanel_Parameters paramsPanel) {
        this.paramsPanel = paramsPanel;
        this.setMode(mode);
    }

    private BalanceService getBalanceService() {
        if (this.balanceService == null) {
            this.balanceService = this.getContext().getPort(BalanceService.class);
        }
        return this.balanceService;
    }

    private PaymentService getPaymentService() {
        if (this.paymentService == null) {
            this.paymentService = this.getContext().getPort(PaymentService.class);
        }
        return this.paymentService;
    }

    private ChargeService getChargeService() {
        if (this.chargeService == null) {
            this.chargeService = this.getContext().getPort(ChargeService.class);
        }
        return this.chargeService;
    }

    private ReserveService getReserveService() {
        if (this.reserveService == null) {
            this.reserveService = this.getContext().getPort(ReserveService.class);
        }
        return this.reserveService;
    }

    private class AccountTableModel
    extends BGTableModel<ContractAccount> {
        private static final String TYPE_TITLE = "typeTitle";
        private static final String CONTRACT_TITLE = "contractTitle";

        public AccountTableModel(String name, boolean subContracts) {
            super(name);
            if (subContracts) {
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 70, 200, 300, CONTRACT_TITLE, true, HorizontalAlignmentTableCellRenderer.CENTER());
            }
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 250, 250, -1, TYPE_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 80, 120, 150, "sum", true, DecimalTableCellRenderer.DEFAULT());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 120, "date", true, new DatetimeTableCellRenderer("LLLL yyyy", 0));
        }

        @Override
        public Object getValueAt(ContractAccount contractAccount, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if (CONTRACT_TITLE.equals(identifier)) {
                int contractId = contractAccount.getContractId();
                Contract contract = ContractSubPanel_Balance.this.paramsPanel.getContract(contractId, true);
                return contract == null ? "<\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : contract.getTitle();
            }
            if (TYPE_TITLE.equals(identifier)) {
                Service service = ContractSubPanel_Balance.this.serviceDirectory.get(contractAccount.getServiceId());
                return service == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : service.getTitle();
            }
            return super.getValue(contractAccount, column);
        }
    }

    private class PaymentTableModel
    extends AbstractBalanceTableModel<Payment> {
        private boolean subContracts;
        private Map<Integer, String> users;
        private Map<Integer, String> paymentTypes;

        public PaymentTableModel(String name, boolean subContracts) {
            super(name);
            this.subContracts = false;
            this.users = new TreeMap<Integer, String>();
            this.paymentTypes = new TreeMap<Integer, String>();
            this.subContracts = subContracts;
        }

        @Override
        public void setData(List<Payment> data) {
            try {
                ContractSubPanel_Balance.this.userDirectory.list().forEach(userInfo -> this.users.put(userInfo.getId(), userInfo.getName()));
                ContractSubPanel_Balance.this.paymentTypeDirectory.list().forEach(paymentType -> this.paymentTypes.put(paymentType.getId(), paymentType.getTitle()));
                super.setData(data);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            if (this.subContracts) {
                this.addColumnContractTitle();
            }
            this.addColumnDate();
            this.addColumnTypeTitle("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            this.addColumnSum();
            this.addColumnTimeChange();
            this.addColumnUserTitle();
            this.addColumnComment();
        }

        @Override
        public Object getValueAt(Payment val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "typeTitle": {
                    return Utils.maskBlank(this.paymentTypes.get(val.getTypeId()), "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>");
                }
                case "userTitle": {
                    return Utils.maskBlank(this.users.get(val.getUserId()), "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>");
                }
                case "contractTitle": {
                    return ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true) == null ? "<\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true);
                }
            }
            return super.getValue(val, column);
        }
    }

    private class ChargeTableModel
    extends AbstractBalanceTableModel<Charge> {
        private boolean subContracts;

        public ChargeTableModel(String name, boolean subContracts) {
            super(name);
            this.subContracts = false;
            this.subContracts = subContracts;
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            if (this.subContracts) {
                this.addColumnContractTitle();
            }
            this.addColumnDate();
            this.addColumnTypeTitle("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430");
            this.addColumnSum();
            this.addColumnTimeChange();
            this.addColumnUserTitle();
            this.addColumnComment();
        }

        @Override
        public Object getValueAt(Charge val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "typeTitle": {
                    return ContractSubPanel_Balance.this.chargeTypeDirectory.get(val.getTypeId()) == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.chargeTypeDirectory.get(val.getTypeId()).getTitle();
                }
                case "userTitle": {
                    return ContractSubPanel_Balance.this.userDirectory.get(val.getUserId()) == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.userDirectory.get(val.getUserId()).getName();
                }
                case "contractTitle": {
                    return ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true) == null ? "<\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true);
                }
            }
            return super.getValue(val, column);
        }
    }

    private class ReserveTableModel
    extends AbstractBalanceTableModel<Reserve> {
        private boolean subContracts;

        public ReserveTableModel(String name, boolean subContracts) {
            super(name);
            this.subContracts = false;
            this.subContracts = subContracts;
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            if (this.subContracts) {
                this.addColumnContractTitle();
            }
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 300, 300, 300, ContractSubPanel_Balance.MODE_SWITCH_PERIOD, true, new PeriodTableCellRenderer());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f", 160, 160, 160, "dateClose", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumnSum();
            this.addColumnTypeTitle("\u0422\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430");
            this.addColumnComment();
        }

        @Override
        public Object getValueAt(Reserve val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "typeTitle": {
                    return ContractSubPanel_Balance.this.reserveTypeDirectory.get(val.getTypeId()) == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.reserveTypeDirectory.get(val.getTypeId()).getTitle();
                }
                case "contractTitle": {
                    return ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true) == null ? "<\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ContractSubPanel_Balance.this.paramsPanel.getContract(val.getContractId(), true);
                }
            }
            return super.getValue(val, column);
        }
    }

    private class BalanceTableModel
    extends AbstractBalanceTableModel<ContractBalance> {
        public BalanceTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 120, 120, -1, "date", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a", 130, 150, -1, "incomingSaldo", false, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u0440\u0438\u0445\u043e\u0434", 130, 150, -1, "payments", false, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430", 130, 150, -1, "accounts", false, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0420\u0430\u0441\u0445\u043e\u0434", 130, 150, -1, "charges", false, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a", 130, 150, -1, "balance", true, DecimalTableCellRenderer.DEFAULT());
        }

        @Override
        public Object getValue(ContractBalance val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "date": {
                    return TimeUtils.monthNames[val.getMonth() - 1] + " " + val.getYear();
                }
                case "balance": {
                    return val.toBalance();
                }
            }
            return super.getValue(val, column);
        }
    }

    private class BalanceDetailTableModel
    extends AbstractBalanceTableModel<BalanceDetailItem> {
        public BalanceDetailTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 120, 200, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumnContractTitle();
            this.addColumnTypeTitle("\u0422\u0438\u043f");
            this.addColumnComment();
            this.addColumnSum();
            this.addColumn("\u041e\u0441\u0442\u0430\u0442\u043e\u043a", 100, 100, 100, "sumAfterChange", true, DecimalTableCellRenderer.DEFAULT());
        }
    }

    private class BalanceToggleButton
    extends JToggleButton {
        BalanceToggleButton(String text, String actionCommand) {
            this.setText(text);
            this.setActionCommand(actionCommand);
            this.setFont(new Font("Dialog", 1, 14));
            ContractSubPanel_Balance.this.buttonGroup2.add(this);
        }
    }

    private class BalancPeriodButton
    extends JButton {
        public BalancPeriodButton(String actionCommand, String text, String toolTipText, ActionListener actionListener) {
            this.setActionCommand(actionCommand);
            this.setText(text);
            this.setToolTipText(toolTipText);
            this.addActionListener(actionListener);
        }
    }

    private class AccountDetailTableModel
    extends BGTableModel<ContractAccountDetail> {
        public AccountDetailTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, ContractSubPanel_Balance.MODE_SWITCH_PERIOD, true);
            this.addColumn("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a", 100, 100, -1, "entityTitle", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0426\u0435\u043d\u0430", 80, 80, 80, "cost", true, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 90, 90, 90, "amount", true, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 80, 80, 80, "sum", true, DecimalTableCellRenderer.DEFAULT());
        }
    }

    class ReserveEditorDialog
    extends BGEditorDialog<Reserve> {
        private BGTextField commentField;
        private BGFloatTextField sumTextField;
        private BGUComboBox<ReserveType> typeComboBox;
        private JToggleButton closeReserve;
        private BGControlPanelDateWithTime dateTo;
        static final int buferMinute = 2;

        public ReserveEditorDialog(String title, Reserve data) {
            super(title, data);
            this.commentField = new BGTextField(50);
            this.sumTextField = new BGFloatTextField();
            this.typeComboBox = new BGUComboBox();
            this.closeReserve = new JToggleButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432");
            this.dateTo = new BGControlPanelDateWithTime();
        }

        @Override
        public void doDialogPanel() {
            this.sumTextField.setMinimumSize(new Dimension(45, this.sumTextField.getMinimumSize().height));
            this.panel.add((Component)new JLabel("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.dateTo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
            this.panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.sumTextField, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add(this.typeComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.commentField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.closeReserve, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            try {
                this.closeReserve.setVisible(false);
                this.closeReserve.setSelected(false);
                this.typeComboBox.setData(ContractSubPanel_Balance.this.getContext().getPort(ReserveService.class).reserveTypeList(true));
                if (this.data != null) {
                    this.dateTo.setDate(((Reserve)this.data).getPeriod().getDateTo());
                    this.sumTextField.setText(((Reserve)this.data).getSum().toString());
                    this.typeComboBox.setSelectedItem(this.data);
                    this.commentField.setText(((Reserve)this.data).getComment());
                    BGSwingUtilites.setEnabled(this.dateTo, false);
                    this.dateTo.setEnabled(false);
                    this.sumTextField.setEnabled(false);
                    if (((Reserve)this.data).getDateClose() == null) {
                        this.closeReserve.setVisible(true);
                    }
                } else {
                    this.dateTo.setDate(null);
                    this.sumTextField.setText("");
                    this.commentField.setText("");
                    BGSwingUtilites.setEnabled(this.dateTo, true);
                    this.sumTextField.setEnabled(true);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean doApply() throws Exception {
            try {
                Reserve reserve;
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, 2);
                if (this.data == null && this.dateTo.getDate() != null && calendar.compareTo(this.dateTo.getDateCalendar()) >= 0) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0447\u0435\u043c \u0447\u0435\u0440\u0435\u0437 2 \u043c\u0438\u043d.", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                    return false;
                }
                if (this.data == null && Utils.parseBigDecimal(this.sumTextField.getText(), BigDecimal.ZERO).compareTo(BigDecimal.ZERO) != 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u0430!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                    return false;
                }
                if (this.typeComboBox.getSelectedIndex() == -1) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430!");
                    return false;
                }
                if (this.data == null) {
                    reserve = Reserve.builder().setContractId(ContractSubPanel_Balance.this.getContractId()).setTypeId(((ReserveType)this.typeComboBox.getSelectedItem()).getId()).setPeriod(new PeriodWithTime(null, this.dateTo.getDate())).setSum(Utils.parseBigDecimal(this.sumTextField.getText(), BigDecimal.ZERO)).setComment(this.commentField.getText()).build();
                } else {
                    reserve = Reserve.builder().setId(((Reserve)this.data).getId()).setContractId(ContractSubPanel_Balance.this.getContractId()).setTypeId(((ReserveType)this.typeComboBox.getSelectedItem()).getId()).setPeriod(((Reserve)this.data).getPeriod()).setSum(((Reserve)this.data).getSum()).setComment(this.commentField.getText()).build();
                    if (this.closeReserve.isSelected() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432?", "", 2) == 0) {
                        ContractSubPanel_Balance.this.getContext().getPort(ReserveService.class).closeReserve(((Reserve)this.data).getId());
                    }
                }
                ContractSubPanel_Balance.this.getContext().getPort(ReserveService.class).updateReserve(reserve);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ContractSubPanel_Balance.this.getContractId()));
                return true;
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return true;
        }
    }
}

