/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.CustomerParameterProviderService;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.client.table.BGTableModel;

public final class CompanyDataResultDialog
extends BGEditorDialog<JSONObject> {
    private final BGUTable table;
    private final CompanyDataTableModel tableModel;
    private final JSONObject oldData;

    public CompanyDataResultDialog(ClientContext context, JSONObject data, JSONObject oldData) {
        super("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043e \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438", (Object)data, context);
        this.oldData = oldData != null ? oldData : new JSONObject();
        this.tableModel = new CompanyDataTableModel();
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompanyDataModel model = (CompanyDataModel)CompanyDataResultDialog.this.tableModel.getSelectedRow();
                    model.needUpdate = !model.needUpdate;
                    CompanyDataResultDialog.this.table.repaint();
                }
            }
        });
    }

    public void doDialogPanel() {
        super.setDialogSize(new Dimension(1200, 400));
        JSONObject companyData = (JSONObject)this.getData();
        this.tableModel.setData(this.convertToModel(companyData));
        this.panel.add((Component)this.companyStatePanel(companyData), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel companyStatePanel(JSONObject companyData) {
        JPanel p = new JPanel(new GridBagLayout());
        if (companyData.optBoolean("isActive")) {
            p.add((Component)new JLabel(ClientUtils.getIcon((String)"fugue/tick-circle.png")), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            p.add((Component)new JLabel("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 3, 5, 0), 0, 0));
        } else {
            p.add((Component)new JLabel(ClientUtils.getIcon((String)"lock.gif")), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            p.add((Component)new JLabel("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043b\u0438\u043a\u0432\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0430"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 3, 5, 0), 0, 0));
        }
        return p;
    }

    private List<CompanyDataModel> convertToModel(JSONObject data) {
        ArrayList<CompanyDataModel> l = new ArrayList<CompanyDataModel>();
        l.add(new CompanyDataModel(this, Customer.Keys.NAME, "fullTitle", data.optString("fullTitle"), this.oldData.optString(Customer.Keys.NAME.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.INN, "inn", data.optString("inn"), this.oldData.optString(Customer.Keys.INN.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.OGRN, "ogrn", data.optString("ogrn"), this.oldData.optString(Customer.Keys.OGRN.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.KPP, "kpp", data.optString("kpp"), this.oldData.optString(Customer.Keys.KPP.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.U_ADDRESS, "address", data.optString("address"), this.oldData.optString(Customer.Keys.U_ADDRESS.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.P_ADDRESS, "address", data.optString("address"), this.oldData.optString(Customer.Keys.P_ADDRESS.key())));
        JSONObject supervisor = data.optJSONObject("supervisor");
        l.add(new CompanyDataModel(this, Customer.Keys.DIRECTOR_NAME, "supervisor.name", supervisor.optString("name"), this.oldData.optString(Customer.Keys.DIRECTOR_NAME.key())));
        l.add(new CompanyDataModel(this, Customer.Keys.DIRECTOR_POSITION, "supervisor.position", supervisor.optString("position"), this.oldData.optString(Customer.Keys.DIRECTOR_POSITION.key())));
        return l;
    }

    public boolean doApply() throws Exception {
        Object msg;
        List dataOfTable = this.tableModel.getRows();
        long selectedParametersForUpdate = dataOfTable.stream().filter(p -> p.needUpdate).count();
        Object object = msg = selectedParametersForUpdate == 0L ? "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430" : "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 " + selectedParametersForUpdate + " \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440(\u043e\u0432)?";
        if (ClientUtils.confirm((String)msg, (String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432")) {
            JSONObject dataForUpdateContractParameters = new JSONObject();
            dataForUpdateContractParameters.put("bgMapping", ((JSONObject)this.getData()).get("bgMapping"));
            CustomerService customerService = (CustomerService)this.clientContext.getPort(CustomerService.class, 0);
            int customerId = this.clientContext.getCustomerId();
            for (CompanyDataModel companyDataModel : dataOfTable) {
                if (selectedParametersForUpdate != 0L && !companyDataModel.needUpdate) continue;
                if (customerId == 0) {
                    customerId = customerService.customerNewSet(this.clientContext.getContractId());
                    this.clientContext.setCustomer(new JSONObject(customerService.customerParameterGet(this.clientContext.getContractId())));
                }
                JSONObject customer = this.clientContext.getCustomer();
                String result = customerService.customerParameterUpdate(customerId, companyDataModel.key.key(), companyDataModel.getValue());
                if (result != null) {
                    customer.put("customer", (Object)new JSONObject(result).getJSONObject("customer"));
                }
                dataForUpdateContractParameters.put(companyDataModel.keyName, (Object)companyDataModel.getValue());
            }
            ((CustomerParameterProviderService)this.clientContext.getPort(CustomerParameterProviderService.class, 0)).updateContractParameters(this.clientContext.getContractId(), dataForUpdateContractParameters.toString());
            for (JPanel tab : BGClientBase.getFrame().getTabbedPane().getTabList()) {
                BGTabPanel tabPanel;
                if (!(tab instanceof BGTabPanel) || !(tabPanel = (BGTabPanel)tab).getTabId().equals("contract_" + this.clientContext.getContractId())) continue;
                tabPanel.setData();
            }
            return true;
        }
        return false;
    }

    private final class CompanyDataTableModel
    extends BGTableModel<CompanyDataModel> {
        public CompanyDataTableModel() {
            super("companyDataTable");
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 130, 130, 130, "title");
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value");
            this.addColumn("\u0418\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432", -1, -1, -1, "oldValue");
            this.addColumn("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", 100, 100, 100, "needUpdate");
        }
    }

    public final class CompanyDataModel {
        public String title;
        public Customer.Keys key;
        public String keyName;
        public String value;
        public String oldValue;
        public boolean needUpdate;

        public CompanyDataModel(CompanyDataResultDialog this$0) {
        }

        public CompanyDataModel(CompanyDataResultDialog this$0, Customer.Keys key, String keyName, String value, String oldValue) {
            this.title = key.description();
            this.key = key;
            this.keyName = keyName;
            this.value = value;
            this.oldValue = oldValue;
        }

        public Customer.Keys getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isNeedUpdate() {
            return this.needUpdate;
        }
    }
}

