/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.util.tables;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class BaseTable {
    private String[] fields = null;
    private String[] index = null;
    private String tableName = null;
    private Connection con = null;

    public BaseTable(String tableName, String[] fields, String[] index) {
        this.tableName = tableName;
        this.fields = fields;
        this.index = index;
    }

    public void loadTable(Connection con, DBFReader reader) throws BGException, SQLException, DBFException {
        this.con = con;
        this.recreateTableForRegion();
        PreparedStatement ps = con.prepareStatement(this.getInsertString());
        List<Integer> fieldsPos = this.getFieldPosition(reader);
        for (int i = 0; i < reader.getRecordCount(); ++i) {
            Object[] record = reader.nextRecord();
            int index = 1;
            block5: for (Integer pos : fieldsPos) {
                String val;
                if (pos == null) {
                    ps.setString(index++, "NOT FOUND");
                    continue;
                }
                DBFField f = reader.getField(pos.intValue());
                switch (f.getDataType()) {
                    case 78: {
                        BigDecimal d = (BigDecimal)record[pos];
                        val = d == null ? "" : String.valueOf(d.intValue());
                        ps.setString(index++, val);
                        continue block5;
                    }
                    case 68: {
                        ps.setString(index++, TimeUtils.formatDate((Date)((Date)record[pos])));
                        continue block5;
                    }
                }
                Object obj = record[pos];
                val = obj == null ? "" : obj.toString().trim();
                ps.setString(index++, val);
            }
            ps.executeUpdate();
        }
        ps.close();
    }

    private List<Integer> getFieldPosition(DBFReader reader) throws DBFException {
        int i;
        ArrayList<Integer> result = new ArrayList<Integer>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < reader.getFieldCount(); ++i) {
            DBFField f = reader.getField(i);
            map.put(f.getName(), i);
        }
        for (i = 0; i < this.fields.length; ++i) {
            result.add((Integer)map.get(this.fields[i]));
        }
        return result;
    }

    private String getInsertString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO " + this.tableName + " SET ");
        for (int i = 0; i < this.fields.length; ++i) {
            sb.append(this.fields[i]);
            sb.append("=?");
            if (i >= this.fields.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateTableForRegion() throws BGException, SQLException {
        if (this.con == null) {
            throw new BGException("ERROR in RegionLoadTask");
        }
        ServerUtils.dropExistTable((Connection)this.con, (String)this.tableName);
        try (Statement stmt = this.con.createStatement();){
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE " + this.tableName + " (");
            for (i = 0; i < this.fields.length; ++i) {
                sb.append(this.fields[i]);
                sb.append(" VARCHAR(150) NULL DEFAULT NULL");
                if (i >= this.fields.length - 1) continue;
                sb.append(",");
            }
            for (i = 0; i < this.index.length; ++i) {
                sb.append(", INDEX " + this.index[i] + " (" + this.index[i] + ")");
            }
            sb.append(")");
            String createQuery = sb.toString();
            stmt.executeUpdate(createQuery);
        }
    }

    public String getTableName() {
        return this.tableName;
    }
}

