/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPEntry;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.LDAPDriver;
import ru.bitel.common.ParameterMap;

public abstract class DefaultLDAPDriver
implements LDAPDriver {
    protected Domain domain;
    protected ParameterMap params;

    @Override
    public void init(Domain domain, ParameterMap params) {
        this.domain = domain;
        this.params = params;
    }

    protected LDAPConnection getConnection() {
        LDAPConnection lc = new LDAPConnection();
        try {
            LDAPConstraints constraints = new LDAPConstraints();
            constraints.setTimeLimit(1000);
            lc.setConstraints(constraints);
            String user = this.params.get("user", "cn=admin, dc=mydomain, dc=ru");
            byte[] pswd = this.params.get("password", "secret").getBytes("UTF8");
            lc.connect(this.params.get("host", "127.0.0.1"), this.params.getInt("port", 389));
            lc.bind(3, user, pswd);
            return lc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void closeConnection(LDAPConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int deleteAccount(Account mailAccount) {
        int result = 0;
        LDAPConnection con = this.getConnection();
        if (con == null) {
            result = 1;
        } else {
            try {
                con.delete(this.getAccountDN(mailAccount));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeConnection(con);
        return result;
    }

    @Override
    public int addAccount(Account mailAccount) {
        int result = 0;
        LDAPConnection con = this.getConnection();
        if (con == null) {
            result = 1;
        } else {
            try {
                String dn = this.getAccountDN(mailAccount);
                try {
                    LDAPEntry entry = con.read(dn);
                    LDAPAttribute base = entry.getAttributeSet().getAttribute("base");
                    if (base == null || !this.params.get("base", "bgbilling").equals(base.getStringValue())) {
                        return 2;
                    }
                }
                catch (Exception entry) {
                    // empty catch block
                }
                try {
                    con.delete(dn);
                }
                catch (Exception entry) {
                    // empty catch block
                }
                LDAPAttributeSet attributeSet = this.getAccountAttributeSet(mailAccount);
                LDAPEntry entry = new LDAPEntry(dn, attributeSet);
                con.add(entry);
            }
            catch (Exception ex) {
                result = 4;
                ex.printStackTrace();
            }
        }
        this.closeConnection(con);
        return result;
    }

    @Override
    public int updateAccount(Account mailAccount) {
        int result = 0;
        LDAPConnection con = this.getConnection();
        if (con == null) {
            result = 1;
        } else {
            try {
                result = this.deleteAccount(mailAccount);
                if (result != 0) {
                    return result;
                }
                result = this.addAccount(mailAccount);
            }
            catch (Exception ex) {
                result = 5;
                ex.printStackTrace();
            }
        }
        this.closeConnection(con);
        return result;
    }

    protected abstract String getAccountDN(Account var1);

    protected abstract LDAPAttributeSet getAccountAttributeSet(Account var1);
}

