/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGControlPanelTextArea;

public abstract class TariffEditor
extends BGPanel {
    private BGControlPanelTextArea comment = new BGControlPanelTextArea();
    private BGButtonPanelRestoreOkCancelHelp confirmPanel = new BGButtonPanelRestoreOkCancelHelp();
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private BGComboBox<ComboBoxItem> tariffPlansBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> modulesBox = new BGComboBox();
    private JCheckBox showUsedOnlyFlag = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
    private JCheckBox useFilterFlag = new JCheckBox("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
    private JCheckBox tariffGroupFilter = new JCheckBox("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0433\u0440\u0443\u043f\u043f\u0435 \u0442\u0430\u0440\u0438\u0444\u0430");
    private BGIntTextField posTf = new BGIntTextField();

    public TariffEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.comment.getJTextArea().setRows(3);
    }

    protected abstract boolean needModuleBox();

    protected abstract void addParamsToRequest(Request var1);

    private void jbInit() throws Exception {
        this.posTf.setMinimumSize(new Dimension(50, 24));
        this.posTf.setPreferredSize(new Dimension(50, 24));
        this.comment.setMinimumSize(new Dimension(100, 60));
        this.comment.setPreferredSize(new Dimension(100, 60));
        this.tariffGroupFilter.setSelected(Boolean.valueOf(ClientSetup.getInstance().get("contract.tariff.editor.groupFilter", "false")));
        JPanel tpChoosePanel = new JPanel(new GridBagLayout());
        tpChoosePanel.setBorder(new BGTitleBorder(" \u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d "));
        this.showUsedOnlyFlag.setSelected(true);
        this.showUsedOnlyFlag.addActionListener(e -> this.setData());
        this.useFilterFlag.setSelected(true);
        this.useFilterFlag.addActionListener(e -> this.setData());
        this.tariffGroupFilter.addActionListener(e -> {
            boolean isFilterSelected = Boolean.valueOf(ClientSetup.getInstance().get("contract.tariff.editor.groupFilter", "false"));
            if (this.tariffGroupFilter.isSelected() != isFilterSelected) {
                ClientSetup.getInstance().getUserConfig().set("contract.tariff.editor.groupFilter", String.valueOf(this.tariffGroupFilter.isSelected()));
                ClientSetup.getInstance().saveUserConfig();
            }
            this.setData();
        });
        tpChoosePanel.add((Component)this.showUsedOnlyFlag, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        tpChoosePanel.add((Component)this.useFilterFlag, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        tpChoosePanel.add((Component)this.tariffGroupFilter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.getItemsForModulesBox();
        JPanel modulesPanel = new JPanel(new GridBagLayout());
        modulesPanel.setBorder(new BGTitleBorder(" \u041c\u043e\u0434\u0443\u043b\u044c "));
        this.modulesBox.addActionListener(e -> this.setData());
        modulesPanel.add(this.modulesBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        if (this.needModuleBox()) {
            tpChoosePanel.add((Component)modulesPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        JPanel tpNamePanel = new JPanel(new GridBagLayout());
        tpNamePanel.setBorder(new BGTitleBorder(" \u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 "));
        tpNamePanel.add(this.tariffPlansBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        tpChoosePanel.add((Component)tpNamePanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel posPanel = new JPanel(new GridBagLayout());
        posPanel.setBorder(new BGTitleBorder(" \u041f\u043e\u0437\u0438\u0446\u0438\u044f "));
        posPanel.add((Component)this.posTf, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.comment.setTitle(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ");
        this.confirmPanel.addActionListener(e -> this.confirmPanel_actionPerformed(e));
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.add((Component)tpChoosePanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)posPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.periodPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.comment, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.confirmPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    @Override
    public void setData() {
        this.clearFields();
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractTariffPlan");
        request.setContractId(this.getContractId());
        request.setAttribute("id", this.id);
        request.setAttribute("showUsed", this.showUsedOnlyFlag.getModel().isSelected() ? 1 : 0);
        if (this.needModuleBox()) {
            request.setAttribute("mid", this.modulesBox.getSelectedItem().getObject());
        } else {
            request.setAttribute("mid", this.getModuleId());
        }
        request.setAttribute("useFilter", this.useFilterFlag.getModel().isSelected() ? 1 : 0);
        request.setAttribute("tariffGroupFilter", this.tariffGroupFilter.getModel().isSelected() ? 1 : 0);
        Document doc = TransferManager.getDocument(request);
        if (!ClientUtils.checkStatus(doc)) {
            return;
        }
        Element tariffPlan = XMLUtils.getElement(doc, "tariffPlan");
        String tpid = XMLUtils.getAttribute(tariffPlan, "tpid", "0");
        String date = XMLUtils.getAttribute(tariffPlan, "date1", null);
        if (date != null) {
            this.periodPanel.setDateString1(date);
        } else {
            this.periodPanel.setDateCalendar1(new GregorianCalendar());
        }
        date = XMLUtils.getAttribute(tariffPlan, "date2", null);
        if (date != null) {
            this.periodPanel.setDateString2(date);
        }
        this.comment.setText(XMLUtils.getAttribute(tariffPlan, "comment", ""));
        this.posTf.setText(tariffPlan.getAttribute("pos"));
        Node tariffPlans = XMLUtils.getNode(doc, "tariffPlans");
        DefaultComboBoxModel<ComboBoxItem> model = ClientUtils.buildComboBox(tariffPlans, tpid);
        ComboBoxItem itemSelected = (ComboBoxItem)model.getSelectedItem();
        this.tariffPlansBox.setModel(model);
        this.tariffPlansBox.setSelectedItem(itemSelected);
    }

    void confirmPanel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            ComboBoxItem item = this.tariffPlansBox.getSelectedItem();
            if (item == null || ((String)item.getObject()).equals("0")) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444");
                return;
            }
            if (Utils.isEmptyString(this.periodPanel.getDateString1())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            Request request = new Request();
            request.setModule("contract");
            request.setAction("UpdateContractTariffPlan");
            request.setAttribute("id", this.id);
            request.setContractId(this.getContractId());
            request.setAttribute("tpid", item.getObject());
            request.setAttribute("date1", this.periodPanel.getDateString1());
            request.setAttribute("date2", this.periodPanel.getDateString2());
            request.setAttribute("comment", this.comment.getText().trim());
            request.setAttribute("pos", this.posTf.getText());
            this.addParamsToRequest(request);
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setVisible(false);
                if (this.getParent() instanceof BGPanel) {
                    ((BGPanel)this.getParent()).trySetData();
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        }
    }

    private void getItemsForModulesBox() {
        this.modulesBox.addItem(new ComboBoxItem(-1, "\u041b\u044e\u0431\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c"));
        try {
            this.getContext().getWebService(AdminService.class).getModules().forEach(bgModule -> this.modulesBox.addItem(new ComboBoxItem(bgModule.getId(), bgModule.getTitle())));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void clearFields() {
        this.comment.setText("");
        this.posTf.setText("");
        this.periodPanel.setLocalDateFrom(LocalDate.now());
        this.periodPanel.setLocalDateTo(null);
    }
}

