/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;

public class ServicePortLinkEditor
extends BGPanel {
    private int editingId;
    BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    JScrollPane jScrollPane1 = new JScrollPane();
    BGTable table = new BGTable();
    JPanel editor = new JPanel(new GridBagLayout());
    JTextField port_from = new JTextField();
    JTextField port_to = new JTextField();
    JComboBox<ComboBoxItem> servicesList = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    BGButtonPanelOkCancel bGControlPanel_021 = new BGButtonPanelOkCancel();
    JLabel jLabel3 = new JLabel();

    public ServicePortLinkEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.dialogToolBar.setDefaultButtons(e -> this.action(e));
        this.dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "separator", "copyItem", "deleteItem"});
        this.dialogToolBar.setFloatable(false);
        this.table.setHeader(ClientUtils.getRBName(this), "0");
        this.editor.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.editor.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.port_to.setPreferredSize(new Dimension(60, 20));
        this.port_to.setToolTipText("");
        this.port_to.setText("");
        this.port_from.setMinimumSize(new Dimension(4, 20));
        this.port_from.setPreferredSize(new Dimension(60, 20));
        this.port_from.setText("");
        this.jLabel1.setText("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432:");
        this.jLabel2.setFont(new Font("Dialog", 1, 20));
        this.jLabel2.setText("-");
        this.bGControlPanel_021.addActionListener(e -> this.bGControlPanel_021_actionPerformed(e));
        this.jLabel3.setVerifyInputWhenFocusTarget(true);
        this.jLabel3.setText("\u0423\u0441\u043b\u0443\u0433\u0430:");
        this.editor.add((Component)this.port_from, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.editor.add((Component)this.port_to, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.editor.add(this.servicesList, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.table, null);
        this.editor.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.bGControlPanel_021, new GridBagConstraints(0, 1, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.jLabel3, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.editItem());
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setAction("GetNasServices");
        request.setModule(this.module);
        request.setAttribute("nas_id", this.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.setDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) {
        this.table.updateData(XMLUtils.getNode(doc, "table"));
    }

    private void action(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("newItem")) {
            this.newItem();
        } else if (command.equals("copyItem")) {
            this.copyItem();
        } else if (command.equals("deleteItem")) {
            this.deleteItem();
        } else if (command.equals("editItem")) {
            this.editItem();
        }
    }

    @Override
    public void newItem() {
        this.editor.setVisible(true);
        this.editingId = 0;
        this.buildServicesCombo(null);
    }

    @Override
    public void editItem() {
        this.editingId = ClientUtils.getRowId(this.table);
        if (this.editingId != 0) {
            this.copyDataToEditor();
            this.editor.setVisible(true);
        }
    }

    private void buildServicesCombo(String selectedSid) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ModuleServices");
        request.setModuleId(this.getModuleId());
        Document doc = null;
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.servicesList.setModel(ClientUtils.buildComboBox(XMLUtils.getNode(doc, "services"), selectedSid));
        }
    }

    @Override
    public void copyItem() {
        int id = ClientUtils.getRowId(this.table);
        if (id != 0) {
            this.copyDataToEditor();
            this.editingId = 0;
            this.editor.setVisible(true);
        }
    }

    private void copyDataToEditor() {
        int row = this.table.getSelectedRow();
        String ports = (String)this.table.getValueAt(row, 1);
        String sid = (String)this.table.getValueAt(row, 3);
        String port1 = null;
        String port2 = null;
        StringTokenizer st = new StringTokenizer(ports, "-");
        if (st.hasMoreTokens()) {
            port1 = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            port2 = st.nextToken().trim();
        }
        this.buildServicesCombo(sid);
        this.port_from.setText(port1);
        this.port_to.setText(port2);
    }

    @Override
    public void deleteItem() {
        int id = ClientUtils.getRowId(this.table);
        if (id != 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAttribute("id", id);
            request.setAction("DeleteNasService");
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
        }
    }

    void bGControlPanel_021_actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (BGButtonPanelOkCancel.OK.getActionCommand().equals(command)) {
            this.saveItem();
        }
        this.editor.setVisible(false);
        this.setData();
    }

    private void saveItem() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateNasService");
        request.setAttribute("nas_id", this.getId());
        request.setAttribute("id", this.editingId);
        request.setAttribute("port1", this.port_from.getText());
        request.setAttribute("port2", this.port_to.getText());
        request.setAttribute("sid", ((ComboBoxItem)this.servicesList.getSelectedItem()).getObject());
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.editor.setVisible(false);
        }
    }
}

