/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.crm.client.TaskManager;
import ru.bitel.bgbilling.plugins.crm.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.crm.client.admin.ProblemHistoryViewer;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterObjectType;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.common.service.CRMService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;

public class ProblemManager
extends BGUTabPanel {
    private static final String MODULE_ADMIN_REGISTER = "ru.bitel.bgbilling.plugins.crm";
    private int problemID = 0;
    private ActionListener openContractListener;
    private BGTable table = new BGTable();
    private JPanel topPanel = new JPanel(new GridBagLayout());
    private BGTextField codeTF = new BGTextField();
    private BGTextField commentTF = new BGTextField();
    private JPopupMenu rcMenu = new JPopupMenu();
    private JPanel filterPanel = new JPanel();
    private BGComboBox<ComboBoxItem> sort1Combo = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort2Combo = new BGComboBox();
    private JLabel total = new JLabel("\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c: 0");
    private JCheckBox openDateFilter_ChB = new JCheckBox("\u0434\u0430\u0442\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f");
    private JCheckBox statusDateFilter_ChB = new JCheckBox("\u0434\u0430\u0442\u0430 \u0442\u0435\u043a. \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
    private JCheckBox closeDateFilter_ChB = new JCheckBox("\u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f");
    private JRadioButton statusDateAND_RB = new JRadioButton("\u0438");
    private JRadioButton statusDateOR_RB = new JRadioButton("\u0438\u043b\u0438");
    private JRadioButton closeDateAND_RB = new JRadioButton("\u0438");
    private JRadioButton closeDateOR_RB = new JRadioButton("\u0438\u043b\u0438");
    private JToggleButton filterButton = new JToggleButton();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelListSelect groupList = new BGControlPanelListSelect(2);
    private BGControlPanelListSelect statusList = new BGControlPanelListSelect(2);
    private BGControlPanelListSelect executorList = new BGControlPanelListSelect(2);
    private BGControlPanelPeriodNoB openPeriod_P = new BGControlPanelPeriodNoB();
    private BGControlPanelPeriodNoB statusPeriod_P = new BGControlPanelPeriodNoB();
    private BGControlPanelPeriodNoB closePeriod_P = new BGControlPanelPeriodNoB();
    private ProblemHistoryViewer historyViewer = new ProblemHistoryViewer();
    private List<IdTitle> statusItems;
    private List<IdTitle> groupItems;

    protected void shownNotify() {
        this.initStatusAndGroup();
    }

    protected void jbInit() throws Exception {
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin(MODULE_ADMIN_REGISTER);
        this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("problem"), "problem");
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        this.table.getColumnModel().getColumn(5).setCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        this.historyViewer.setVisible(false);
        JPanel sortPanel = new JPanel(new GridBagLayout());
        this.buildSortCombo((JComboBox<ComboBoxItem>)this.sort1Combo);
        this.buildSortCombo((JComboBox<ComboBoxItem>)this.sort2Combo);
        ButtonGroup group = new ButtonGroup();
        group = new ButtonGroup();
        group.add(this.statusDateAND_RB);
        group.add(this.statusDateOR_RB);
        group = new ButtonGroup();
        group.add(this.closeDateAND_RB);
        group.add(this.closeDateOR_RB);
        this.total.setFont(new Font("Arial", 1, 14));
        this.filterButton.setText("\u0424\u0438\u043b\u044c\u0442\u0440 + \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430");
        this.filterButton.addActionListener(e -> this.filterPanel.setVisible(this.filterButton.isSelected()));
        this.filterPanel.setVisible(this.filterButton.isSelected());
        JPanel leftFilterPanel = new JPanel(new GridBagLayout());
        leftFilterPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 "));
        leftFilterPanel.add((Component)new JLabel("\u041a\u043e\u0434:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        leftFilterPanel.add((Component)this.codeTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        leftFilterPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        leftFilterPanel.add((Component)this.commentTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        sortPanel.setBorder((Border)new BGTitleBorder(" \u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 "));
        sortPanel.add((Component)this.sort1Combo, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add((Component)this.sort2Combo, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel rightFilterPanel = new JPanel(new GridBagLayout());
        rightFilterPanel.add((Component)this.openDateFilter_ChB, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.openPeriod_P, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.statusDateAND_RB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.statusDateOR_RB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.statusDateFilter_ChB, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.statusPeriod_P, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.closePeriod_P, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.closeDateAND_RB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.closeDateOR_RB, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)this.closeDateFilter_ChB, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)leftFilterPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        rightFilterPanel.add((Component)sortPanel, new GridBagConstraints(0, 5, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.executorList.setPreferredSize(new Dimension(200, 100));
        this.executorList.setMaximumSize(new Dimension(200, 100));
        JPanel listPanel = new JPanel(new GridLayout(1, 3));
        listPanel.add(new ComponentTitle("\u0421\u0442\u0430\u0442\u0443\u0441\u044b", (JComponent)this.statusList));
        listPanel.add(new ComponentTitle("\u0413\u0440\u0443\u043f\u043f\u044b", (JComponent)this.groupList));
        listPanel.add(new ComponentTitle("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438", (JComponent)this.executorList));
        BGButtonPanel actionPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M});
        actionPanel.addActionListener(actionEvent -> this.actionPanel_actionPerformed(actionEvent));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.execRequest();
            }
        });
        this.filterPanel.setLayout(new GridBagLayout());
        this.filterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        this.filterPanel.add((Component)listPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)rightFilterPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)actionPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.filterButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
        controlPanel.add((Component)this.total, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        controlPanel.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.historyViewer), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ClientUtils.setComboBoxSelection(this.sort1Combo, (Object)"open_dt DESC");
        ClientUtils.setComboBoxSelection(this.sort2Combo, (Object)"urgency DESC");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProblemManager.this.performAction("edit");
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = ProblemManager.this.table.getSelectedRow();
                Point p = e.getPoint();
                if (SwingUtilities.isRightMouseButton(e) && ProblemManager.this.rcMenu.isPopupTrigger(e) && index > -1) {
                    ProblemManager.this.initRcMenu();
                    if (ProblemManager.this.rcMenu.getComponentCount() > 0) {
                        ProblemManager.this.rcMenu.show(e.getComponent(), p.x, p.y);
                    }
                }
            }
        });
        this.historyViewer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ProblemManager.this.topPanel.setVisible(false);
            }
        });
        this.openContractListener = actionEvent -> this.openContract(actionEvent);
        this.groupList.getList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProblemManager.this.setExecutors();
            }
        });
        this.init();
    }

    private void initRcMenu() {
        this.rcMenu.removeAll();
        String callsStr = (String)this.table.getValueAt(this.table.getSelectedRow(), 0);
        if (callsStr != null && callsStr.length() > 0) {
            String[] calls = callsStr.split(";");
            for (int i = 0; i < calls.length; ++i) {
                String[] cid_title_code = calls[i].split(":");
                if (cid_title_code.length != 3) continue;
                JMenuItem item = new JMenuItem(cid_title_code[1]);
                item.setActionCommand(cid_title_code[0] + ":" + cid_title_code[1]);
                item.addActionListener(this.openContractListener);
                this.rcMenu.add(item);
            }
        }
        if (this.rcMenu.getComponentCount() > 0) {
            this.rcMenu.addSeparator();
        }
        JMenuItem hist = new JMenuItem("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        hist.setActionCommand("history");
        hist.addActionListener(e -> this.viewHistory());
        this.rcMenu.add(hist);
    }

    private void openContract(ActionEvent actionEvent) {
        String[] cid_title;
        String command = actionEvent.getActionCommand();
        if (command != null && (cid_title = command.split(":")).length == 2) {
            ClientUtils.openContract((int)Utils.parseInt((String)cid_title[0], (int)0));
        }
    }

    public void execRequest() {
        Request request = this.getRequest();
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                Element tableElement = XMLUtils.selectElement((Node)doc, (String)"/data/table");
                this.table.updateData((Node)tableElement);
                this.table.invalidate();
                this.pagePanel.setPageInfo(tableElement);
                this.total.setText("\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c: " + Page.getRecordCount((Element)tableElement));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private Request getRequest() {
        Request request = new Request().setModule(MODULE_ADMIN_REGISTER).setAction("RegisterProblemTable");
        if (this.problemID > 0) {
            request.setAttribute("id", this.problemID);
        } else {
            ClientSetup.getInstance().set("crm.problem.status.selected", this.statusList.getListValues());
            ClientSetup.getInstance().saveUserConfig();
            request.setPageIndex(0);
            request.setAttribute("group", this.groupList.getListValues());
            request.setAttribute("status", this.statusList.getListValues());
            request.setAttribute("executor", this.executorList.getListValues());
            if (this.openDateFilter_ChB.isSelected()) {
                request.setAttribute("open_date_mode", 1);
            }
            if (this.statusDateFilter_ChB.isSelected()) {
                request.setAttribute("status_date_mode", this.statusDateAND_RB.isSelected() ? 1 : 2);
            }
            if (this.closeDateFilter_ChB.isSelected()) {
                request.setAttribute("close_date_mode", this.closeDateAND_RB.isSelected() ? 1 : 2);
            }
            request.setAttribute("open_date1", this.openPeriod_P.getDateString1());
            request.setAttribute("open_date2", this.openPeriod_P.getDateString2());
            request.setAttribute("status_date1", this.statusPeriod_P.getDateString1());
            request.setAttribute("status_date2", this.statusPeriod_P.getDateString2());
            request.setAttribute("close_date1", this.closePeriod_P.getDateString1());
            request.setAttribute("close_date2", this.closePeriod_P.getDateString2());
            request.setAttribute("code", this.codeTF.getText());
            request.setAttribute("comment", this.commentTF.getText());
            request.setAttribute("sort1", ((ComboBoxItem)this.sort1Combo.getSelectedItem()).getObject());
            request.setAttribute("sort2", ((ComboBoxItem)this.sort2Combo.getSelectedItem()).getObject());
        }
        return request;
    }

    private void viewHistory() {
        int id = ClientUtils.getRowId((BGTable)this.table);
        if (id != 0) {
            this.historyViewer.setId(id);
            this.historyViewer.performAction("refresh");
            this.historyViewer.setVisible(true);
        }
    }

    private void actionPanel_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
            new HtmlPrinter(this.getHtml(), 800, 300);
        } else if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
            BGEmailDialog dialog = new BGEmailDialog();
            dialog.addPropertyChangeListener(evt -> {
                if (evt.getPropertyName().equals("selectEmail")) {
                    String email = String.valueOf(evt.getNewValue());
                    String subject = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0422\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3);
                    if (email != null && subject != null) {
                        Request request = this.getRequest().setAttribute("email", email).setAttribute("email_subject", subject).setAttribute("show_all", "1").setAttribute("contentType", "html");
                        if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                        this.saveUserEmail("crm.problem", email);
                    }
                }
            });
            dialog.setEmailList(ClientSetup.getInstance().getUserEmail(MODULE_ADMIN_REGISTER));
            dialog.setVisible(true);
        } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
            BGFileChooser fc = new BGFileChooser((Component)((Object)this));
            if (fc.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                try {
                    ClientUtils.saveHtmlFile((String)this.getHtml(), (File)fc.getSelectedFile());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } else if (BGButtonPanel.DO_M.getActionCommand().equals(actionCommand)) {
            this.saveFilter();
            this.pagePanel.init();
            this.execRequest();
        }
    }

    private void saveFilter() {
        Preferences userConfig = ClientSetup.getInstance().getUserConfig();
        userConfig.set("crm.problem.status.selected", this.statusList.getListValues());
        userConfig.set("crm.problem.group.selected", this.groupList.getListValues());
        userConfig.set("crm.problem.executor.selected", this.executorList.getListValues());
        userConfig.set("crm.problem.openDateFilter_ChB", String.valueOf(this.openDateFilter_ChB.isSelected()));
        userConfig.set("crm.problem.statusDateFilter_ChB", String.valueOf(this.statusDateFilter_ChB.isSelected()));
        userConfig.set("crm.problem.closeDateFilter_ChB", String.valueOf(this.closeDateFilter_ChB.isSelected()));
        userConfig.set("crm.problem.statusDateAND_RB", String.valueOf(this.statusDateAND_RB.isSelected()));
        userConfig.set("crm.problem.statusDateOR_RB", String.valueOf(this.statusDateOR_RB.isSelected()));
        userConfig.set("crm.problem.closeDateAND_RB", String.valueOf(this.closeDateAND_RB.isSelected()));
        userConfig.set("crm.problem.closeDateOR_RB", String.valueOf(this.closeDateOR_RB.isSelected()));
        userConfig.set("crm.problem.open_date1", this.openPeriod_P.getDateString1());
        userConfig.set("crm.problem.open_date2", this.openPeriod_P.getDateString2());
        userConfig.set("crm.problem.status_date1", this.statusPeriod_P.getDateString1());
        userConfig.set("crm.problem.status_date2", this.statusPeriod_P.getDateString2());
        userConfig.set("crm.problem.close_date1", this.closePeriod_P.getDateString1());
        userConfig.set("crm.problem.close_date2", this.closePeriod_P.getDateString2());
        userConfig.set("crm.problem.code", this.codeTF.getText());
        userConfig.set("crm.problem.comment", this.commentTF.getText());
        userConfig.set("crm.problem.sort1.selected", String.valueOf(((ComboBoxItem)this.sort1Combo.getSelectedItem()).getObject()));
        userConfig.set("crm.problem.sort2.selected", String.valueOf(((ComboBoxItem)this.sort2Combo.getSelectedItem()).getObject()));
        ClientSetup.getInstance().saveUserConfig();
    }

    private void loadFilter() {
        Preferences userConfig = ClientSetup.getInstance().getUserConfig();
        this.statusList.setListValues(userConfig.get("crm.problem.status.selected", ""));
        this.groupList.setListValues(userConfig.get("crm.problem.group.selected", ""));
        this.setExecutors();
        this.executorList.setListValues(userConfig.get("crm.problem.executor.selected", ""));
        this.openDateFilter_ChB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.openDateFilter_ChB", "false")));
        this.statusDateFilter_ChB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.statusDateFilter_ChB", "false")));
        this.closeDateFilter_ChB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.closeDateFilter_ChB", "false")));
        this.statusDateAND_RB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.statusDateAND_RB", "false")));
        this.statusDateOR_RB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.statusDateOR_RB", "false")));
        this.closeDateAND_RB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.closeDateAND_RB", "false")));
        this.closeDateOR_RB.setSelected(Boolean.valueOf(userConfig.get("crm.problem.closeDateOR_RB", "false")));
        this.openPeriod_P.setDateString1(userConfig.get("crm.problem.open_date1", ""));
        this.openPeriod_P.setDateString2(userConfig.get("crm.problem.open_date2", ""));
        this.statusPeriod_P.setDateString1(userConfig.get("crm.problem.status_date1", ""));
        this.statusPeriod_P.setDateString2(userConfig.get("crm.problem.status_date2", ""));
        this.closePeriod_P.setDateString1(userConfig.get("crm.problem.close_date1", ""));
        this.closePeriod_P.setDateString2(userConfig.get("crm.problem.close_date2", ""));
        this.codeTF.setText(userConfig.get("crm.problem.code", ""));
        this.commentTF.setText(userConfig.get("crm.problem.comment", ""));
        ClientUtils.setComboBoxSelection(this.sort1Combo, (Object)userConfig.get("crm.problem.sort1.selected", ""));
        ClientUtils.setComboBoxSelection(this.sort2Combo, (Object)userConfig.get("crm.problem.sort2.selected", ""));
    }

    private String getHtml() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "html");
        request.setPageIndex(-1);
        String result = "<html>\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u0440\u0438\u0448\u0435\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430</html>";
        try {
            result = TransferManager.getString((Request)request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void updateForId(int id) {
        this.problemID = id;
        this.execRequest();
        this.problemID = 0;
    }

    private void buildSortCombo(JComboBox<ComboBoxItem> combo) {
        combo.addItem(new ComboBoxItem((Object)"", "-"));
        combo.addItem(new ComboBoxItem((Object)"urgency", "\u0441\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c"));
        combo.addItem(new ComboBoxItem((Object)"urgency DESC", "\u0441\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u0440."));
        combo.addItem(new ComboBoxItem((Object)"open_dt", "\u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043a\u0440."));
        combo.addItem(new ComboBoxItem((Object)"open_dt DESC", "\u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043a\u0440. \u043e\u0431\u0440."));
    }

    protected void setExecutors() {
        this.tryCall(() -> {
            if (this.getContext() == null) {
                return;
            }
            String executors = this.executorList.getListValues();
            this.executorList.getList().setData(ClientUtils.toBGUListItemList((List)((CRMService)((ClientContext)this.getContext()).getWebService(CRMService.class)).registerExecutorList(this.groupList.getListIds())));
            this.executorList.setListValues(executors);
        });
    }

    private List<IdTitle> getStatusItems() {
        if (this.statusItems == null) {
            Async s = Async.of(() -> ((CRMService)((ClientContext)this.getContext()).getWebService(CRMService.class)).registerStatusItems(RegisterObjectType.PROBLEM));
            this.statusItems = (List)s.get();
        }
        return this.statusItems;
    }

    private List<IdTitle> getGroupItems() {
        if (this.groupItems == null) {
            Async g = Async.of(() -> ((CRMService)((ClientContext)this.getContext()).getWebService(CRMService.class)).registerGroupItems(0));
            this.groupItems = (List)g.get();
        }
        return this.groupItems;
    }

    private void initStatusAndGroup() {
        if (this.getContext() != null) {
            this.statusList.getList().setData(ClientUtils.toBGUListItemList(this.getStatusItems()));
            this.groupList.getList().setData(ClientUtils.toBGUListItemList(this.getGroupItems()));
            this.loadFilter();
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.execRequest());
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.initEditer();
            RegisterProblem registerProblem = new RegisterProblem();
            registerProblem.setId(-1);
            new ProblemEditorDialog("\u041d\u043e\u0432\u0430\u044f \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430", registerProblem, false).open();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            int id = ClientUtils.getRowId((BGTable)this.table);
            if (id != 0) {
                this.initEditer();
                this.historyViewer.setVisible(false);
                RegisterProblem registerProblem = new RegisterProblem();
                registerProblem.setId(id);
                new ProblemEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b", registerProblem, false).open();
            }
        });
    }

    void initEditer() {
        this.setExecutors();
        this.statusDateAND_RB.setSelected(true);
        this.closeDateAND_RB.setSelected(true);
    }

    class ComponentTitle
    extends JPanel {
        public ComponentTitle(String title, JComponent component) {
            super(new GridBagLayout());
            this.add((Component)new JLabel(title), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    class ProblemEditorDialog
    extends BGEditorDialog<RegisterProblem> {
        private boolean historyMode;
        private BGTextArea calls;
        private BGTextArea comment;
        private BGTextArea resolution_TA;
        private BGUComboBox<IdTitle> status;
        private BGUComboBox<IdTitle> urgency;
        private BGUComboBox<IdTitle> group;
        private BGUComboBox<IdTitle> category;
        private BGControlPanelListSelect executors_L;
        private DefaultListModel<BGUListItem> usedGroupsModel;
        private JList<BGUListItem> usedGroups;
        private DefaultListModel<BGUListItem> taskModel;
        private JList<BGUListItem> taskList;
        private JCheckBox toEmail;
        private JCheckBox printOrder;
        private boolean initGroup;
        private boolean initCall;
        private boolean initTask;
        List<IdTitle> urgencyItems;

        public ProblemEditorDialog(String title, RegisterProblem data, boolean historyMode) {
            super(title, (Object)data);
            this.historyMode = false;
            this.calls = new BGTextArea(10, 70);
            this.comment = new BGTextArea(10, 70);
            this.resolution_TA = new BGTextArea(10, 70);
            this.status = new BGUComboBox();
            this.urgency = new BGUComboBox();
            this.group = new BGUComboBox();
            this.category = new BGUComboBox();
            this.executors_L = new BGControlPanelListSelect(5);
            this.usedGroupsModel = new DefaultListModel();
            this.usedGroups = new JList<BGUListItem>(this.usedGroupsModel);
            this.taskModel = new DefaultListModel();
            this.taskList = new JList<BGUListItem>(this.taskModel);
            this.toEmail = new JCheckBox("\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430 Email");
            this.printOrder = new JCheckBox("p\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
            this.initGroup = false;
            this.initCall = false;
            this.initTask = false;
            this.urgencyItems = Arrays.asList(new IdTitle(-2, "\u043d\u0438\u0437\u043a\u0430\u044f [-2]"), new IdTitle(-1, "\u043f\u043e\u043d\u0438\u0436\u0435\u043d\u043d\u0430\u044f [-1]"), new IdTitle(0, "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u0430\u044f [0]"), new IdTitle(1, "\u043f\u043e\u0432\u044b\u0448\u0435\u043d\u043d\u0430\u044f [1]"), new IdTitle(2, "\u0432\u044b\u0441\u043e\u043a\u0430\u044f [2]"));
            this.historyMode = historyMode;
        }

        public void doDialogPanel() {
            Request request;
            Document doc;
            this.calls.setFont(new Font("Dialog", 0, 14));
            this.calls.setEditable(false);
            this.usedGroups.setEnabled(!this.historyMode);
            this.executors_L.setEnabled(!this.historyMode);
            this.taskList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ProblemEditorDialog.this.showTask();
                    }
                }
            });
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", this.getGeneralPanel());
            tabbedPane.add("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438", (Component)this.executors_L);
            tabbedPane.add("\u0423\u0447\u0430\u0441\u0442\u0432\u043e\u0432\u0430\u0432\u0448\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", new JScrollPane(this.usedGroups));
            tabbedPane.add("\u0417\u0432\u043e\u043d\u043a\u0438", new JScrollPane((Component)this.calls));
            tabbedPane.add("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", new JScrollPane(this.taskList));
            tabbedPane.addChangeListener(e -> this.changeTab(tabbedPane.getSelectedIndex()));
            this.panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getEmailPrintPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            ArrayList<IdTitle> groupItems = new ArrayList<IdTitle>();
            groupItems.add(new IdTitle(-1, "-----"));
            groupItems.addAll(ProblemManager.this.getGroupItems());
            this.group.setData(groupItems);
            ArrayList<IdTitle> categoryItems = new ArrayList<IdTitle>();
            try {
                categoryItems.add(IdTitle.NO_SELECT);
                categoryItems.addAll(((CRMService)((ClientContext)ProblemManager.this.getContext()).getWebService(CRMService.class)).registerCategoryItems());
                this.category.setData(categoryItems);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.status.setData(ProblemManager.this.getStatusItems());
            this.urgency.setData(this.urgencyItems);
            if (((RegisterProblem)this.data).getId() > -1 && ClientUtils.checkStatus((Document)(doc = TransferManager.getDocument((Request)(request = new Request().setModule(ProblemManager.MODULE_ADMIN_REGISTER).setAction("GetRegisterProblem").setAttribute("id", ((RegisterProblem)this.data).getId()).setAttribute("historymode", this.historyMode).setAttribute("time", null)))))) {
                this.tryCall(() -> {
                    Element register_item = XMLUtils.selectElement((Node)doc, (String)"//problem");
                    if (register_item != null) {
                        ((RegisterProblem)this.data).setComment(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//comment")));
                        ((RegisterProblem)this.data).setResolution(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//resolution")));
                        ((RegisterProblem)this.data).setStatus(Utils.parseInt((String)register_item.getAttribute("status")));
                        ((RegisterProblem)this.data).setUrgency(Utils.parseInt((String)register_item.getAttribute("urgency")));
                        ((RegisterProblem)this.data).setGroupId(Utils.parseInt((String)register_item.getAttribute("group")));
                        ((RegisterProblem)this.data).setCategoryId(Utils.parseInt((String)register_item.getAttribute("category")));
                        ((RegisterProblem)this.data).setExecutors(Utils.toList((String)register_item.getAttribute("executors")));
                        this.executors_L.setListValues(Utils.toString((Iterable)((RegisterProblem)this.data).getExecutors()));
                    }
                });
            }
            this.status.setSelectedItem((Object)ProblemManager.this.getStatusItems().stream().filter(a -> a.getId() == ((RegisterProblem)this.data).getStatus()).findFirst().orElse(ProblemManager.this.getStatusItems().get(0)));
            this.urgency.setSelectedItem((Object)this.urgencyItems.stream().filter(a -> a.getId() == ((RegisterProblem)this.data).getUrgency()).findFirst().orElse(this.urgencyItems.get(3)));
            this.group.setSelectedItem((Object)groupItems.stream().filter(a -> a.getId() == ((RegisterProblem)this.data).getGroupId()).findFirst().orElse((IdTitle)groupItems.get(0)));
            this.category.setSelectedItem((Object)categoryItems.stream().filter(a -> a.getId() == ((RegisterProblem)this.data).getCategoryId()).findFirst().orElse((IdTitle)categoryItems.get(0)));
            this.comment.setText(((RegisterProblem)this.data).getComment());
            this.resolution_TA.setText(((RegisterProblem)this.data).getResolution());
        }

        public boolean doApply() throws Exception {
            int statusId = ((IdTitle)this.status.getSelectedItem()).getId();
            int categoryId = ((IdTitle)this.category.getSelectedItem()).getId();
            if (statusId == 2 && categoryId == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b!");
                return false;
            }
            ((RegisterProblem)this.data).setStatus(statusId);
            ((RegisterProblem)this.data).setCategoryId(categoryId);
            ((RegisterProblem)this.data).setResolution(this.resolution_TA.getText());
            ((RegisterProblem)this.data).setUrgency(((IdTitle)this.urgency.getSelectedItem()).getId());
            ((RegisterProblem)this.data).setComment(this.comment.getText());
            ((RegisterProblem)this.data).setGroupId(((IdTitle)this.group.getSelectedItem()).getId());
            Request request = new Request().setModule(ProblemManager.MODULE_ADMIN_REGISTER).setAction("UpdateRegisterProblem").setAttribute("id", ((RegisterProblem)this.data).getId()).setAttribute("status", ((RegisterProblem)this.data).getStatus()).setAttribute("category", ((RegisterProblem)this.data).getCategoryId()).setAttribute("group", ((RegisterProblem)this.data).getGroupId()).setAttribute("urgency", ((RegisterProblem)this.data).getUrgency()).setAttribute("comment", ((RegisterProblem)this.data).getComment()).setAttribute("resolution", ((RegisterProblem)this.data).getResolution()).setAttribute("executors", this.executors_L.getListValues()).setAttribute("send.mail", this.toEmail.isSelected() ? "1" : "0");
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                if (this.printOrder.isSelected()) {
                    int id = ((RegisterProblem)this.data).getId();
                    if (((RegisterProblem)this.data).getId() == -1) {
                        id = Utils.parseInt((String)XMLUtils.selectElement((Node)doc, (String)"//problem").getAttribute("id"));
                    }
                    Request request1 = new Request().setModule(ProblemManager.MODULE_ADMIN_REGISTER).setAction("PrintRegisterProblemOrder").setAttribute("id", id).setAttribute("contentType", "html");
                    this.tryCall(() -> new HtmlPrinter(TransferManager.getString((Request)request1), 800, 600));
                }
                ProblemManager.this.execRequest();
                return true;
            }
            return false;
        }

        private JPanel getGeneralPanel() {
            this.resolution_TA.setEditable(!this.historyMode);
            this.comment.setEditable(!this.historyMode);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getGeneralTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0425\u043e\u0434 \u0440\u0435\u0448\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.resolution_TA), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getGeneralTopPanel() {
            this.status.setEnabled(!this.historyMode);
            this.urgency.setEnabled(!this.historyMode);
            this.group.setEnabled(!this.historyMode);
            this.category.setEnabled(!this.historyMode);
            this.group.addActionListener(actionEvent -> this.tryCall(() -> {
                this.executors_L.getList().setData(ClientUtils.toBGUListItemList((List)((CRMService)((ClientContext)ProblemManager.this.getContext()).getWebService(CRMService.class, 0)).registerExecutorItems(Arrays.asList(((IdTitle)this.group.getSelectedItem()).getId()))));
                this.executors_L.setListValues(Utils.toString((Iterable)((RegisterProblem)this.data).getExecutors()));
            }));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.status, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.urgency, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.group, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.category, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 10, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getEmailPrintPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.toEmail, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.printOrder, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private void showTask() {
            BGServiceConfig serviceConfig = (BGServiceConfig)BGClientBase.getFrame().getTabbedPane().addTab(ActionConfig.class.getName(), BGServiceConfig.class);
            BGUListItem item = this.taskList.getSelectedValue();
            serviceConfig.selectTab(TaskManager.class.getName());
            TaskManager taskManager = (TaskManager)serviceConfig.getTab(TaskManager.class);
            if (String.valueOf(item.getAttribute("id")).startsWith("new:")) {
                String id = String.valueOf(item.getAttribute("id")).split(":")[1];
                taskManager.setContractId(Integer.valueOf(id));
                taskManager.setProblemId(((RegisterProblem)this.data).getId());
                taskManager.setOpenFrom(true);
                taskManager.performAction("new");
            } else {
                taskManager.updateForId(String.valueOf(item.getAttribute("id")));
            }
        }

        private void changeTab(int tabIndex) {
            try {
                if (tabIndex == 2 && !this.initGroup) {
                    this.usedGroupsModel.clear();
                    ((CRMService)((ClientContext)ProblemManager.this.getContext()).getWebService(CRMService.class, 0)).registerProblemUsedGroups(((RegisterProblem)this.data).getId()).forEach(a -> this.usedGroupsModel.addElement(new BGUListItem(a.getId(), a.getTitle())));
                    this.initGroup = true;
                } else if (tabIndex == 3 && !this.initCall) {
                    this.calls.setText(((CRMService)((ClientContext)ProblemManager.this.getContext()).getWebService(CRMService.class, 0)).registerProblemCalls(((RegisterProblem)this.data).getId()));
                    this.initCall = true;
                } else if (tabIndex == 4 && !this.initTask) {
                    this.taskModel.clear();
                    ((CRMService)((ClientContext)ProblemManager.this.getContext()).getWebService(CRMService.class, 0)).registerProblemTasks(((RegisterProblem)this.data).getId()).forEach(a -> {
                        BGUListItem item = new BGUListItem();
                        item.setAttribute("key", (Object)a.getKey());
                        item.setAttribute("value", (Object)a.getValue());
                        this.taskModel.addElement(item);
                    });
                    this.initTask = true;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }
}

