/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Calendar;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionCardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionViewCardAction
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", 0);
        if (id <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        DealerManager dealerManager = new DealerManager(this.con, this.mid);
        CardActionManager actionManager = new CardActionManager(this.con, this.mid);
        CardActionCardManager actionCardManager = new CardActionCardManager(this.con, this.mid);
        CardAction action = actionManager.getActionById(id);
        if (action == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0430  \u0441 \u043a\u043e\u0434\u043e\u043c " + id);
        }
        Dealer dealer = dealerManager.getDealer(action.getDealerId());
        if (dealer == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u0438\u043b\u0435\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + action.getDealerId());
        }
        StringBuilder cardSerials = new StringBuilder(1000);
        Long lastSerial = null;
        boolean needClose = false;
        for (Long serial : actionCardManager.getCards(action.getId())) {
            if (lastSerial == null) {
                cardSerials.append(serial);
            } else if (serial != lastSerial + 1L) {
                cardSerials.append("-");
                cardSerials.append(lastSerial);
                cardSerials.append(";");
                cardSerials.append(serial);
                needClose = false;
            } else {
                needClose = true;
            }
            lastSerial = serial;
        }
        if (needClose) {
            cardSerials.append("-");
            cardSerials.append(lastSerial);
        }
        Document doc = XMLUtils.newDocument();
        Element dataEl = doc.createElement("data");
        doc.appendChild(dataEl);
        dataEl.setAttribute("current_user", UserMap.getUser((Integer)this.userId).getName());
        Element dealerEl = XMLUtils.createElement((Element)dataEl, (String)"dealer");
        dealerEl.setAttribute("title", dealer.getTitle());
        dealerEl.setAttribute("contract_card", dealer.getCardContract());
        Element actionEl = XMLUtils.createElement((Element)dataEl, (String)"action");
        actionEl.setAttribute("id", String.valueOf(action.getId()));
        actionEl.setAttribute("date", TimeUtils.formatDate((Calendar)action.getTime()));
        actionEl.setAttribute("type", String.valueOf(action.getType()));
        actionEl.setAttribute("count", String.valueOf(action.getCardCount()));
        actionEl.setAttribute("summ", Utils.formatCost((float)action.getCardSumma()));
        actionEl.setAttribute("cost", Utils.formatCost((float)action.getCost()));
        actionEl.setAttribute("serials", cardSerials.toString());
        Element cardsEl = XMLUtils.createElement((Element)dataEl, (String)"cards");
        for (Map.Entry<Float, Integer> entry : actionCardManager.getCostGroups(action.getId()).entrySet()) {
            Element groupEl = XMLUtils.createElement((Element)cardsEl, (String)"group");
            groupEl.setAttribute("cost", Utils.formatCost((float)entry.getKey().floatValue()));
            groupEl.setAttribute("count", String.valueOf(entry.getValue()));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(XMLUtils.serializeToString((Node)doc, (boolean)false));
        }
        XSLManager.getInstance().transform((Source)new DOMSource(doc), "card_action_pdf.xsl", (Node)this.rootNode);
    }
}

