package ru.bitel.bgbilling.modules.voice.dyn.mediator.md;

import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MX96Mediator
    extends MDBaseMediator
{
    protected int getColumns()
    {
        return 9;
    }

    protected VoiceRecord processLine( final VoiceRecordProcessor processor, final String[] params )
        throws InterruptedException
    {
        if ( skipLine( params[4] ) )
        {
            return null;
        }
        VoiceRecord record = processor.next();
        record.sessionStart = TimeUtils.parseDate( params[0], "dd.MM.yyyy HH:mm:ss" );
        record.connectionDuration = Utils.parseInt( params[1], 0 );
        record.duration = Utils.parseInt( params[6], 0 );
        record.callingStationId = params[2].replaceAll( "[^0-9]*", "" );
        record.e164CallingStationId = callingStationIdToE164( params[3] );
        record.calledStationId = params[4].replaceAll( "[^0-9]*", "" );
        record.e164CalledStationId = calledStationIdToE164( params[5] );
        record.trunkIncoming = params[6];
        record.trunkOutgoing = params[7];
        return record;
    }
}
