/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.ViewUploadFilesConfigurator;
import ru.bitel.common.Utils;

public class ViewUploadedSormFile {
    private static final int FILE_SIZE_LIMIT = 100;
    public static final int CONSOLE_MODE = 1;
    public static final int UI_MODE = 2;
    private final Path pathToFile;
    private int limit;
    private Charset charset = StandardCharsets.UTF_8;
    private int mode = 2;
    private boolean firstStringIsTitle = false;
    private boolean fieldsWithName = false;
    private final int printOrientation;

    public ViewUploadedSormFile(ViewUploadFilesConfigurator configurator) {
        this.pathToFile = Paths.get(configurator.getPathToFile(), new String[0]);
        this.printOrientation = configurator.getPrintOrientation();
        this.limit = configurator.getProcessedLineLimit();
        SormProject sormProject = configurator.getSormProject();
        if (sormProject != null) {
            SormManufacturer manufacturer = SormManufacturer.getType((int)sormProject.getProjectType());
            if (manufacturer == SormManufacturer.MFISOFT || manufacturer == SormManufacturer.SPECIALTECHNOLOGY) {
                this.firstStringIsTitle = true;
                if (this.limit > 0) {
                    ++this.limit;
                }
                if (configurator.isShowFieldTitles()) {
                    this.setFieldsWithName(true);
                }
            }
            if (this.pathToFile.toString().endsWith(".csv") && manufacturer.equals((Object)SormManufacturer.NORSITRANS)) {
                this.charset = Charset.forName("windows-1251");
            }
        }
    }

    public List<String> processed() throws BGException {
        if (this.pathToFile == null) {
            throw new BGException("\u041f\u0443\u0442\u044c \u0434\u043e \u0444\u0430\u0439\u043b\u0430 == null");
        }
        if (!Files.exists(this.pathToFile, new LinkOption[0])) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b \u043f\u043e \u043f\u0443\u0442\u0438: " + String.valueOf(this.pathToFile));
        }
        try {
            long maxSizeBytes = 0x6400000L;
            if (Files.size(this.pathToFile) > maxSizeBytes) {
                throw new BGException(String.format("\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043b\u0438\u043c\u0438\u0442 \u0432 %s \u041c\u0411", 100));
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        List<String> result = this.processed0();
        if (this.mode == 1) {
            result.forEach(System.out::println);
        }
        return result;
    }

    private List<String> processed0() throws BGException {
        List<String> lines;
        ArrayList<String> result = new ArrayList<String>();
        try {
            lines = this.readAllLines(this.charset);
            if (Utils.isEmptyCollection(lines)) {
                throw new BGException("\u0412 \u0444\u0430\u0439\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a");
            }
        }
        catch (IOException ex) {
            try {
                lines = this.readAllLines(StandardCharsets.UTF_8);
                if (Utils.isEmptyCollection(lines)) {
                    throw new BGException("\u0412 \u0444\u0430\u0439\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a");
                }
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        String[] fieldNames = null;
        if (this.fieldsWithName) {
            fieldNames = lines.get(0).split(";");
        }
        if (this.firstStringIsTitle) {
            lines.remove(0);
        }
        if (this.limit > 0 && this.limit < lines.size()) {
            this.trimToLimit(lines);
        }
        for (int x = 0; x < lines.size(); ++x) {
            result.addAll(this.processingLine(lines.get(x), fieldNames, x));
        }
        return result;
    }

    private List<String> readAllLines(Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.pathToFile.toFile()), charset));){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private void trimToLimit(List<String> lines) {
        int x;
        ArrayList<String> afterLimit = new ArrayList<String>(this.limit);
        int n = x = this.firstStringIsTitle ? 1 : 0;
        while (x < this.limit) {
            afterLimit.add(lines.get(x));
            ++x;
        }
        lines.clear();
        lines.addAll(afterLimit);
        ((ArrayList)lines).trimToSize();
    }

    private List<String> processingLine(String line, String[] fieldNames, int stringNumber) {
        String[] mas = line.split(";");
        int capacity = this.printOrientation == 1 ? mas.length : 1;
        ArrayList<String> result = new ArrayList<String>(capacity);
        if (this.printOrientation == 1) {
            result.addAll(this.processingForVerticalPrinting(mas, fieldNames, stringNumber));
        } else {
            result.add(this.processingForHorizontalPrint(mas, fieldNames, stringNumber));
        }
        return result;
    }

    private List<String> processingForVerticalPrinting(String[] mas, String[] fieldNames, int stringNumber) {
        ArrayList<String> result = new ArrayList<String>(mas.length);
        result.add("[" + stringNumber + "]");
        for (int x = 0; x < mas.length; ++x) {
            result.add(x + ") " + this.getFieldName(fieldNames, x) + mas[x]);
        }
        result.add("\n");
        return result;
    }

    private String processingForHorizontalPrint(String[] mas, String[] fieldNames, int stringNumber) {
        StringBuilder result = new StringBuilder();
        result.append("[").append(stringNumber).append("]").append("\n");
        for (int x = 0; x < mas.length; ++x) {
            result.append(x).append(") ").append(this.getFieldName(fieldNames, x)).append(mas[x]).append(" ");
        }
        result.append("\n");
        return result.toString();
    }

    private String getFieldName(String[] fieldNames, int index) {
        Object fieldName = "";
        if (fieldNames != null && index < fieldNames.length) {
            fieldName = fieldNames[index];
        }
        if (((String)fieldName).length() > 0) {
            fieldName = (String)fieldName + "=";
        }
        return fieldName;
    }

    public void setFieldsWithName(boolean fieldsWithName) {
        this.fieldsWithName = fieldsWithName;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

