/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.signaltek;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.util.SubnetUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.AbstractBalanceBean;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.Directional;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.signaltek.SignaltekPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.signaltek.SignaltekFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class SignaltekUpload
extends Upload {
    protected final List<ServiceSorm> services = new ArrayList<ServiceSorm>();
    protected final Map<Integer, ServiceSorm> inetServices = new HashMap<Integer, ServiceSorm>();
    protected final Map<Integer, ServiceSorm> phoneServices = new HashMap<Integer, ServiceSorm>();
    protected final String regionId = this.config.get("sorm.upload.regionid", "1");

    public SignaltekUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
        this.prepareServices();
    }

    protected void prepareServices() {
        logger.debug("\u0421\u043f\u0435\u0446.\u0422\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u0438 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430 \u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438");
        this.services.addAll(SormUtils.getSelectedServicesForUpload(this.config));
        for (ServiceSorm serviceSorm : this.services) {
            if (serviceSorm.isInetServiceType()) {
                this.inetServices.put(serviceSorm.getId(), serviceSorm);
            }
            if (!serviceSorm.isPhoneServiceType()) continue;
            this.phoneServices.put(serviceSorm.getId(), serviceSorm);
        }
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438 \u0441 \u0443\u0441\u043b\u0443\u0433\u0430\u043c\u0438. \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442=" + this.inetServices.size() + ", \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f=" + this.phoneServices.size());
    }

    @Override
    public Path abonents() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.ABONENTS.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            String[] internalItem;
            List<InternalUser> internalUserList;
            String[] item;
            int status;
            csvFile.writeNext(new String[]{"telco_id", "id", "idents_identifier_type", "idents_pager_identifier", "idents_pstn_directory_number", "idents_pstn_internal_number", "idents_gsm_directory_number", "idents_gsm_imsi", "idents_gsm_imei", "idents_gsm_icc", "idents_cdma_directory_number", "idents_cdma_imsi", "idents_cdma_icc", "idents_cdma_esn", "idents_cdma_min", "idents_network_user_equipment_type", "idents_network_user_equipment_mac", "idents_network_user_equipment_vpi", "idents_network_user_equipment_vci", "idents_network_login", "idents_network_ip_address", "idents_network_email", "idents_network_pin", "idents_network_phone_number", "idents_network_user_domain", "idents_network_reserved", "idents_voip_ip_address", "idents_voip_originator_name", "idents_voip_calling_number", "contract_date", "contract", "actual_from", "actual_to", "status", "attach", "detach", "standard", "abonent_type", "person_given_name", "person_initial", "person_family_name", "person_birth_date", "person_doc_type_id", "person_ident_card_serial", "person_ident_card_number", "person_ident_card_description", "organization_full_name", "organization_inn", "organization_contact", "organization_phone_fax", "organization_internal_users", "organization_internal_numbers", "bank", "bank_account", "last_location_date", "last_location_type", "last_location_mobile_lac", "last_location_mobile_cell", "last_location_mobile_ta", "last_location_wireless_cell", "last_location_wireless_mac", "last_location_geolocation_latitude_grade", "last_location_geolocation_longitude_grade", "last_location_geolocation_projection_type", "last_location_iplocation_ip_address", "last_location_iplocation_ip_port", "address_registered_zip", "address_registered_country", "address_registered_region", "address_registered_zone", "address_registered_city", "address_registered_street", "address_registered_building", "address_registered_build_sect", "address_registered_apartment", "address_invoice_zip", "address_invoice_country", "address_invoice_region", "address_invoice_zone", "address_invoice_city", "address_invoice_street", "address_invoice_building", "address_invoice_build_sect", "address_invoice_apartment", "address_postal_zip", "address_postal_country", "address_postal_region", "address_postal_zone", "address_postal_city", "address_postal_street", "address_postal_building", "address_postal_build_sect", "address_postal_apartment", "address_device_zip", "address_device_country", "address_device_region", "address_device_zone", "address_device_city", "address_device_street", "address_device_building", "address_device_build_sect", "address_device_apartment"});
            List<IdTitle> documentTypes = SormUtils.getDocumentsTypes(this.config, this.cpm);
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
                for (SormContract contract : this.contracts) {
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getContractId();
                    List<InetServ> abonentInetServices = abonentServices.get(cid);
                    if (Utils.isEmptyCollection(abonentInetServices)) continue;
                    for (InetServ inetServ : abonentInetServices) {
                        try {
                            String ipv4 = this.getIPAddressByInetServ(inetServ);
                            String vlan = inetServ.getVlan() > 0 ? String.valueOf(inetServ.getVlan()) : "";
                            status = inetServ.getDateTo() != null && inetServ.getDateTo().before(new java.util.Date()) ? 0 : 1;
                            item = this.getAbonentItem(contract, "4", null, vlan, inetServ.getLogin(), ipv4, inetServ.getDateFrom(), inetServ.getDateTo(), documentTypes, status, this.getDeviceAddressByAttributes(inetServ.getEntityAttributes()), String.valueOf(inetServ.getId()));
                            this.writeItemToFile(item, cid, SignaltekFileTitle.ABONENTS.getTitle(), csvFile);
                            if (contract.isFiz()) continue;
                            internalUserList = SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config);
                            for (InternalUser internalUser : internalUserList) {
                                internalItem = this.getInternalAbonentItem(item, internalUser);
                                this.writeItemToFile(internalItem, cid, SignaltekFileTitle.ABONENTS.getTitle(), csvFile);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + cid + " \u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf(ex));
                        }
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                List<Integer> voiceMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE.getTitleModule());
                if (Utils.notEmptyCollection(voiceMids) && logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Voice");
                }
                for (Integer voiceMid : voiceMids) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    for (SormContract contract : this.contracts) {
                        for (VoiceAccount account : accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()))) {
                            String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                            status = account.getDateTo() != null && account.getDateTo().before(new java.util.Date()) ? 0 : 1;
                            item = this.getAbonentItem(contract, "1", number, null, account.getLogin(), null, account.getDateFrom(), account.getDateTo(), documentTypes, status, this.getDeviceAddressByAttributes(account.getEntityAttributes()), "");
                            this.writeItemToFile(item, contract.getContractId(), VasexpertFileTitle.ABONENTS.getTitle(), csvFile);
                            if (contract.isFiz()) continue;
                            internalUserList = SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config);
                            for (InternalUser internalUser : internalUserList) {
                                internalItem = this.getInternalAbonentItem(item, internalUser);
                                this.writeItemToFile(internalItem, contract.getContractId(), SignaltekFileTitle.ABONENTS.getTitle(), csvFile);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    private EntityAttrAddress getDeviceAddressByAttributes(Map<Integer, EntityAttr> entityAttributes) {
        EntityAttrAddress address = null;
        if (entityAttributes != null && !entityAttributes.isEmpty()) {
            for (EntityAttr attr : entityAttributes.values()) {
                if (!(attr instanceof EntityAttrAddress)) continue;
                address = (EntityAttrAddress)attr;
                break;
            }
        }
        return address;
    }

    private String[] getAbonentItem(SormContract contract, String identType, String phoneNumber, String vlan, String login, String ipv4, java.util.Date dateFrom, java.util.Date dateTo, List<IdTitle> documentTypes, int status, EntityAttrAddress deviceAddress, String identificator) throws Exception {
        String zone;
        String region;
        int cid = contract.getContractId();
        String[] item = new String[102];
        item[0] = this.regionId;
        item[1] = String.valueOf(cid);
        item[2] = identType;
        item[3] = "";
        item[4] = Utils.maskBlank((String)phoneNumber, (String)"");
        item[5] = "";
        item[6] = "";
        item[7] = "";
        item[8] = "";
        item[9] = "";
        item[10] = "";
        item[11] = "";
        item[12] = "";
        item[13] = "";
        item[14] = "";
        item[15] = "";
        item[16] = "";
        item[17] = Utils.maskBlank((String)vlan, (String)"");
        item[18] = "";
        String login0 = Utils.isBlankString((String)login) ? Utils.maskBlank((String)ipv4, (String)"") : "";
        item[19] = Utils.maskBlank((String)login0, (String)identificator);
        item[20] = Utils.maskBlank((String)ipv4, (String)"");
        item[21] = "";
        item[22] = "";
        item[23] = "";
        item[24] = "";
        item[25] = "";
        item[26] = "";
        item[27] = "";
        item[28] = "";
        item[29] = contract.getDateFrom() == null ? "" : TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
        item[30] = contract.getContractTitle();
        item[31] = TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
        item[32] = contract.getDateTo() != null && status == 1 ? TimeUtils.format((java.util.Date)contract.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "2037-01-01 00:00:00";
        item[33] = String.valueOf(status);
        item[34] = dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
        item[35] = status == 0 && dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "";
        item[36] = "";
        item[37] = contract.isFiz() ? "0" : "1";
        item[38] = contract.isFiz() ? this.helper.getFirstName() : "";
        item[39] = contract.isFiz() ? this.helper.getMiddleName() : "";
        item[40] = contract.isFiz() ? this.helper.getLastName() : "";
        item[41] = contract.isFiz() ? this.helper.getBirthday("yyyy-MM-dd") : "";
        item[42] = contract.isFiz() ? String.valueOf(SormUtils.getDocumentTypeIdOfContract(this.config, this.contractDao, cid, documentTypes)) : "";
        item[43] = contract.isFiz() ? this.helper.getDocumentSerial() : "";
        item[44] = contract.isFiz() ? this.helper.getDocumentNumber() : "";
        item[45] = contract.isFiz() ? this.helper.getDocumentWhenGive("yyyy-MM-dd") + " " + this.helper.getDocumentWhoGive() : "";
        item[46] = contract.isFiz() ? "" : this.helper.getFullTitleOrg();
        item[47] = contract.isFiz() ? "" : this.helper.getINN();
        item[48] = contract.isFiz() ? "" : this.helper.getStringParam("sorm.upload.org.contactface").trim();
        item[49] = contract.isFiz() ? "" : this.helper.getContactFacePhone();
        item[50] = "";
        item[51] = "";
        item[52] = this.helper.getBankTitle();
        item[53] = this.helper.getBankAccount();
        item[54] = "";
        item[55] = "";
        item[56] = "";
        item[57] = "";
        item[58] = "";
        item[59] = "";
        item[60] = "";
        item[61] = "";
        item[62] = "";
        item[63] = "";
        item[64] = "";
        item[65] = "";
        AddressStruct addressStruct = this.helper.getAddress();
        if (!SormUtils.checkValidAddress(addressStruct)) {
            logger.error("\u041d\u0435\u0442 \u0430\u0434\u0440\u0435\u0441\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 \u0441\u0447\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ID=" + cid);
        } else {
            region = SormUtils.getParameterOfCity((Upload)this, addressStruct, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, addressStruct, "zone");
            item[66] = addressStruct.getIndex();
            item[67] = addressStruct.getCountry();
            item[68] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[69] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[70] = addressStruct.getCity();
            item[71] = addressStruct.getStreet();
            item[72] = addressStruct.getHouse();
            item[73] = addressStruct.getFrac();
            item[74] = addressStruct.getFlat();
            if (!contract.isFiz()) {
                item[75] = addressStruct.getIndex();
                item[76] = addressStruct.getCountry();
                item[77] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                item[78] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                item[79] = addressStruct.getCity();
                item[80] = addressStruct.getStreet();
                item[81] = addressStruct.getHouse();
                item[82] = addressStruct.getFrac();
                item[83] = addressStruct.getFlat();
            } else {
                item[75] = "";
                item[76] = "";
                item[77] = "";
                item[78] = "";
                item[79] = "";
                item[80] = "";
                item[81] = "";
                item[82] = "";
                item[83] = "";
            }
            item[84] = addressStruct.getIndex();
            item[85] = addressStruct.getCountry();
            item[86] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[87] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[88] = addressStruct.getCity();
            item[89] = addressStruct.getStreet();
            item[90] = addressStruct.getHouse();
            item[91] = addressStruct.getFrac();
            item[92] = addressStruct.getFlat();
        }
        addressStruct = this.helper.getCommutatorsAddress();
        if (SormUtils.checkValidAddress(addressStruct)) {
            region = SormUtils.getParameterOfCity((Upload)this, addressStruct, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, addressStruct, "zone");
            item[93] = addressStruct.getIndex();
            item[94] = addressStruct.getCountry();
            item[95] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[96] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
            item[97] = addressStruct.getCity();
            item[98] = addressStruct.getStreet();
            item[99] = addressStruct.getHouse();
            item[100] = addressStruct.getFrac();
            item[101] = addressStruct.getFlat();
        } else if (deviceAddress != null) {
            int houseId = deviceAddress.getHouseId();
            House house = ((AddressService)this.serverContext.getService(AddressService.class, 0)).houseGet(houseId);
            item[93] = house.getPostIndex();
            item[94] = house.getCountry() != null ? house.getCountry().getTitle() : "";
            item[95] = "";
            item[96] = "";
            item[97] = house.getCity() != null ? house.getCity().getTitle() : "";
            item[98] = house.getStreet() != null ? house.getStreet().getTitle() : "";
            item[99] = String.valueOf(house.getHouse());
            item[100] = house.getFrac();
            item[101] = deviceAddress.getFlat();
        } else {
            logger.error("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0430\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ID=" + cid);
        }
        return item;
    }

    private String[] getInternalAbonentItem(String[] item, InternalUser internalUser) throws Exception {
        String[] internalItem = Arrays.copyOfRange(item, 0, item.length);
        internalItem[37] = "2";
        internalItem[38] = Utils.maskBlank((String)internalUser.getFirstName(), (String)"");
        internalItem[39] = Utils.maskBlank((String)internalUser.getMiddleName(), (String)"");
        internalItem[40] = Utils.maskBlank((String)internalUser.getLastName(), (String)"");
        internalItem[41] = internalUser.getBirthday() != null ? TimeUtils.format((java.util.Date)internalUser.getBirthday(), (String)"yyyy-MM-dd") : "";
        internalItem[42] = Utils.maskBlank((String)internalUser.getDocumentType(), (String)"");
        internalItem[43] = Utils.maskBlank((String)internalUser.getDocumentSerial(), (String)"");
        internalItem[44] = Utils.maskBlank((String)internalUser.getDocumentNumber(), (String)"");
        String whenGive = internalUser.getDocumentWhenGive() != null ? TimeUtils.format((java.util.Date)internalUser.getDocumentWhenGive(), (String)"yyyy-MM-dd") : "";
        String whoWhenGive = whenGive + " " + Utils.maskBlank((String)internalUser.getDocumentWhoGive(), (String)"");
        internalItem[45] = Utils.maskBlank((String)whoWhenGive, (String)"");
        EntityAttrAddress entityAttrAddress = internalUser.getAddressStruct();
        if (entityAttrAddress != null) {
            int houseId = entityAttrAddress.getHouseId();
            House house = ((AddressService)this.serverContext.getService(AddressService.class, 0)).houseGet(houseId);
            internalItem[66] = house.getPostIndex();
            internalItem[67] = house.getCountry() != null ? house.getCountry().getTitle() : "";
            internalItem[68] = "";
            internalItem[69] = "";
            internalItem[70] = house.getCity() != null ? house.getCity().getTitle() : "";
            internalItem[71] = house.getStreet() != null ? house.getStreet().getTitle() : "";
            internalItem[72] = String.valueOf(house.getHouse());
            internalItem[73] = house.getFrac();
            internalItem[74] = entityAttrAddress.getFlat();
            internalItem[75] = house.getPostIndex();
            internalItem[76] = house.getCountry() != null ? house.getCountry().getTitle() : "";
            internalItem[77] = "";
            internalItem[78] = "";
            internalItem[79] = house.getCity() != null ? house.getCity().getTitle() : "";
            internalItem[80] = house.getStreet() != null ? house.getStreet().getTitle() : "";
            internalItem[81] = String.valueOf(house.getHouse());
            internalItem[82] = house.getFrac();
            internalItem[83] = entityAttrAddress.getFlat();
        } else {
            internalItem[66] = "";
            internalItem[67] = "";
            internalItem[68] = "";
            internalItem[69] = "";
            internalItem[70] = "";
            internalItem[71] = "";
            internalItem[72] = "";
            internalItem[73] = "";
            internalItem[74] = "";
            internalItem[75] = "";
            internalItem[76] = "";
            internalItem[77] = "";
            internalItem[78] = "";
            internalItem[79] = "";
            internalItem[80] = "";
            internalItem[81] = "";
            internalItem[82] = "";
            internalItem[83] = "";
        }
        return internalItem;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.SUPPLEMENT_SERVICES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "service_id", "begin_time", "end_time", "description", "mnemonic"});
            List<ServiceSorm> operatorServices = SormUtils.getSelectedServicesForUpload(this.config);
            for (ServiceSorm service : operatorServices) {
                try {
                    String dateFrom;
                    String[] item = new String[6];
                    item[0] = this.regionId;
                    item[1] = String.valueOf(service.getId());
                    String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                    if (Utils.notBlankString((String)operatorStartDate)) {
                        java.util.Date date = new SimpleDateFormat("dd.MM.yyyy").parse(operatorStartDate);
                        dateFrom = TimeUtils.format((java.util.Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                    } else {
                        dateFrom = "2005-01-01 00:00:00";
                    }
                    item[2] = dateFrom;
                    item[3] = "2037-01-01 00:00:00";
                    item[4] = Utils.maskBlank((String)service.getDescription(), (String)service.getTitle());
                    item[5] = service.getTitle();
                    this.writeItemToFile(item, -1, SignaltekFileTitle.SUPPLEMENT_SERVICES.getTitle(), csvFile);
                }
                catch (Exception ex) {
                    logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 ID=%s, title=%s", service.getId(), service.getTitle()));
                }
            }
        }
        catch (IOException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.SERVICES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "abonent_id", "service_id", "idents_identifier_type", "idents_pager_identifier", "idents_pstn_directory_number", "idents_pstn_internal_number", "idents_gsm_directory_number", "idents_gsm_imsi", "idents_gsm_imei", "idents_gsm_icc", "idents_cdma_directory_number", "idents_cdma_imsi", "idents_cdma_icc", "idents_cdma_esn", "idents_cdma_min", "idents_network_user_equipment_type", "idents_network_user_equipment_mac", "idents_network_user_equipment_vpi", "idents_network_user_equipment_vci", "idents_network_login", "idents_network_ip_address", "idents_network_email", "idents_network_pin", "idents_network_phone_number", "idents_network_user_domain", "idents_network_reserved", "idents_voip_ip_address", "idents_voip_originator_name", "idents_voip_calling_number", "contract", "begin_time", "end_time", "parameter"});
            String idsServices = Utils.toString(SormUtils.getIdsServices(this.config));
            logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0443\u0441\u043b\u0443\u0433\u0438 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043a\u0430\u043a\u0430\u044f-\u043b\u0438\u0431\u043e \u0443\u0441\u043b\u0443\u0433\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: " + idsServices);
            logger.debug("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + this.contracts.size());
            List<InstalledInstanceModule> npayModules = new SormServiceImpl().getInstanceModules("npay");
            logger.debug("\u041c\u043e\u0434\u0443\u043b\u0435\u0439 Npay \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + npayModules.size());
            Map<Integer, List<InetServ>> contractInetServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            for (InstalledInstanceModule npayModule : npayModules) {
                String npayServiceTable = ServerUtils.getModuleTableName((String)"npay_service_object", (int)npayModule.getModuleId());
                String query = "SELECT nso.sid AS sid, s.title AS title, nso.date1 AS date1, nso.date2 AS date2 FROM " + npayServiceTable + " AS nso LEFT JOIN service AS s ON nso.sid=s.id WHERE nso.cid=?";
                if (Utils.notBlankString((String)idsServices)) {
                    query = query + " AND sid IN (" + idsServices + ")";
                }
                PreparedStatement ps = this.con.prepareStatement(query);
                try {
                    for (SormContract contract : this.contracts) {
                        int cid = contract.getContractId();
                        ps.setInt(1, cid);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int serviceId = rs.getInt("sid");
                            Date date1 = rs.getDate("date1");
                            Date date2 = rs.getDate("date2");
                            boolean isInetService = this.inetServices.containsKey(serviceId);
                            if (!isInetService) continue;
                            List inetServList = contractInetServices.getOrDefault(cid, new ArrayList());
                            for (InetServ inetServ : inetServList) {
                                byte[] addressFrom = inetServ.getAddressFrom();
                                InetAddress inetAddress = null;
                                if (addressFrom != null) {
                                    inetAddress = InetAddress.getByAddress(addressFrom);
                                }
                                String ipv4 = inetAddress != null ? SormUtils.ip2Hex(inetAddress.getHostAddress()) : "";
                                String[] item = this.getAbonentServiceItem(cid, serviceId, true, date1, date2, inetServ.getLogin(), ipv4, String.valueOf(inetServ.getId()));
                                this.writeItemToFile(item, cid, SignaltekFileTitle.SERVICES.getTitle(), csvFile);
                            }
                        }
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
        }
        return file;
    }

    private String[] getAbonentServiceItem(int cid, int serviceId, boolean isInetService, java.util.Date date1, java.util.Date date2, String login, String ipv4, String identificator) {
        String[] item = new String[34];
        item[0] = this.regionId;
        item[1] = String.valueOf(cid);
        item[2] = String.valueOf(serviceId);
        item[3] = isInetService ? "4" : "1";
        item[4] = "";
        item[5] = "";
        item[6] = "";
        item[7] = "";
        item[8] = "";
        item[9] = "";
        item[10] = "";
        item[11] = "";
        item[12] = "";
        item[13] = "";
        item[14] = "";
        item[15] = "";
        item[16] = "";
        item[17] = "";
        item[18] = "";
        item[19] = "";
        String login0 = Utils.isBlankString((String)login) ? Utils.maskBlank((String)ipv4, (String)"") : "";
        item[20] = Utils.maskBlank((String)login0, (String)identificator);
        item[21] = Utils.isBlankString((String)login) && Utils.isBlankString((String)identificator) ? Utils.maskBlank((String)ipv4, (String)"") : "";
        item[22] = "";
        item[23] = "";
        item[24] = "";
        item[25] = "";
        item[26] = "";
        item[27] = "";
        item[28] = "";
        item[29] = "";
        item[30] = String.valueOf(cid);
        item[31] = date1 != null && date1.before(new java.util.Date()) ? SormUtils.formatDateToUTC(date1, "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
        item[32] = date2 != null ? SormUtils.formatDateToUTC(date2, "yyyy-MM-dd HH:mm:ss") : "2037-01-01 00:00:00";
        item[33] = "";
        return item;
    }

    @Override
    public Path ipNumbering() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.IP_NUMBERING.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "network_address_type", "network_address", "network_mask", "begin_time", "end_time", "description"});
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ip : entry.getValue()) {
                    String resourceComment = Utils.notBlankString((String)ip.getComment()) ? ip.getComment() : "";
                    IpNet ipNet = IpNet.newInstance((byte[])ip.getAddressFrom(), (byte[])ip.getAddressTo());
                    SubnetUtils subnetUtils = new SubnetUtils(ipNet.toString());
                    SubnetUtils.SubnetInfo info = subnetUtils.getInfo();
                    String[] item = new String[]{this.regionId, "0", Utils.maskBlank((String)info.getAddress(), (String)""), String.valueOf(ipNet.getMask()), ip.getDateFrom() != null ? SormUtils.formatDateToUTC(ip.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", ip.getDateTo() != null ? SormUtils.formatDateToUTC(ip.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "2037-01-01 00:00:00", Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment};
                    this.writeItemToFile(item, -1, SignaltekFileTitle.IP_NUMBERING.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.SWITCHES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            String[] item;
            csvFile.writeNext(new String[]{"telco_id", "network_type", "switch_id", "begin_time", "end_time", "description", "switch_sign", "switch_type", "address_type", "zip", "country", "region", "zone", "city", "street", "building", "build_sect", "apartment"});
            if (this.config.get("sorm.upload.switches.enable", "").equals("1") && this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device<?, ?> device : SormUtils.getInetDevices(this.config, this.serverContext)) {
                    item = this.getSwitchItem(4, device);
                    this.writeItemToFile(item, -1, SignaltekFileTitle.SWITCHES.getTitle(), csvFile);
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1") && this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                for (Device<?, ?> voiceDevice : SormUtils.getVoiceDevices(this.config, this.serverContext)) {
                    item = this.getSwitchItem(3, voiceDevice);
                    this.writeItemToFile(item, -1, SignaltekFileTitle.SWITCHES.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return file;
    }

    private String[] getSwitchItem(int netType, Device<?, ?> device) throws Exception {
        EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(device);
        House house = address != null ? this.houseDao.get(address.getHouseId()) : null;
        java.util.Date dateFrom = device.getDateFrom();
        java.util.Date dateTo = device.getDateTo();
        if (house == null) {
            logger.error(String.format("\u0414\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ID=%s (\u0442\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430=%s) - \u043d\u0435\u0442 \u0430\u0434\u0440\u0435\u0441\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430! \u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e!", device.getId(), netType == 3 ? "\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f" : "\u0418\u043d\u0435\u0442"));
            return null;
        }
        int houseId = house.getId();
        String region = SormUtils.getParameterOfCity((Upload)this, houseId, "region");
        String zone = SormUtils.getParameterOfCity((Upload)this, houseId, "zone");
        String[] item = new String[]{this.regionId, String.valueOf(netType), String.valueOf(device.getId()), dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "2037-01-01 00:00:00", Utils.maskBlank((String)device.getTitle(), (String)"").replaceAll(";", " ").trim(), "", "0", "3", Utils.maskBlank((String)house.getPostIndex(), (String)""), house.getCountry() != null ? Utils.maskBlank((String)house.getCountry().getTitle(), (String)"") : "", Utils.maskBlank((String)region, (String)""), Utils.maskBlank((String)zone, (String)""), house.optCity().map(IdTitle::getTitle).orElse(""), house.optStreet().map(IdTitle::getTitle).orElse(""), String.valueOf(house.getHouse()), "", Utils.maskBlank((String)house.getHouseFrac(), (String)"")};
        return item;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path gateways() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.GATEWAYS.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "gate_id", "begin_time", "end_time", "description", "gate_type", "ip_list", "address_type", "zip", "country", "region", "zone", "city", "street", "building", "build_sect", "apartment"});
            if (!this.config.get("sorm.upload.gateways.enable", "").equals("1")) return file;
            if (!this.checkInstalledModule(UploadModulesTitle.INET)) return file;
            List<Device<?, ?>> inetDevices = SormUtils.getSelectedGateways(this.config, this.serverContext);
            if (logger.isDebugEnabled()) {
                logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432. \u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0448\u043b\u044e\u0437\u043e\u0432: {}", (Object)inetDevices.size());
            }
            Iterator<Device<?, ?>> iterator = inetDevices.iterator();
            while (iterator.hasNext()) {
                Device<?, ?> inetDevice = iterator.next();
                EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(inetDevice);
                House house = address != null ? this.houseDao.get(address.getHouseId()) : null;
                java.util.Date dateFrom = inetDevice.getDateFrom();
                java.util.Date dateTo = inetDevice.getDateTo();
                if (house == null) {
                    logger.error(String.format("\u0414\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ID=%s (\u0442\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430=\u0418\u043d\u0435\u0442) - \u043d\u0435\u0442 \u0430\u0434\u0440\u0435\u0441\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430! \u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e!", inetDevice.getId()));
                    Path path = null;
                    return path;
                }
                int houseId = house.getId();
                String region = SormUtils.getParameterOfCity((Upload)this, houseId, "region");
                String zone = SormUtils.getParameterOfCity((Upload)this, houseId, "zone");
                String[] item = new String[17];
                item[0] = this.regionId;
                item[1] = String.valueOf(inetDevice.getId());
                item[2] = dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
                item[3] = dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "2037-01-01 00:00:00";
                item[4] = Utils.maskBlank((String)inetDevice.getComment(), (String)"");
                item[5] = "7";
                item[6] = Utils.maskBlank((String)inetDevice.getHost(), (String)"");
                item[7] = "3";
                item[8] = Utils.maskBlank((String)house.getPostIndex(), (String)"");
                item[9] = house.getCountry() != null ? Utils.maskBlank((String)house.getCountry().getTitle(), (String)"") : "";
                item[10] = Utils.maskBlank((String)region, (String)"");
                item[11] = Utils.maskBlank((String)zone, (String)"");
                item[12] = house.optCity().map(IdTitle::getTitle).orElse("");
                item[13] = house.optStreet().map(IdTitle::getTitle).orElse("");
                item[14] = String.valueOf(house.getHouse());
                item[15] = "";
                System.out.println(house.getHouseFrac());
                item[16] = Utils.maskBlank((String)house.getHouseFrac(), (String)"");
                this.writeItemToFile(item, -1, SignaltekFileTitle.GATEWAYS.getTitle(), csvFile);
            }
            return file;
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path bunches() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430.");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.BUNCHES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "bunch_id_type", "bunch_gsm", "bunch_mac", "bunch_vpi", "bunch_vci", "bunch_type", "begin_time", "end_time", "description", "switch_id"});
            List<Bunch> bunches = SormUtils.getBunches(this.config);
            logger.info("\u041f\u0443\u0447\u043a\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + bunches.size());
            for (Bunch bunch : bunches) {
                String[] item = new String[11];
                item[0] = this.regionId;
                item[1] = "1";
                item[2] = Utils.maskBlank((String)bunch.getMac(), (String)"");
                item[3] = "";
                item[4] = "";
                item[5] = "";
                int directionalCode = bunch.getDirectional() != null ? bunch.getDirectional().ordinal() : Directional.BIDIRECTIONAL.ordinal();
                item[6] = String.valueOf(directionalCode);
                item[7] = bunch.getDateStart() != null ? SormUtils.formatDateToUTC(bunch.getDateStart(), "yyyy-MM-dd HH:mm:ss") : "";
                item[8] = bunch.getDateEnd() != null ? SormUtils.formatDateToUTC(bunch.getDateEnd(), "yyyy-MM-dd HH:mm:ss") : "";
                item[9] = Utils.maskBlank((String)bunch.getDescription(), (String)"");
                item[10] = Utils.maskBlank((String)bunch.getIdCommutator(), (String)"");
                this.writeItemToFile(item, -1, SignaltekFileTitle.BUNCHES.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path phoneNumbering() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
        resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
        resources.addAll(SormUtils.getUploadPhoneNumberingResources(this.config, this.con));
        logger.debug("\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u0430\u044f \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u044f. \u0412\u0441\u0435\u0433\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432: " + resources.size());
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.PHONE_NUMBERING_PLAN.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "iso_3166_alpha_2", "iso_3166_alpha_3", "country_code", "national_significant_number", "area_code_length", "min_subscr_nr_length", "max_subscr_nr_length", "utc_min", "utc_max", "destination", "operator_type_id", "capacity_from", "capacity_to", "capacity_size", "location", "registrar", "range_activation", "mobile_country_code", "mobile_network_code", "range_deactivation", "range_status", "description", "operating_company_number"});
            logger.debug("\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u0430\u044f \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u044f. \u0412\u0441\u0435\u0433\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432: " + resources.size());
            for (NumberRange numberRange : resources) {
                String phoneNumberPrefix = SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15).substring(1, 4);
                String[] item = new String[]{this.regionId, "ru", "rus", "7", phoneNumberPrefix, String.valueOf(phoneNumberPrefix.length()), "11", "11", "-12", "12", "\u0420\u043e\u0441\u0441\u0438\u044f", "3", String.valueOf(numberRange.getFromNumber()), String.valueOf(numberRange.getToNumber()), String.valueOf(numberRange.getToNumber() - numberRange.getFromNumber() + 1L), this.config.get("sorm.upload.operator.location"), this.config.get("sorm.upload.operator.title"), numberRange.getDateFrom() == null ? "" : SormUtils.formatDateToUTC(numberRange.getDateFrom(), "yyyy-MM-dd HH:mm:ss"), "250", "000", numberRange.getDateTo() == null ? "" : SormUtils.formatDateToUTC(numberRange.getDateTo(), "yyyy-MM-dd HH:mm:ss"), TimeUtils.periodInRange((java.util.Date)new java.util.Date(), (java.util.Date)new java.util.Date(), (java.util.Date)numberRange.getDateFrom(), (java.util.Date)numberRange.getDateTo()) ? "\u0410\u043a\u0442\u0438\u0432\u043d\u0430" : "\u0420\u0435\u0437\u0435\u0440\u0432", Utils.isBlankString((String)numberRange.getComment()) ? "" : numberRange.getComment(), ""};
                this.writeItemToFile(item, -1, SignaltekFileTitle.PHONE_NUMBERING_PLAN.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438: ";
            logger.error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.DOCUMENT_TYPES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "doc_type_id", "begin_time", "end_time", "description"});
            for (IdTitle docType : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{this.regionId, String.valueOf(docType.getId()), "2005-01-01 00:00:00", "2037-01-01 00:00:00", docType.getTitle()};
                this.writeItemToFile(item, -1, SignaltekFileTitle.DOCUMENT_TYPES.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return file;
    }

    @Override
    public Path paymentTypes() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.PAYMENT_TYPES.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "pay_type_id", "begin_time", "end_time", "description"});
            for (PaymentType paymentType : this.paymentsToUpload.getPaymentTypesToUpload()) {
                String[] item = new String[]{this.regionId, String.valueOf(paymentType.getId()), "2005-01-01 00:00:00", "2037-01-01 00:00:00", paymentType.getTitle()};
                this.writeItemToFile(item, -1, SignaltekFileTitle.PAYMENT_TYPES.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentsPayments() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.PAYMENTS.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, StandardCharsets.UTF_8, '\"', ',');){
            csvFile.writeNext(new String[]{"telco_id", "date_time_fillup", "amount", "pay_type", "transaction_bank_account", "transaction_bank_name", "express_card_number", "terminal_id", "terminal_number", "center_id", "telephone_card_number", "transfer_person_recieved", "transfer_bank_name", "transfer_bank_division_name", "transfer_bank_card_id", "transfer_bank_account", "device_identifier_type", "device_pager_identifier", "device_pstn_directory_number", "device_pstn_internal_number", "device_gsm_directory_number", "device_gsm_imsi", "device_gsm_imei", "device_gsm_icc", "device_cdma_directory_number", "device_cdma_imsi", "device_cdma_icc", "device_cdma_esn", "device_cdma_min", "device_network_user_equipment_type", "device_network_user_equipment_mac", "device_network_user_equipment_vpi", "device_network_user_equipment_vci", "device_network_login", "device_network_ip_address", "device_network_email", "device_network_pin", "device_network_phone_number", "device_network_user_domain", "device_network_reserved", "device_voip_ip_address", "device_voip_originator_name", "device_voip_calling_number", "donated_identifier_type", "donated_pager_identifier", "donated_pstn_directory_number", "donated_pstn_internal_number", "donated_gsm_directory_number", "donated_gsm_imsi", "donated_gsm_imei", "donated_gsm_icc", "donated_cdma_directory_number", "donated_cdma_imsi", "donated_cdma_icc", "donated_cdma_esn", "donated_cdma_min", "donated_network_user_equipment_type", "donated_network_user_equipment_mac", "donated_network_user_equipment_vpi", "donated_network_user_equipment_vci", "donated_network_login", "donated_network_ip_address", "donated_network_email", "donated_network_pin", "donated_network_phone_number", "donated_network_user_domain", "donated_network_reserved", "donated_voip_ip_address", "donated_voip_originator_name", "donated_voip_calling_number", "address_type", "address_zip", "address_country", "address_region", "address_zone", "address_city", "address_street", "address_building", "address_build_sect", "address_apartment", "location_type", "location_mobile_lac", "location_mobile_cell", "location_mobile_ta", "location_wireless_cell", "location_wireless_mac", "location_geolocation_latitude_grade", "location_geolocation_longitude_grade", "location_geolocation_projection_type", "location_iplocation_ip_address", "location_iplocation_ip_port", "pay_parameters"});
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + payments.size());
            List<Integer> cids = payments.stream().mapToInt(AbstractBalanceBean::getContractId).boxed().toList();
            Map<Integer, List<InetServ>> inetAbonentServices = SormUtils.getPairsAbonentInetServicesByContractIds(this.config, cids, this.serverContext);
            Map<Integer, List<VoiceAccount>> voiceAccounts = SormUtils.getPairsAbonentVoiceAccountsByContractIds(this.config, cids, this.serverContext);
            for (Payment payment : payments) {
                Contract contract = (Contract)this.contractDao.get(payment.getContractId());
                if (contract == null) continue;
                this.helper.setCurrentContract(contract);
                if (inetAbonentServices.containsKey(payment.getContractId())) {
                    for (InetServ inetServ : inetAbonentServices.get(payment.getContractId())) {
                        if (inetServ.getDateTo() != null && !inetServ.getDateTo().after(new java.util.Date())) continue;
                        String[] item = this.getPaymentItem(payment, 4, inetServ.getLogin(), this.getIPAddressByInetServ(inetServ), inetServ.getEntityAttributes());
                        this.writeItemToFile(item, payment.getContractId(), SignaltekFileTitle.PAYMENTS.getTitle(), csvFile);
                    }
                }
                if (!voiceAccounts.containsKey(payment.getContractId())) continue;
                for (VoiceAccount account : voiceAccounts.get(payment.getContractId())) {
                    if (account.getDateTo() != null && !account.getDateTo().after(new java.util.Date())) continue;
                    String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                    String[] item = this.getPaymentItem(payment, 1, number, "", account.getEntityAttributes());
                    this.writeItemToFile(item, payment.getContractId(), SignaltekFileTitle.PAYMENTS.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    private String[] getPaymentItem(Payment payment, int identType, String identificator, String ipv4, Map<Integer, EntityAttr> deviceAttributes) throws Exception {
        String paymentType = this.paymentsToUpload.getPaymentTypeCodeForSignaltek(payment.getTypeId());
        String[] item = new String[92];
        item[0] = this.regionId;
        item[1] = payment.getDate() != null ? TimeUtils.format((java.util.Date)payment.getDate(), (String)"yyyy-MM-dd HH:mm:ss") : "";
        item[2] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
        item[3] = paymentType;
        item[4] = this.helper.getBankAccount();
        item[5] = this.helper.getBankTitle();
        item[6] = "";
        item[7] = paymentType.equals(SignaltekPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
        item[8] = paymentType.equals(SignaltekPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
        item[9] = paymentType.equals(SignaltekPaymentType.CLIENT_CENTER.getCodeStr()) ? "1" : "";
        item[10] = "";
        item[11] = "";
        item[12] = "";
        item[13] = "";
        item[14] = "";
        item[15] = "";
        item[16] = String.valueOf(identType);
        item[17] = "";
        item[18] = identType == 1 ? Utils.maskBlank((String)identificator, (String)"") : "";
        item[19] = "";
        item[20] = "";
        item[21] = "";
        item[22] = "";
        item[23] = "";
        item[24] = "";
        item[25] = "";
        item[26] = "";
        item[27] = "";
        item[28] = "";
        item[29] = "";
        item[30] = "";
        item[31] = "";
        item[32] = "";
        item[33] = identType == 4 ? Utils.maskBlank((String)identificator, (String)"") : "";
        item[34] = identType == 4 && Utils.isBlankString((String)identificator) ? ipv4 : "";
        item[35] = "";
        item[36] = "";
        item[37] = "";
        item[38] = "";
        item[39] = "";
        item[40] = "";
        item[41] = "";
        item[42] = "";
        item[43] = "";
        item[44] = "";
        item[45] = "";
        item[46] = "";
        item[47] = "";
        item[48] = "";
        item[49] = "";
        item[50] = "";
        item[51] = "";
        item[52] = "";
        item[53] = "";
        item[54] = "";
        item[55] = "";
        item[56] = "";
        item[57] = "";
        item[58] = "";
        item[59] = "";
        item[60] = "4".equals(paymentType) && identType == 4 ? Utils.maskBlank((String)identificator, (String)"") : "";
        item[61] = "4".equals(paymentType) && identType == 4 && Utils.isBlankString((String)identificator) ? ipv4 : "";
        item[62] = "";
        item[63] = "";
        item[64] = "";
        item[65] = "";
        item[66] = "";
        item[67] = "";
        item[68] = "";
        item[69] = "";
        if (paymentType.equals(SignaltekPaymentType.BANK_TRANSACTION.getCodeStr()) || paymentType.equals(SignaltekPaymentType.TERMINAL_PAYMENT.getCodeStr()) || paymentType.equals(SignaltekPaymentType.CLIENT_CENTER.getCodeStr())) {
            EntityAttrAddress deviceAddress = this.getDeviceAddressByAttributes(deviceAttributes);
            if (deviceAddress != null) {
                int houseId = deviceAddress.getHouseId();
                House house = ((AddressService)this.serverContext.getService(AddressService.class, 0)).houseGet(houseId);
                item[70] = "3";
                item[71] = house.getPostIndex();
                item[72] = house.getCountry() != null ? house.getCountry().getTitle() : "";
                item[73] = "";
                item[74] = "";
                item[75] = house.getCity() != null ? house.getCity().getTitle() : "";
                item[76] = house.getStreet() != null ? house.getStreet().getTitle() : "";
                item[77] = String.valueOf(house.getHouse());
                item[78] = house.getFrac();
                item[79] = deviceAddress.getFlat();
            } else {
                AddressStruct addressStruct = this.helper.getAddress();
                if (SormUtils.checkValidAddress(addressStruct)) {
                    String region = SormUtils.getParameterOfCity((Upload)this, addressStruct, "region");
                    String zone = SormUtils.getParameterOfCity((Upload)this, addressStruct, "zone");
                    item[70] = "3";
                    item[71] = addressStruct.getIndex();
                    item[72] = addressStruct.getCountry();
                    item[73] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                    item[74] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                    item[75] = addressStruct.getCity();
                    item[76] = addressStruct.getStreet();
                    item[77] = addressStruct.getHouse();
                    item[78] = addressStruct.getFrac();
                    item[79] = addressStruct.getFlat();
                }
            }
        } else {
            item[70] = "";
            item[71] = "";
            item[72] = "";
            item[73] = "";
            item[74] = "";
            item[75] = "";
            item[76] = "";
            item[77] = "";
            item[78] = "";
            item[79] = "";
        }
        item[80] = "";
        item[81] = "";
        item[82] = "";
        item[83] = "";
        item[84] = "";
        item[85] = "";
        item[86] = "";
        item[87] = "";
        item[88] = "";
        item[89] = "";
        item[90] = "";
        item[91] = PaymentsToUpload.getAdditionalPaymentData(payment);
        return item;
    }

    private String getIPAddressByInetServ(InetServ inetServ) throws UnknownHostException {
        byte[] addressFrom = inetServ.getAddressFrom();
        InetAddress inetAddress = null;
        if (addressFrom != null) {
            inetAddress = InetAddress.getByAddress(addressFrom);
        }
        return inetAddress != null ? inetAddress.getHostAddress() : "";
    }

    @Override
    public Path operatorInfo() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, SignaltekFileTitle.REGIONS.getTitle(), "%s_%tY_%tm_%td_%tH_%tM_%tS.csv");
        try (SormCSVWriter csvWriter = SormUtils.getCSVFile(uploadFile, StandardCharsets.UTF_8, '\"', ',');){
            csvWriter.writeNext(new String[]{"telco_id", "begin_time", "end_time", "description", "mcc", "mnc"});
            String[] item = new String[6];
            item[0] = this.regionId;
            LocalDate startDate = this.config.getLocalDate("sorm.upload.operator.startdate", null);
            item[1] = startDate != null ? SormUtils.formatDateToUTC(TimeUtils.convertLocalDateToDate((LocalDate)startDate), "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
            item[2] = "2037-01-01 00:00:00";
            item[3] = this.config.get("sorm.upload.operator.title") + " " + this.config.get("sorm.upload.operator.location");
            item[4] = "";
            item[5] = "";
            this.writeItemToFile(item, -1, SignaltekFileTitle.REGIONS.getTitle(), csvWriter);
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0444\u0438\u043b\u0438\u0430\u043b\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return uploadFile;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        return Collections.emptyList();
    }
}

