/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.flussonicwatcher.FlussonicWatcherCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.flussonicwatcher.FlussonicWatcherManager;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.flussonicwatcher.FlussonicWatcherCameraDao;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherService")
public class FlussonicWatcherServiceImpl
extends AbstractService
implements FlussonicWatcherService {
    public SearchResult<String> searchOrganizations() throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult();
            FlussonicWatcherManager watcherManager = new FlussonicWatcherManager(this.moduleId);
            List list = searchResult.getList();
            String data = watcherManager.getOrganizations();
            JSONArray organizations = new JSONArray(data == null ? "[]" : data);
            for (int index = 0; index < organizations.length(); ++index) {
                list.add(organizations.getJSONObject(index).toString());
            }
            return searchResult;
        });
    }

    public SearchResult<String> searchCameras() throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult();
            FlussonicWatcherManager watcherManager = new FlussonicWatcherManager(this.moduleId);
            List list = searchResult.getList();
            String data = watcherManager.getCameras();
            JSONArray cameras = new JSONArray(data == null ? "[]" : data);
            for (int index = 0; index < cameras.length(); ++index) {
                list.add(cameras.getJSONObject(index).toString());
            }
            return searchResult;
        });
    }

    public void cameraImport(String cameraModel, String cameraSerials) throws BGException {
        Objects.requireNonNull(cameraModel, "cameraModel must be not null");
        Objects.requireNonNull(cameraSerials, "cameraSerials must be not null");
        List<String> serialList = Arrays.asList(cameraSerials.split("\n"));
        this.tryCall(() -> {
            FlussonicWatcherCameraDao flussonicWatcherCameraDao = new FlussonicWatcherCameraDao(this.getConnection(), this.moduleId);
            for (String serial : serialList) {
                FlussonicWatcherCamera camera = new FlussonicWatcherCamera().setCameraModel(cameraModel).setCameraSerial(serial).setCreateUserId(this.userId).setCreateTime(LocalDateTime.now());
                flussonicWatcherCameraDao.update(camera);
            }
        });
    }

    public String organizationGet(int id) throws BGException {
        return (String)this.tryReturn(() -> new FlussonicWatcherManager(this.moduleId).getOrganization(id));
    }

    public String presets(int organizationId) throws BGException {
        return (String)this.tryReturn(() -> new FlussonicWatcherManager(this.moduleId).getPresets(organizationId));
    }

    public void organizationPresetUpdate(int organizationId, int presetId) throws BGException {
        this.tryCall(() -> new FlussonicWatcherManager(this.moduleId).updateOrganizationPreset(organizationId, presetId));
    }

    public void organizationPresetDelete(int organizationId, int presetId) throws BGException {
        this.tryCall(() -> new FlussonicWatcherManager(this.moduleId).deleteOrganizationPreset(organizationId, presetId));
    }

    public String organizationUsers(int organizationId) throws BGException {
        return (String)this.tryReturn(() -> new FlussonicWatcherManager(this.moduleId).getOrganizationUsers(organizationId));
    }

    public String organizationCameras(int organizationId) throws BGException {
        return (String)this.tryReturn(() -> new FlussonicWatcherManager(this.moduleId).getOrganizationCameras(organizationId));
    }
}

