/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountConfig;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SmartHouseAccountConfigDao
extends AbstractIdDao<SmartHouseAccountConfig> {
    public SmartHouseAccountConfigDao(Connection con, int moduleId) {
        super(con, "smarthouse_account_config", moduleId);
    }

    public void searchAccountConfig(SearchResult<SmartHouseAccountConfig> searchResult, int accountId) throws SQLException {
        ResultSet rs;
        int index;
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Page page = searchResult.getPage();
        ArrayList<SmartHouseAccountConfig> list = new ArrayList<SmartHouseAccountConfig>();
        String query = "SELECT * FROM " + this.tableName + " WHERE account_id=? ORDER BY date_from DESC" + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setInt(index++, accountId);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        searchResult.setList(list);
        if (page != null) {
            query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE account_id=?";
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setInt(index++, accountId);
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        page.setRecordCount(rs.getInt(1));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    protected SmartHouseAccountConfig getFromRS(ResultSet rs) throws SQLException {
        return new SmartHouseAccountConfig().setId(rs.getInt("id")).setAccountId(rs.getInt("account_id")).setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setConfig(rs.getString("account_config")).setCreateUserId(rs.getInt("create_user_id"));
    }

    protected void updateImpl(SmartHouseAccountConfig accountConfig) throws SQLException {
        Objects.requireNonNull(accountConfig, "accountConfig must be not null");
        String querySet = "account_id=?, date_from=?, date_to=?, account_config=?, create_user_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)accountConfig, querySet);){
            int index = 1;
            ps.setInt(index++, accountConfig.getAccountId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)accountConfig.getPeriod().getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)accountConfig.getPeriod().getDateTo()));
            ps.setString(index++, accountConfig.getConfig());
            ps.setInt(index++, accountConfig.getCreateUserId());
            this.executeUpdate((Id)accountConfig, index, ps);
        }
    }
}

