/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.intercom.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Id;

public class ForpostTabPanel
extends BGUPanel {
    private static final String ITEM_USERS = "users";
    private static final String ITEM_CAMERAS = "cameras";
    private static final String ITEM_DEVICES = "devices";
    private static final String ITEM_HOUSES = "houses";
    private static final String ITEM_ENTRANCES = "entrances";
    private static final String ITEM_ACCOUNT_NEW = "AccountNew";
    private static final String ITEM_USER_NEW = "UserNew";
    private static final String ITEM_CAMERA_NEW = "CameraNew";
    private static final String ITEM_DEVICE_NEW = "DeviceNew";
    private static final String ITEM_HOUSE_NEW = "HouseNew";
    private static final String ITEM_ENTRANCE_NEW = "EntranceNew";
    private static final String ITEM_ACCOUNT_EDIT = "AccountEdit";
    private static final String ITEM_ENTITY_EDIT = "entity.edit";
    private static final String ITEM_CACHE_RELOAD = "cacheReload";
    private BGUPanel.WebServiceHolder<ForpostIntercomService> forpostIntercomService = new BGUPanel.WebServiceHolder((BGUPanel)this, ForpostIntercomService.class);
    private BGDataSourceTableModel accountTableModel = new BGDataSourceTableModel("ForpostIntercomAccounts");

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getAccountPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPanel getAccountPanel() {
        BGUTable table = new BGUTable((TableModel)this.accountTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleRMouseClicked((Component)table, e -> {
            if (SwingUtilities.isRightMouseButton(e) && table.getSelectedRow() == table.rowAtPoint(e.getPoint())) {
                this.getPopupMenu().show((Component)table, e.getX(), e.getY());
            }
        });
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)ITEM_ACCOUNT_EDIT);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getAccountToolBarPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
        panel.add((Component)new JLabel("\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAccountToolBarPanel() {
        BGButton addAccount = new BGButton(this.getActionMap().get(ITEM_ACCOUNT_NEW));
        BGButton addUser = new BGButton(this.getActionMap().get(ITEM_USER_NEW));
        BGButton addCamera = new BGButton(this.getActionMap().get(ITEM_CAMERA_NEW));
        BGButton addDevice = new BGButton(this.getActionMap().get(ITEM_DEVICE_NEW));
        BGButton addHouse = new BGButton(this.getActionMap().get(ITEM_HOUSE_NEW));
        BGButton addPod = new BGButton(this.getActionMap().get(ITEM_ENTRANCE_NEW));
        BGButton addSIPAccount = new BGButton("+ SIP \u0430\u043a\u043a\u0430\u0443\u043d\u0442");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addAccount, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)addUser, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)addCamera, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)addDevice, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)addHouse, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)addPod, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)addSIPAccount, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.accountTableModel.loadData((ClientContext)this.getContext(), new BGUTableParams()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_USERS, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438...", e -> new ListDialog("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438", this.getSelectedAccountId(), "User", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomUserEdit(c)).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_CAMERAS, "\u041a\u0430\u043c\u0435\u0440\u044b...", e -> new ListDialog("\u041a\u0430\u043c\u0435\u0440\u044b", this.getSelectedAccountId(), "Camera", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomCameraEdit(c)).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_DEVICES, "\u0414\u043e\u043c\u043e\u0444\u043e\u043d\u044b...", e -> new ListDialog("\u0414\u043e\u043c\u043e\u0444\u043e\u043d\u044b", this.getSelectedAccountId(), "Device", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomDeviceEdit(c)).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_HOUSES, "\u0414\u043e\u043c\u0430...", e -> new ListDialog("\u0414\u043e\u043c\u0430", this.getSelectedAccountId(), "House", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomHouseEdit(c)).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_ENTRANCES, "\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u044b...", e -> new ListDialog("\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u044b", this.getSelectedAccountId(), "Entrance", c -> {}).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_ACCOUNT_NEW, "+ \u0410\u043a\u043a\u0430\u0443\u043d\u0442", e -> new EditDialog("\u041d\u043e\u0432\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442", new Ids(this, 0, 0), "ForpostIntercomAccountEdit", c -> {
            ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomAccountEdit(c);
            this.performAction("refresh");
        }).open());
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_USER_NEW, "+ \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", e -> this.doEditDialog(a -> new EditDialog("\u041d\u043e\u0432\u044b\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", new Ids(this, 0, a.getId()), "ForpostIntercomUserEdit", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomUserEdit(c)).open()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_CAMERA_NEW, "+ \u041a\u0430\u043c\u0435\u0440\u0430", e -> this.doEditDialog(a -> new EditDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430", new Ids(this, 0, a.getId()), "ForpostIntercomCameraEdit", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomCameraEdit(c)).open()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_DEVICE_NEW, "+ \u0414\u043e\u043c\u043e\u0444\u043e\u043d", e -> this.doEditDialog(a -> new EditDialog("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c\u043e\u0444\u043e\u043d", new Ids(this, 0, a.getId()), "ForpostIntercomDeviceEdit", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomDeviceEdit(c)).open()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_HOUSE_NEW, "+ \u0414\u043e\u043c", e -> this.doEditDialog(a -> new EditDialog("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c", new Ids(this, 0, a.getId()), "ForpostIntercomHouseEdit", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomHouseEdit(c)).open()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_ENTRANCE_NEW, "+ \u041f\u043e\u0434\u044a\u0435\u0437\u0434", e -> this.doEditDialog(a -> new EditDialog("\u041d\u043e\u0432\u044b\u0439 \u043f\u043e\u0434\u044a\u0435\u0437\u0434", new Ids(this, 0, a.getId()), "ForpostIntercomEntranceEdit", c -> {}).open()));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, ITEM_ACCOUNT_EDIT, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430...", e -> this.doEditDialog(a -> new EditDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", new Ids(this, a.getId(), 0), "ForpostIntercomAccountEdit", c -> ((ForpostIntercomService)this.forpostIntercomService.get()).forpostIntercomAccountEdit(c)).open()));
        new AbstractBGUPanel.DefaultAction(ITEM_CACHE_RELOAD, "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043a\u0435\u0448\u0435"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomAccountCacheReload(((Id)ForpostTabPanel.this.accountTableModel.getSelectRow(Id.class)).getId());
                ForpostTabPanel.this.performAction("refresh");
            }
        };
    }

    private int getSelectedAccountId() {
        return ((Id)this.accountTableModel.getSelectRow(Id.class)).getId();
    }

    private void doEditDialog(Consumer<Id> consumer) throws Exception {
        Id accountId = (Id)this.accountTableModel.getSelectRow(Id.class);
        if (accountId == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442");
            return;
        }
        consumer.accept(accountId);
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_ACCOUNT_EDIT)));
            this.popupMenu.add(new JPopupMenu.Separator());
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_USERS)));
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_CAMERAS)));
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_DEVICES)));
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_HOUSES)));
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_ENTRANCES)));
            this.popupMenu.add(new JPopupMenu.Separator());
            this.popupMenu.add(new JMenuItem(this.getActionMap().get(ITEM_CACHE_RELOAD)));
        }
        return this.popupMenu;
    }

    class EditDialog
    extends BGEditorDialog<Ids> {
        private EditConsumer<List<KeyValue>> editConsumer;
        private BGDataSourceTableModel tableModel;
        private JTextArea paramInfo;

        public EditDialog(String title, Ids data, String tableModelName, EditConsumer<List<KeyValue>> editConsumer) {
            super(title, (Object)data);
            this.paramInfo = new JTextArea(3, 80);
            this.editConsumer = editConsumer;
            this.tableModel = new BGDataSourceTableModel(tableModelName);
        }

        public void doDialogPanel() {
            BGUTable table = new BGUTable((TableModel)this.tableModel);
            table.setSelectionMode(0);
            table.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.paramInfo.setText(((BGUTableRowData)this.tableModel.getSelectedRow()).optValue("title").orElse(""));
                } else {
                    this.paramInfo.setText("");
                }
            });
            BGSwingUtilites.handleLDMouseClicked((Component)table, e -> new ParamEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (BGUTableRowData)this.tableModel.getSelectedRow()).open());
            this.paramInfo.setMargin(new Insets(3, 3, 3, 3));
            this.paramInfo.setEditable(false);
            this.paramInfo.setLineWrap(true);
            this.paramInfo.setWrapStyleWord(true);
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)1000, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.paramInfo, (int)800, (int)60), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            BGUTableParams tableParams = new BGUTableParams().addParam("id", ((Ids)this.data).id).addParam("accountId", ((Ids)this.data).accountId);
            this.tableModel.loadData((ClientContext)ForpostTabPanel.this.getContext(), tableParams);
        }

        public boolean doApply() throws Exception {
            ArrayList<KeyValue> params = new ArrayList<KeyValue>();
            params.addAll(this.tableModel.getRows().stream().map(a -> new KeyValue(a.optValue("name").orElse(""), a.optValue("value").orElse(""))).toList());
            params.add(new KeyValue("ID", String.valueOf(((Ids)this.data).id)));
            if (((Ids)this.data).accountId > 0) {
                params.add(new KeyValue("AccountID", String.valueOf(((Ids)this.data).accountId)));
            }
            try {
                this.editConsumer.accept(params);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }

    class Ids {
        public int id;
        public int accountId;

        public Ids(ForpostTabPanel this$0, int id, int accountId) {
            this.id = id;
            this.accountId = accountId;
        }
    }

    @FunctionalInterface
    static interface EditConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    class ListDialog
    extends BGEditorDialog<Integer> {
        private String entityName;
        private BGDataSourceTableModel tableModel;
        private BGDialogToolBar toolBar;

        public ListDialog(String title, Integer data, String entityName, EditConsumer<List<KeyValue>> editConsumer) {
            super(title, (Object)data);
            this.entityName = null;
            this.toolBar = new BGDialogToolBar();
            this.entityName = entityName;
            this.tableModel = new BGDataSourceTableModel("ForpostIntercom" + entityName + "s");
            String entityTitle = switch (entityName) {
                case "User" -> "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f";
                case "Camera" -> "\u043a\u0430\u043c\u0435\u0440\u044b";
                case "Device" -> "\u0434\u043e\u043c\u043e\u0444\u043e\u043d\u0430";
                case "House" -> "\u0434\u043e\u043c\u0430";
                case "Entrance" -> "\u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0430";
                default -> entityName;
            };
            new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)ForpostTabPanel.this, ForpostTabPanel.ITEM_ENTITY_EDIT, "", e -> this.edit(entityTitle, editConsumer));
        }

        public void doDialogPanel() {
            this.toolBar.setOrientation(0);
            this.toolBar.setDefaultButtons(e -> {
                switch (BGDialogToolBar.ButtonData.of((String)e.getActionCommand())) {
                    case NEW_ITEM: {
                        ForpostTabPanel.this.performAction(this.entityName + "New");
                        this.loadData();
                        break;
                    }
                    case EDIT_ITEM: {
                        ForpostTabPanel.this.performAction(ForpostTabPanel.ITEM_ENTITY_EDIT);
                        break;
                    }
                    case DELETE_ITEM: {
                        break;
                    }
                }
            }, new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM});
            this.toolBar.setFloatable(false);
            BGUTable table = new BGUTable((TableModel)this.tableModel);
            table.setSelectionMode(0);
            BGSwingUtilites.handleEdit((String)"entity", (JTable)table, (AbstractBGUPanel)ForpostTabPanel.this);
            this.panel.add((Component)this.toolBar, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)1000, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.loadData();
        }

        private void edit(String entityTitle, EditConsumer<List<KeyValue>> editConsumer) throws Exception {
            this.doEditDialog(a -> new EditDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 " + entityTitle, new Ids(ForpostTabPanel.this, a.getId(), (Integer)this.data), "ForpostIntercom" + this.entityName + "Edit", editConsumer).open());
            this.loadData();
        }

        private void loadData() {
            BGUTableParams tableParams = new BGUTableParams().addParam("accountId", String.valueOf(this.data));
            this.tableModel.loadData((ClientContext)ForpostTabPanel.this.getContext(), tableParams);
        }

        private void doEditDialog(Consumer<Id> consumer) throws Exception {
            Id entityId = (Id)this.tableModel.getSelectRow(Id.class);
            if (entityId == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
                return;
            }
            consumer.accept(entityId);
        }
    }

    @FunctionalInterface
    static interface EditSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    static interface EditFunction<T, V> {
        public V apply(T var1) throws Exception;
    }

    class ParamEditor
    extends BGEditorDialog<BGUTableRowData> {
        private JToggleButton buttonOn;
        private JToggleButton buttonOff;
        private ButtonGroup buttonGroup;
        private BGUComboBox<KeyValue> groupComboBox;
        private BGUComboBox<KeyValue> comboBox;
        private BGTextField paramName;
        private BGTextField paramType;
        private BGTextField paramValue;
        private JTextArea paramInfo;

        public ParamEditor(String title, BGUTableRowData data) {
            super(title, (Object)data);
            this.buttonOn = new JToggleButton("1 - \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
            this.buttonOff = new JToggleButton("0 - \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
            this.buttonGroup = new ButtonGroup();
            this.groupComboBox = new BGUComboBox();
            this.comboBox = new BGUComboBox();
            this.paramName = new BGTextField(40);
            this.paramType = new BGTextField(40);
            this.paramValue = new BGTextField(40);
            this.paramInfo = new JTextArea(4, 40);
        }

        public void doDialogPanel() {
            Color bgColor = this.paramName.getBackground();
            this.paramName.setHorizontalAlignment(0);
            this.paramName.setEditable(false);
            this.paramName.setBackground(bgColor);
            this.paramType.setHorizontalAlignment(0);
            this.paramType.setEditable(false);
            this.paramType.setBackground(bgColor);
            this.paramValue.setHorizontalAlignment(0);
            this.paramInfo.setEditable(false);
            this.paramInfo.setLineWrap(true);
            this.paramInfo.setWrapStyleWord(true);
            this.paramInfo.setMargin(new Insets(3, 3, 3, 3));
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.paramName);
            this.addFieldV("\u0422\u0438\u043f:", (JComponent)this.paramType);
            Object component = this.paramValue;
            String type = ((BGUTableRowData)this.data).optValue("type").orElse(null);
            String value = ((BGUTableRowData)this.data).optValue("value").orElse("");
            if (!"text".equals(type)) {
                if ("0/1".equals(type)) {
                    component = this.getOnOffPanel(value);
                } else if (!"integer".equals(type) && !"ip".equals(type) && type.startsWith("list:")) {
                    component = this.comboBox;
                    String listName = type.substring(5);
                    if ("device_type".equals(listName)) {
                        component = this.getListSubListPanel(value, "\u0413\u0440\u0443\u043f\u043f\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432:", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e:", a -> ((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomDeviceTypeGroupIdByDeviceType(a.intValue()), a -> ((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomDeviceTypeList(a.intValue()), () -> ((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomDeviceTypeGroupList());
                    } else {
                        try {
                            ArrayList<KeyValue> items = new ArrayList<KeyValue>();
                            items.add(new KeyValue("", "====="));
                            switch (listName) {
                                case "master": {
                                    items.addAll(((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomMasterList());
                                    break;
                                }
                                case "protocol": {
                                    items.addAll(((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomProtocolList());
                                    break;
                                }
                                case "record_type": {
                                    items.addAll(((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomRecordTypeList());
                                    break;
                                }
                                case "rtsp_transport": {
                                    items.addAll(((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomRtspTransportList());
                                    break;
                                }
                                case "camera_model": {
                                    items.addAll(((ForpostIntercomService)ForpostTabPanel.this.forpostIntercomService.get()).forpostIntercomCameraModelList(true));
                                    break;
                                }
                            }
                            this.comboBox.setData(items);
                            this.comboBox.setSelectedItem((Object)items.stream().filter(a -> a.getKey().equals(value)).findFirst().orElse((KeyValue)items.get(0)));
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                }
            }
            this.addFieldV("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:", (JComponent)component);
            this.addFieldV("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", BGSwingUtilites.wrapScrollPane((JComponent)this.paramInfo, (int)500, (int)70));
            this.paramName.setText(((BGUTableRowData)this.data).optValue("name").orElse("???"));
            this.paramType.setText(type.toUpperCase());
            this.paramValue.setText(value);
            this.paramInfo.setText(((BGUTableRowData)this.data).optValue("title").orElse(""));
        }

        public boolean doApply() throws Exception {
            String type = ((BGUTableRowData)this.data).optValue("type").orElse(null);
            String value = this.paramValue.getText();
            if (!"text".equals(type)) {
                if ("0/1".equals(type)) {
                    value = this.buttonGroup.getSelection().getActionCommand();
                } else if ("integer".equals(type)) {
                    if (!value.matches("\\d+")) {
                        ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0446\u0435\u043b\u044b\u043c");
                        return false;
                    }
                } else if ("ip".equals(type)) {
                    if (!value.matches("((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}")) {
                        ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 X.X.X.X");
                        return false;
                    }
                } else if (type.startsWith("list:")) {
                    value = ((KeyValue)this.comboBox.getSelectedItem()).getKey();
                }
            }
            ((BGUTableRowData)this.data).setValue("value", value);
            return true;
        }

        private JPanel getListSubListPanel(String value, String title1, String title2, EditFunction<Integer, Integer> getGroupId, EditFunction<Integer, List<KeyValue>> getListItems, EditSupplier<List<KeyValue>> getGroupItems) {
            try {
                List<KeyValue> groupItems = getGroupItems.get();
                String groupId = String.valueOf(getGroupId.apply(Utils.parseInt((String)value)));
                this.groupComboBox.setData(groupItems);
                this.groupComboBox.setSelectedItem((Object)groupItems.stream().filter(a -> a.getKey().equals(groupId)).findFirst().orElse(groupItems.get(0)));
                ArrayList<KeyValue> items = new ArrayList<KeyValue>();
                items.add(new KeyValue("0", "====="));
                items.addAll((Collection)getListItems.apply(Utils.parseInt((String)((KeyValue)this.groupComboBox.getSelectedItem()).getKey())));
                this.comboBox.setData(items);
                this.comboBox.setSelectedItem((Object)items.stream().filter(a -> a.getKey().equals(value)).findFirst().orElse((KeyValue)items.get(0)));
                this.groupComboBox.addItemListener(ForpostTabPanel.this.comboBoxSelect(e -> this.tryCall(() -> {
                    ArrayList<KeyValue> listItems = new ArrayList<KeyValue>();
                    listItems.add(new KeyValue("0", "====="));
                    listItems.addAll((Collection)getListItems.apply(Utils.parseInt((String)((KeyValue)this.groupComboBox.getSelectedItem()).getKey())));
                    this.comboBox.setData(listItems);
                })));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(title1), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.groupComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(title2), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.comboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getOnOffPanel(String value) {
            this.buttonGroup.add(this.buttonOff);
            this.buttonGroup.add(this.buttonOn);
            this.buttonOn.setActionCommand("1");
            this.buttonOff.setActionCommand("0");
            this.buttonOn.setSelected("1".equals(value));
            this.buttonOff.setSelected("0".equals(value));
            JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
            panel.add(this.buttonOff);
            panel.add(this.buttonOn);
            return panel;
        }
    }
}

