/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.task;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;

public class RSCMCalculator
extends TaskBase {
    private Calendar startMonth;
    private Calendar stopMonth;
    private String cids;
    private PeriodicErrorManager errorManager;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RSCM. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + "." + (String)(this.cids != null ? " \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids + "." : "") + " \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM");
    }

    public void setCids(String contractIds) {
        this.cids = contractIds;
    }

    protected boolean initTask() {
        GregorianCalendar now;
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.add(11, -1);
        TimeUtils.floor((Calendar)this.startMonth, (int)2);
        this.stopMonth = (Calendar)this.startMonth.clone();
        this.stopMonth.add(2, 1);
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        boolean notCalculateFutureServices = moduleSetup.getBoolean("not.calculate.future.services", false);
        if (notCalculateFutureServices && (now = new GregorianCalendar()).before(this.stopMonth)) {
            this.stopMonth = now;
            this.stopMonth.add(5, 1);
            TimeUtils.floor((Calendar)this.stopMonth, (int)5);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        BGNestedContext.push((String)"rscm");
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            try {
                Period period = new Period(this.startMonth.getTime(), this.stopMonth.getTime());
                RscmTariffContext rscmTariffContext = new RscmTariffContext(period, this.moduleId, connectionSet);
                this.errorManager = new PeriodicErrorManager(connectionSet.getConnection());
                this.errorManager.initErrorMessage(this.moduleId, "RSCM", String.valueOf(this.moduleId), this.startMonth.getTime());
                RSCMCalculatorUtils.doCalc(rscmTariffContext, Utils.toIntegerList((String)this.cids), this.errorManager, this.getLogger());
            }
            finally {
                if (Utils.isBlankString((String)this.cids)) {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.errorManager.processErrors();
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.error = e;
        }
        BGNestedContext.pop();
    }
}

