/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.action.apps;

import bitel.billing.common.VersionInfo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.plugin.PluginTreeNodeInterface;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.AbstractAction;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobContractData;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileMenuItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ActionMainTree
extends AbstractAction {
    private static String escapeSymbols = "\u00e5\u0153\u00ac";

    public void execute() throws Exception {
        MobContractData contractData = new MobContractData(this.contract);
        BalanceUtils balanceUtils = new BalanceUtils(this.con);
        contractData.setBalance(balanceUtils.getBalance(new Date(), this.contract));
        balanceUtils.close();
        ContractTariff contractTariff = this.getTariff();
        if (contractTariff != null) {
            contractData.setTariffDateFrom(TimeUtils.format((Date)contractTariff.getPeriod().getDateFrom(), (String)"dd.MM.yyyy"));
            contractData.setTariffDateTo(TimeUtils.format((Date)contractTariff.getPeriod().getDateTo(), (String)"dd.MM.yyyy"));
            contractData.setContractTariff(contractTariff);
            TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);
            TariffPlan tariffPlan = (TariffPlan)tariffPlanDao.get(contractTariff.getTariffPlanId());
            if (tariffPlan != null) {
                contractData.setTariffTitle(tariffPlan.getTitleWeb());
            }
            tariffPlanDao.close();
        }
        contractData.setServerDate(new Date());
        contractData.setAbsoluteServerDate(TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm:ss"));
        contractData.setMenuItems(this.getMenu(this.moduleSetup.get("menu.items", null)));
        contractData.setVi(VersionInfo.getVersionInfo((String)"mobile"));
        contractData.setPaymentModules(this.getPaymentModules(this.moduleSetup.get("payment.modules", null)));
        if (this.moduleSetup.getBoolean("showSubContracts", false) && this.contract.isSuper()) {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                ContractModuleManager moduleManager = new ContractModuleManager(this.con);
                ArrayList<IdTitle> subList = new ArrayList<IdTitle>();
                for (Contract sub : contractDao.getSubContracts(this.contract.getId(), -1)) {
                    if (!moduleManager.getContractModuleSet(sub.getId()).contains(this.moduleId)) continue;
                    subList.add(new IdTitle(sub.getId(), sub.getTitle()));
                }
                contractData.setSubContractList(subList);
            }
        }
        this.initParams(contractData);
        ArrayList<String> pluginsIds = new ArrayList<String>();
        if (BGPluginManagerServer.getManager().getPluginsMap().keySet().contains("ru.bitel.bgbilling.plugins.helpdesk")) {
            pluginsIds.add("ru.bitel.bgbilling.plugins.helpdesk");
            for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions("ru.bitel.bgbilling.modules.mobile.server.action.apps.ActionMainTree", true)) {
                try {
                    NodeList list = extension.getElement().getElementsByTagName("treeNode");
                    Element treeNode = (Element)list.item(0);
                    PluginTreeNodeInterface node = (PluginTreeNodeInterface)Class.forName(treeNode.getAttribute("class")).getConstructor(new Class[0]).newInstance(new Object[0]);
                    int count = Utils.parseInt((String)node.getValue((ServerContext)this.context, this.contract.getId()), (int)-1);
                    if (count > 0) {
                        contractData.getParams().put("unreadMessages", count);
                    }
                    System.out.println("Count Message Unread: " + node.getValue((ServerContext)this.context, this.contract.getId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        contractData.setPluginsIdList(pluginsIds);
        this.dataMap.put(this.action, contractData);
    }

    public ContractTariff getTariff() throws Exception {
        ContractTariff contractTariff = null;
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
        List tariffs = contractTariffDao.list(this.contractId, LocalDate.now());
        if (tariffs.size() == 1) {
            contractTariff = (ContractTariff)tariffs.get(0);
        } else if (tariffs.size() > 1) {
            contractTariff = (ContractTariff)tariffs.get(0);
            TariffGroupDao groupDao = new TariffGroupDao(this.con);
            groupDao.close();
        }
        return contractTariff;
    }

    private List<MobileMenuItem> getMenu(String menu) {
        List<MobAttribute> list = this.getMobListAttribute(menu);
        if (list == null) {
            return null;
        }
        ArrayList<MobileMenuItem> menuList = new ArrayList<MobileMenuItem>();
        for (MobAttribute attr : list) {
            String subItemStr;
            Long groupMask;
            if (Utils.isBlankString((String)attr.getName()) || (groupMask = Long.valueOf(Utils.parseLong((String)attr.getParams().get("groupMask"), (long)0L))) != 0L && (this.contract.getGroups() & groupMask) == 0L) continue;
            List<MobileMenuItem> subItems = null;
            String subItemsKey = attr.getParams().get("subItems");
            if (Utils.notBlankString((String)subItemsKey) && Utils.notBlankString((String)(subItemStr = this.moduleSetup.get("menu.subItem." + subItemsKey)))) {
                subItems = this.getMenu(subItemStr);
            }
            menuList.add(new MobileMenuItem(attr.getName(), attr.getParams().get("title"), subItems));
        }
        return menuList;
    }

    private void initParams(MobContractData contractData) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<MobAttribute> aboutList = this.getMobListAttribute(this.moduleSetup.get("about.items", null));
        if (aboutList != null && aboutList.size() > 0) {
            aboutList.forEach(item -> {
                String subject;
                if ("email".equals(item.name) && Utils.notBlankString((String)(subject = item.params.get("subject")))) {
                    item.params.put("subject", subject.replaceAll("@contractTitle", this.contract.getTitle()));
                }
            });
            params.put("aboutItems", aboutList);
        }
        contractData.setParams(params);
    }

    private List<Map<String, String>> getPaymentModules(String config) throws Exception {
        List<MobAttribute> list = this.getMobListAttribute(config);
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, String>> paymentModules = new ArrayList<Map<String, String>>();
        Set moduleSet = new ContractModuleManager(this.con).getContractModuleSet(this.contractId);
        for (MobAttribute attr : list) {
            int mid = Utils.parseInt((String)attr.getParams().get("moduleId"), (int)-1);
            boolean isSber = false;
            if (!moduleSet.contains(mid) && !(isSber = "sberdeeplink".equals(attr.getName()))) continue;
            attr.getParams().put("module", attr.getName());
            paymentModules.add(attr.getParams());
            if (!isSber) continue;
            ArrayList linkArray = new ArrayList();
            this.moduleSetup.sub("payment.sberdeeplink").entrySet().forEach(entry -> linkArray.add((String)entry.getValue()));
            attr.getParams().put("link", Utils.toString(linkArray));
        }
        return paymentModules;
    }

    private List<MobAttribute> getMobListAttribute(String info) {
        if (Utils.isBlankString((String)info)) {
            return null;
        }
        ArrayList<MobAttribute> list = new ArrayList<MobAttribute>();
        for (String itemStr : info.split(";")) {
            MobAttribute item = MobAttribute.getInstance(itemStr);
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    private static class MobAttribute {
        private String name;
        private Map<String, String> params = new HashMap<String, String>();

        private MobAttribute() {
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        static MobAttribute getInstance(String itemStr) {
            if (Utils.isBlankString((String)itemStr)) {
                return null;
            }
            MobAttribute attr = new MobAttribute();
            int indexOpen = itemStr.indexOf("[");
            if (indexOpen == -1) {
                attr.name = itemStr;
            } else {
                attr.name = itemStr.substring(0, indexOpen);
                int indexClose = itemStr.indexOf("]");
                if (indexClose > -1) {
                    String attributesStr = itemStr.substring(indexOpen + 1, indexClose);
                    attributesStr = attributesStr.replaceAll("\\\\,", escapeSymbols);
                    attr.params = Utils.stringToPairsHash((String)attributesStr);
                    attr.params.replaceAll((key, value) -> value.replaceAll(escapeSymbols, ","));
                }
            }
            attr.name = attr.name.trim();
            return attr;
        }
    }
}

